/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.tiff.filemanagement;

import com.aspose.imaging.StreamContainer;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.TiffSRational;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.az;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.ap.g;
import com.aspose.imaging.internal.ap.x;
import com.aspose.imaging.internal.dP.bg;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.system.io.Stream;
import java.util.Arrays;

public class TiffStreamReader {
    private StreamContainer a;
    private byte[] b;
    private int c;
    private final long d;
    private boolean e = true;

    public TiffStreamReader(byte[] data) {
        this(data, 0, data != null ? data.length : 0);
    }

    public TiffStreamReader(byte[] data, int startIndex) {
        this(data, startIndex, data != null ? data.length : 0);
    }

    public TiffStreamReader(byte[] data, int startIndex, int dataLength) {
        if (data == null) {
            throw new ArgumentNullException("data");
        }
        if (startIndex < 0) {
            throw new ArgumentOutOfRangeException("startIndex", "The start index should be positive number.");
        }
        if (startIndex >= data.length && dataLength > 0) {
            throw new ArgumentOutOfRangeException("startIndex", "The start index should be less than the byte array data length.");
        }
        if (dataLength < 0) {
            throw new ArgumentOutOfRangeException("dataLength", "The data length should be positive number.");
        }
        if (startIndex + dataLength > data.length) {
            throw new ArgumentOutOfRangeException("dataLength", "The data length is out of byte array bounds.");
        }
        this.b = data;
        this.c = startIndex;
        this.d = dataLength;
    }

    public TiffStreamReader(StreamContainer streamContainer) {
        this.a = streamContainer;
        this.d = streamContainer.getLength();
    }

    public long getLength() {
        return this.d;
    }

    public boolean getThrowExceptions() {
        return this.e;
    }

    public void setThrowExceptions(boolean value) {
        this.e = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long readBytes(byte[] array, int arrayIndex, long position, long count) {
        if (array == null) {
            throw new ArgumentNullException("array");
        }
        long l2 = array.length;
        if (count + (long)arrayIndex > l2) {
            throw new ArgumentOutOfRangeException("count", "The number of bytes to retrieve exceeds the array bounds.");
        }
        if (position < 0L) {
            throw new ArgumentOutOfRangeException("position", "Incorrect position specified. Must be positive number.");
        }
        long l3 = position + (long)this.c;
        long l4 = position + count;
        long l5 = bF.a(0L, count - bF.a(0L, l4 - this.d));
        if (this.b != null) {
            TiffStreamReader tiffStreamReader = this;
            synchronized (tiffStreamReader) {
                System.arraycopy(this.b, (int)l3, array, arrayIndex, (int)l5);
            }
        }
        Object object = this.a.getSyncRoot();
        synchronized (object) {
            long l6 = this.a.getPosition();
            this.a.seek(position, 0);
            if ((long)this.a.read(array, arrayIndex, (int)l5) != l5) {
                throw new ArgumentOutOfRangeException("count", aY.a(new String[]{"Cannot read ", az.b(l5), " bytes from stream."}));
            }
            this.a.setPosition(l6);
        }
        return l5;
    }

    public byte[] readBytes(long position, long count) {
        byte[] byArray = new byte[(int)count];
        this.readBytes(byArray, 0, position, count);
        return byArray;
    }

    public double readDouble(long position) {
        double[] dArray = this.readDoubleArray(position, 1L);
        double d2 = 0.0;
        if (dArray != null && dArray.length == 1) {
            d2 = dArray[0];
        }
        return d2;
    }

    public double[] readDoubleArray(long position, long count) {
        double[] dArray = null;
        long l2 = count * 8L;
        if (l2 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aY.a("Total bytes count is negative. ", az.b(count), "x8=", az.b(l2)));
            }
        } else {
            byte[] byArray = this.readBytes(position, l2);
            if (byArray != null) {
                dArray = this.processReadDataDouble(byArray);
            }
        }
        return dArray;
    }

    public float readFloat(long position) {
        float[] fArray = this.readFloatArray(position, 1L);
        float f2 = 0.0f;
        if (fArray != null && fArray.length == 1) {
            f2 = fArray[0];
        }
        return f2;
    }

    public float[] readFloatArray(long position, long count) {
        float[] fArray = null;
        long l2 = count * 4L;
        if (l2 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aY.a("Total bytes count is negative. ", az.b(count), "x4=", az.b(l2)));
            }
        } else {
            byte[] byArray = this.readBytes(position, l2);
            if (byArray != null) {
                fArray = this.processReadDataFloat(byArray);
            }
        }
        return fArray;
    }

    public TiffRational readRational(long position) {
        TiffRational[] tiffRationalArray = this.readRationalArray(position, 1L);
        TiffRational tiffRational = null;
        if (tiffRationalArray != null && tiffRationalArray.length == 1) {
            tiffRational = tiffRationalArray[0];
        }
        return tiffRational;
    }

    public TiffSRational readSRational(long position) {
        TiffSRational[] tiffSRationalArray = this.readSRationalArray(position, 1L);
        TiffSRational tiffSRational = null;
        if (tiffSRationalArray != null && tiffSRationalArray.length == 1) {
            tiffSRational = tiffSRationalArray[0];
        }
        return tiffSRational;
    }

    public TiffRational[] readRationalArray(long position, long count) {
        TiffRational[] tiffRationalArray = null;
        long l2 = count * 8L;
        if (l2 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aY.a("Total bytes count is negative. ", az.b(count), "x8=", az.b(l2)));
            }
        } else {
            byte[] byArray = this.readBytes(position, l2);
            if (byArray != null) {
                long[] lArray = this.processReadDataULong(byArray);
                tiffRationalArray = new TiffRational[(int)count];
                int n2 = 0;
                while ((long)n2 < count) {
                    tiffRationalArray[n2] = new TiffRational(lArray[n2 * 2], lArray[n2 * 2 + 1]);
                    ++n2;
                }
            }
        }
        return tiffRationalArray;
    }

    public TiffSRational[] readSRationalArray(long position, long count) {
        TiffSRational[] tiffSRationalArray = null;
        long l2 = count * 8L;
        if (l2 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aY.a("Total bytes count is negative. ", az.b(count), "x8=", az.b(l2)));
            }
        } else {
            byte[] byArray = this.readBytes(position, l2);
            if (byArray != null) {
                int[] nArray = this.processReadDataLong(byArray);
                tiffSRationalArray = new TiffSRational[(int)count];
                int n2 = 0;
                while ((long)n2 < count) {
                    tiffSRationalArray[n2] = new TiffSRational(nArray[n2 * 2], nArray[n2 * 2 + 1]);
                    ++n2;
                }
            }
        }
        return tiffSRationalArray;
    }

    public byte readSByte(long position) {
        byte[] byArray = this.readSByteArray(position, 1L);
        byte by2 = 0;
        if (byArray != null && byArray.length == 1) {
            by2 = byArray[0];
        }
        return by2;
    }

    public byte[] readSByteArray(long position, long count) {
        byte[] byArray = null;
        byte[] byArray2 = this.readBytes(position, count);
        if (byArray2 != null) {
            byArray = new byte[(int)count];
            if (count <= Integer.MAX_VALUE) {
                x.a(g.a((Object)byArray2), 0, g.a((Object)byArray), 0, (int)count);
            } else {
                x.a(g.a((Object)byArray2), 0, g.a((Object)byArray), 0, Integer.MAX_VALUE);
                long l2 = count - Integer.MAX_VALUE;
                long l3 = Integer.MAX_VALUE;
                long l4 = 0L;
                while ((l4 & 0xFFFFFFFFL) < l2) {
                    byArray[(int)l3] = byArray2[(int)l3];
                    ++l3;
                    ++l4;
                }
            }
        }
        return byArray;
    }

    public int readSLong(long position) {
        int[] nArray = this.readSLongArray(position, 1L);
        int n2 = 0;
        if (nArray != null && nArray.length == 1) {
            n2 = nArray[0];
        }
        return n2;
    }

    public int[] readSLongArray(long position, long count) {
        int[] nArray = null;
        long l2 = count * 4L;
        if (l2 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aY.a("Total bytes count is negative. ", az.b(count), "x4=", az.b(l2)));
            }
        } else {
            byte[] byArray = this.readBytes(position, l2);
            if (byArray != null) {
                nArray = this.processReadDataLong(byArray);
            }
        }
        return nArray;
    }

    public short readSShort(long position) {
        short[] sArray = this.readSShortArray(position, 1L);
        short s2 = 0;
        if (sArray != null && sArray.length == 1) {
            s2 = sArray[0];
        }
        return s2;
    }

    public short[] readSShortArray(long position, long count) {
        short[] sArray = null;
        long l2 = count * 2L;
        if (l2 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aY.a("Total bytes count is negative. ", az.b(count), "x2=", az.b(l2)));
            }
        } else {
            byte[] byArray = this.readBytes(position, l2);
            if (byArray != null) {
                sArray = this.processReadDataShort(byArray);
            }
        }
        return sArray;
    }

    public long readULong(long position) {
        long[] lArray = this.readULongArray(position, 1L);
        long l2 = 0L;
        if (lArray != null && lArray.length == 1) {
            l2 = lArray[0];
        }
        return l2;
    }

    public long[] readULongArray(long position, long count) {
        long[] lArray = null;
        long l2 = count * 4L;
        if (l2 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aY.a("Total bytes count is negative. ", az.b(count), "x4=", az.b(l2)));
            }
        } else {
            byte[] byArray = this.readBytes(position, l2);
            if (byArray != null) {
                lArray = this.processReadDataULong(byArray);
            }
        }
        return lArray;
    }

    public int readUShort(long position) {
        int[] nArray = this.readUShortArray(position, 1L);
        int n2 = 0;
        if (nArray != null && nArray.length == 1) {
            n2 = nArray[0];
        }
        return n2;
    }

    public int[] readUShortArray(long position, long count) {
        int[] nArray = null;
        long l2 = count * 2L;
        if (l2 < 0L) {
            if (this.e) {
                throw new ArgumentOutOfRangeException("count", aY.a("Total bytes count is negative. ", az.b(count), "x2=", az.b(l2)));
            }
        } else {
            byte[] byArray = this.readBytes(position, l2);
            if (byArray != null) {
                nArray = this.processReadDataUShort(byArray);
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamContainer toStreamContainer(long startPosition) {
        StreamContainer streamContainer;
        Stream stream = this.a == null ? null : this.a.a();
        Object object = bg.a(stream);
        synchronized (object) {
            if (this.b != null) {
                int n2 = (int)(this.d - startPosition);
                MemoryStream memoryStream = new MemoryStream(this.b, this.c + (int)startPosition, n2);
                streamContainer = new StreamContainer(memoryStream, true);
            } else {
                this.a.seek(startPosition, 0);
                Stream stream2 = this.a.a();
                streamContainer = new StreamContainer(stream2);
            }
        }
        return streamContainer;
    }

    protected double[] processReadDataDouble(byte[] data) {
        double[] dArray = new double[data.length / 8];
        x.a(g.a((Object)data), 0, g.a((Object)dArray), 0, data.length);
        return dArray;
    }

    protected float[] processReadDataFloat(byte[] data) {
        float[] fArray = new float[data.length / 4];
        x.a(g.a((Object)data), 0, g.a((Object)fArray), 0, data.length);
        return fArray;
    }

    protected int[] processReadDataLong(byte[] data) {
        int[] nArray = new int[data.length / 4];
        x.a(g.a((Object)data), 0, g.a((Object)nArray), 0, data.length);
        return nArray;
    }

    protected short[] processReadDataShort(byte[] data) {
        short[] sArray = new short[data.length / 2];
        x.a(g.a((Object)data), 0, g.a((Object)sArray), 0, data.length);
        return sArray;
    }

    protected long[] processReadDataULong(byte[] data) {
        if (data.length == 0) {
            return new long[0];
        }
        byte[] byArray = new byte[data.length * 2];
        Arrays.fill(byArray, (byte)0);
        long[] lArray = new long[data.length / 4];
        for (int i2 = 0; i2 < data.length / 4; ++i2) {
            System.arraycopy(data, i2 * 4, byArray, i2 * 8, 4);
        }
        x.a(g.a((Object)byArray), 0, g.a((Object)lArray), 0, byArray.length);
        return lArray;
    }

    protected int[] processReadDataUShort(byte[] data) {
        if (data.length == 0) {
            return new int[0];
        }
        byte[] byArray = new byte[data.length * 2];
        Arrays.fill(byArray, (byte)0);
        int[] nArray = new int[data.length / 2];
        for (int i2 = 0; i2 < data.length / 2; ++i2) {
            System.arraycopy(data, i2 * 2, byArray, i2 * 4, 2);
        }
        x.a(g.a((Object)byArray), 0, g.a((Object)nArray), 0, byArray.length);
        return nArray;
    }
}

