/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.fileformats.webp;

import com.aspose.imaging.Color;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.IRasterImagePixelLoader;
import com.aspose.imaging.Image;
import com.aspose.imaging.ImageResizeSettings;
import com.aspose.imaging.RasterCachedImage;
import com.aspose.imaging.RasterImage;
import com.aspose.imaging.Rectangle;
import com.aspose.imaging.coreexceptions.ImageException;
import com.aspose.imaging.fileformats.webp.IFrame;
import com.aspose.imaging.fileformats.webp.WebPFrameBlock;
import com.aspose.imaging.imagefilters.filteroptions.FilterOptionsBase;
import com.aspose.imaging.imageoptions.WebPOptions;
import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NullReferenceException;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.ay;
import com.aspose.imaging.internal.dP.ah;
import com.aspose.imaging.internal.gk.d;
import com.aspose.imaging.internal.gk.g;
import com.aspose.imaging.internal.gk.i;
import com.aspose.imaging.internal.gk.j;
import com.aspose.imaging.internal.gl.a;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.FileStream;
import com.aspose.imaging.system.io.Stream;
import java.io.InputStream;

public class WebPImage
extends RasterCachedImage {
    private final List<IFrame> e = new List();
    private final boolean f = ah.a();
    private WebPFrameBlock g;
    private WebPOptions h;

    public WebPImage(InputStream stream) {
        this(Stream.fromJava(stream));
    }

    WebPImage(Stream stream) {
        this(new WebPOptions());
        this.f(stream);
        this.h();
    }

    public WebPImage(String path) {
        this(new WebPOptions());
        FileStream fileStream = new FileStream(path, 3);
        try {
            this.f(fileStream);
        }
        finally {
            if (fileStream != null) {
                fileStream.dispose();
            }
        }
        this.h();
    }

    public WebPImage(RasterImage rasterImage) {
        this(new WebPOptions());
        WebPFrameBlock webPFrameBlock = new WebPFrameBlock(rasterImage);
        this.addBlock(webPFrameBlock);
        this.h();
    }

    public WebPImage(int width, int height, WebPOptions options) {
        this(options);
        WebPFrameBlock webPFrameBlock = new WebPFrameBlock(width, height);
        this.addBlock(webPFrameBlock);
        this.h();
    }

    private WebPImage(int width, int height, int pixelFormat, IRasterImagePixelLoader rasterImagePixelLoader) {
        this(width, height, new WebPOptions());
    }

    private WebPImage(WebPOptions options) {
        WebPOptions webPOptions = options;
        if (webPOptions == null) {
            webPOptions = new WebPOptions();
        }
        this.a(webPOptions);
    }

    public WebPOptions getOptions() {
        return this.h;
    }

    private void a(WebPOptions webPOptions) {
        this.h = webPOptions;
    }

    @Override
    public int getBitsPerPixel() {
        return this.g != null ? this.g.getBitsPerPixel() : 0;
    }

    @Override
    public int getHeight() {
        return this.g != null ? this.g.getHeight() : 0;
    }

    @Override
    public int getWidth() {
        return this.g != null ? this.g.getWidth() : 0;
    }

    public IFrame[] getBlocks() {
        return this.e.toArray((IFrame[])new IFrame[0]);
    }

    @Override
    public boolean hasAlpha() {
        return this.g != null && this.g.hasAlpha();
    }

    @Override
    public void adjustBrightness(int brightness) {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class));
            if (webPFrameBlock == null) continue;
            webPFrameBlock.adjustBrightness(brightness);
        }
    }

    @Override
    public void adjustContrast(float contrast) {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class));
            if (webPFrameBlock == null) continue;
            webPFrameBlock.adjustContrast(contrast);
        }
    }

    @Override
    public void adjustGamma(float gammaRed, float gammaGreen, float gammaBlue) {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class));
            if (webPFrameBlock == null) continue;
            webPFrameBlock.adjustGamma(gammaRed, gammaGreen, gammaBlue);
        }
    }

    @Override
    public void adjustGamma(float gamma) {
        this.adjustGamma(gamma, gamma, gamma);
    }

    @Override
    public void binarizeFixed(byte threshold) {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class));
            if (webPFrameBlock == null) continue;
            webPFrameBlock.binarizeFixed(threshold);
        }
    }

    @Override
    public void binarizeBradley(double brightnessDifference) {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            if (!com.aspose.imaging.internal.dO.d.b((Object)iFrame, WebPFrameBlock.class)) continue;
            ((WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class))).binarizeBradley(brightnessDifference);
        }
    }

    @Override
    public void binarizeOtsu() {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class));
            if (webPFrameBlock == null) continue;
            webPFrameBlock.binarizeOtsu();
        }
    }

    @Override
    public void crop(Rectangle rectangle) {
        this.verifyNotDisposed();
        if (rectangle.isEmpty() || rectangle.getX() < 0 || rectangle.getY() < 0 || rectangle.getWidth() < 0 || rectangle.getHeight() < 0) {
            throw new ArgumentException("Rectangle incorrect.", "rectangle");
        }
        if (!this.getBounds().contains(rectangle.Clone())) {
            throw new ArgumentException("Rectangle must be contained in the image bounds.", "rectangle");
        }
        int n2 = 0;
        for (IFrame iFrame : this.getBlocks()) {
            WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class));
            if (webPFrameBlock == null) continue;
            try {
                webPFrameBlock.crop(rectangle.Clone());
            }
            catch (RuntimeException runtimeException) {
                throw new ImageException(aY.a(new String[]{"Can't crop image. Frame index: ", ay.b(n2)}), runtimeException);
            }
            ++n2;
        }
    }

    @Override
    public void dither(int ditheringMethod, int bitsCount, IColorPalette customPalette) {
        for (int i2 = 0; i2 < this.e.size(); ++i2) {
            WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(this.getBlocks()[i2], WebPFrameBlock.class));
            if (webPFrameBlock == null) continue;
            webPFrameBlock.dither(ditheringMethod, bitsCount, customPalette);
        }
    }

    @Override
    public void grayscale() {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            WebPFrameBlock webPFrameBlock = (WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class));
            if (webPFrameBlock == null) continue;
            webPFrameBlock.grayscale();
        }
    }

    @Override
    public void rotate(float angle, boolean resizeProportionally, Color backgroundColor) {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            if (!com.aspose.imaging.internal.dO.d.b((Object)iFrame, WebPFrameBlock.class)) continue;
            ((WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class))).rotate(angle, resizeProportionally, backgroundColor.Clone());
        }
    }

    @Override
    public void resize(int newWidth, int newHeight, int resizeType) {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            if (!com.aspose.imaging.internal.dO.d.b((Object)iFrame, WebPFrameBlock.class)) continue;
            ((WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class))).resize(newWidth, newHeight, resizeType);
        }
    }

    @Override
    public void resize(int newWidth, int newHeight, ImageResizeSettings settings) {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            if (!com.aspose.imaging.internal.dO.d.b((Object)iFrame, WebPFrameBlock.class)) continue;
            ((WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class))).resize(newWidth, newHeight, settings);
        }
    }

    public void addBlock(IFrame block) {
        this.verifyNotDisposed();
        if (block == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.dO.d.a(block, Image.class));
        if (image != null) {
            this.e.addItem(block);
            image.a(this);
        }
    }

    public void clearBlocks() {
        this.verifyNotDisposed();
        this.e.clear();
    }

    public void insertBlock(int index, IFrame block) {
        this.verifyNotDisposed();
        if (block == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.dO.d.a(block, Image.class));
        if (image != null && image.getContainer() != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block belongs to other image and cannot be inserted into this GIF image.");
        }
        this.e.insertItem(index, block);
        if (image != null) {
            image.a(this);
        }
    }

    public void removeBlock(IFrame block) {
        this.verifyNotDisposed();
        if (block == null) {
            throw new ArgumentNullException("block");
        }
        Image image = (Image)((Object)com.aspose.imaging.internal.dO.d.a(block, Image.class));
        if (image != null && image.getContainer() != this) {
            throw new ArgumentOutOfRangeException("block", "The block does not belong to the current GIF image.");
        }
        this.e.removeItem(block);
        if (image != null) {
            image.a((Image)null);
        }
    }

    public void rotateFlipAll(int rotateFlip) {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            if (!com.aspose.imaging.internal.dO.d.b((Object)iFrame, WebPFrameBlock.class)) continue;
            ((WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class))).rotateFlip(rotateFlip);
        }
    }

    @Override
    public void filter(Rectangle rectangle, FilterOptionsBase options) {
        this.verifyNotDisposed();
        for (IFrame iFrame : this.getBlocks()) {
            if (!com.aspose.imaging.internal.dO.d.b((Object)iFrame, WebPFrameBlock.class)) continue;
            ((WebPFrameBlock)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, WebPFrameBlock.class))).filter(rectangle.Clone(), options);
        }
    }

    public static WebPImage a(int n2, int n3, int n4, IRasterImagePixelLoader iRasterImagePixelLoader) {
        return new WebPImage(n2, n3, n4, iRasterImagePixelLoader);
    }

    public static void a(RasterImage rasterImage, Stream stream, Rectangle rectangle, WebPOptions webPOptions) {
        int[] nArray = rasterImage.loadArgb32Pixels(rectangle.Clone());
        g g2 = new g();
        g2.a(rectangle.getWidth());
        g2.b(rectangle.getHeight());
        g2.a(webPOptions.getLossless());
        g2.a(webPOptions.getQuality());
        j j2 = new j(stream, nArray, g2);
        j2.a();
    }

    @Override
    protected void saveData(Stream stream) {
        if (this.getBlocks().length <= 1) {
            int[] nArray = this.loadArgb32Pixels(this.getBounds());
            g g2 = new g();
            g2.a(this.getOptions().getLossless());
            g2.a(this.getWidth());
            g2.b(this.getHeight());
            j j2 = new j(stream, nArray, g2);
            j2.a();
            return;
        }
        a[] aArray = new a[this.getBlocks().length];
        int n2 = 0;
        for (IFrame iFrame : this.getBlocks()) {
            RasterCachedImage rasterCachedImage = (RasterCachedImage)((Object)com.aspose.imaging.internal.dO.d.a(iFrame, RasterCachedImage.class));
            if (rasterCachedImage == null) continue;
            aArray[n2] = new a();
            aArray[n2].b(rasterCachedImage.getWidth(), rasterCachedImage.getHeight(), 0);
            aArray[n2].b(rasterCachedImage.loadArgb32Pixels(rasterCachedImage.getBounds().Clone()));
            aArray[n2].c(iFrame.getLeft());
            aArray[n2].d(iFrame.getTop());
            aArray[n2].e(iFrame.getDuration());
            ++n2;
        }
        g g3 = new g();
        g3.a(this.getOptions().getLossless());
        g3.f(true);
        g3.a(this.getWidth());
        g3.b(this.getHeight());
        g3.j(com.aspose.imaging.internal.dO.d.e((Object)this.getOptions().getAnimBackgroundColor(), 10));
        g3.a(com.aspose.imaging.internal.dO.d.c((Object)this.getOptions().getAnimLoopCount(), 8));
        g3.c(1448097880);
        j j3 = new j(stream, aArray, g3);
        j3.a();
    }

    @Override
    protected void updateDimensions(int newWidth, int newHeight) {
        this.resize(newWidth, newHeight);
    }

    private void h() {
        if (this.e.get_Item(0) == null) {
            throw new NullReferenceException("The image don't contain frames");
        }
        this.g = (WebPFrameBlock)this.e.get_Item(0);
        this.setDataLoader(new d(this.g));
    }

    protected void loadDataFromStream(InputStream stream) {
        this.f(Stream.fromJava(stream));
    }

    public void f(Stream stream) {
        i i2 = new i(stream);
        for (int i3 = 0; i3 < i2.a().length; ++i3) {
            this.addBlock(new WebPFrameBlock(i2.a(), i3));
        }
        if (!this.f) {
            long[] lArray = new long[]{this.a};
            WebPImage.a(lArray, stream);
            this.a = lArray[0];
        }
    }
}

