/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.imageoptions;

import com.aspose.imaging.Color;
import com.aspose.imaging.ColorPalette;
import com.aspose.imaging.IColorPalette;
import com.aspose.imaging.ImageOptionsBase;
import com.aspose.imaging.ResolutionSetting;
import com.aspose.imaging.coreexceptions.imageformats.TiffImageException;
import com.aspose.imaging.fileformats.tiff.TiffDataType;
import com.aspose.imaging.fileformats.tiff.TiffExifIfd;
import com.aspose.imaging.fileformats.tiff.TiffRational;
import com.aspose.imaging.fileformats.tiff.enums.Group3Options;
import com.aspose.imaging.fileformats.tiff.enums.TiffAlphaStorage;
import com.aspose.imaging.fileformats.tiff.enums.TiffCompressions;
import com.aspose.imaging.fileformats.tiff.enums.TiffFillOrders;
import com.aspose.imaging.fileformats.tiff.enums.TiffNewSubFileTypes;
import com.aspose.imaging.fileformats.tiff.enums.TiffOrientations;
import com.aspose.imaging.fileformats.tiff.enums.TiffPhotometrics;
import com.aspose.imaging.fileformats.tiff.enums.TiffPlanarConfigs;
import com.aspose.imaging.fileformats.tiff.enums.TiffPredictor;
import com.aspose.imaging.fileformats.tiff.enums.TiffResolutionUnits;
import com.aspose.imaging.fileformats.tiff.enums.TiffThresholds;
import com.aspose.imaging.fileformats.tiff.instancefactory.ITiffTagCreator;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffASCIIType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffByteType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffIfdType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffLongType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffRationalType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffShortType;
import com.aspose.imaging.fileformats.tiff.tifftagtypes.TiffUnknownType;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.ap.K;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.bF;
import com.aspose.imaging.internal.ap.bf;
import com.aspose.imaging.internal.ap.g;
import com.aspose.imaging.internal.dP.bk;
import com.aspose.imaging.internal.gM.c;
import com.aspose.imaging.internal.gM.d;
import com.aspose.imaging.internal.gg.a;
import com.aspose.imaging.internal.gg.b;
import com.aspose.imaging.internal.gg.e;
import com.aspose.imaging.internal.gg.f;
import com.aspose.imaging.internal.gg.l;
import com.aspose.imaging.system.Enum;
import com.aspose.imaging.system.collections.Generic.Dictionary;
import com.aspose.imaging.system.collections.Generic.List;
import com.aspose.imaging.system.io.MemoryStream;
import com.aspose.imaging.xmp.XmpPacketWrapper;

public class TiffOptions
extends ImageOptionsBase {
    private final Dictionary<Integer, TiffDataType> a = new Dictionary();
    private final List<TiffDataType> b = new List();
    private int c = 18761;
    private boolean d;
    private boolean e = false;
    private Color f = Color.getWhite().Clone();
    private int g = 0x6400000;

    public TiffOptions(int expectedFormat, int byteOrder) {
        this.setPhotometric(0);
        switch (expectedFormat) {
            case 8: {
                this.setCompression(2);
                break;
            }
            case 4: {
                this.setCompression(3);
                break;
            }
            case 5: {
                this.setCompression(4);
                break;
            }
            case 6: {
                this.setCompression(8);
                break;
            }
            case 7: {
                this.setCompression(8);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 9: {
                this.setCompression(7);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 10: {
                this.setCompression(7);
                this.setPhotometric(6);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 1: {
                this.setCompression(5);
                break;
            }
            case 2: {
                this.setCompression(5);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 3: {
                this.setCompression(5);
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                this.setAlphaStorage(2);
                break;
            }
            case 12: {
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8});
                break;
            }
            case 13: {
                this.setPhotometric(2);
                this.setBitsPerSample(new int[]{8, 8, 8, 8});
                this.setAlphaStorage(2);
            }
        }
        this.c = byteOrder;
    }

    public TiffOptions(int expectedFormat) {
        this(expectedFormat, 18761);
    }

    public TiffOptions(TiffOptions options) {
        if (options == null) {
            throw new ArgumentNullException("options");
        }
        if (options.b != null) {
            this.a(options.b.toArray((TiffDataType[])new TiffDataType[0]));
        }
        this.e = options.getPremultiplyComponents();
        this.xmpData = options.xmpData;
    }

    public TiffOptions(TiffDataType[] tags) {
        if (tags == null) {
            throw new ArgumentNullException("tags");
        }
        this.a(tags);
    }

    public int getDefaultMemoryAllocationLimit() {
        return this.g;
    }

    public void setDefaultMemoryAllocationLimit(int value) {
        this.g = value > 0 ? value : this.g;
    }

    public boolean getPremultiplyComponents() {
        return this.e;
    }

    public void setPremultiplyComponents(boolean value) {
        this.e = value;
    }

    public Color a() {
        return this.f;
    }

    public void a(Color color) {
        color.CloneTo(this.f);
    }

    @Override
    public XmpPacketWrapper getXmpData() {
        return this.xmpData;
    }

    @Override
    public void setXmpData(XmpPacketWrapper value) {
        this.xmpData = value;
    }

    public boolean isValid() {
        return this.a(true);
    }

    public int[] getYCbCrSubsampling() {
        int[] nArray;
        int[] nArray2 = this.c(530);
        if (nArray2 == null) {
            nArray2 = new int[]{2, 2};
        }
        if ((nArray = nArray2).length != 2) {
            throw new TiffImageException("Invalid field length. YCbCrSubsampling field must consist of two values.");
        }
        if (com.aspose.imaging.internal.dO.d.d((Object)nArray[0], 8) != 1 && com.aspose.imaging.internal.dO.d.d((Object)nArray[0], 8) != 2 && com.aspose.imaging.internal.dO.d.d((Object)nArray[0], 8) != 4 || com.aspose.imaging.internal.dO.d.d((Object)nArray[1], 8) != 1 && com.aspose.imaging.internal.dO.d.d((Object)nArray[1], 8) != 2 && com.aspose.imaging.internal.dO.d.d((Object)nArray[1], 8) != 4) {
            throw new TiffImageException(aY.a("Invalid YCbCrSubsampling value [{0},{1}]", com.aspose.imaging.internal.dO.d.a(nArray[0]), com.aspose.imaging.internal.dO.d.a(nArray[1])));
        }
        if (com.aspose.imaging.internal.dO.d.d((Object)nArray[1], 8) > com.aspose.imaging.internal.dO.d.d((Object)nArray[0], 8)) {
            throw new TiffImageException(aY.a("YCbCrSubsampleVert={0} shall always be less than or equal to YCbCrSubsampleHoriz={1}", com.aspose.imaging.internal.dO.d.a(nArray[1]), com.aspose.imaging.internal.dO.d.a(nArray[0])));
        }
        return nArray;
    }

    public void setYCbCrSubsampling(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        this.a(530, value);
    }

    public TiffRational[] getYCbCrCoefficients() {
        int n2 = 3;
        if (this.getPhotometric() == 6) {
            TiffRational[] tiffRationalArray = this.e(529);
            if (tiffRationalArray != null) {
                int n3 = tiffRationalArray.length;
                if (n3 != 3) {
                    throw new TiffImageException("Invalid count of rational coefficient values. Must be equal to 3.");
                }
                return tiffRationalArray;
            }
            return new TiffRational[]{new TiffRational(299L, 1000L), new TiffRational(587L, 1000L), new TiffRational(114L, 1000L)};
        }
        return null;
    }

    public void setYCbCrCoefficients(TiffRational[] value) {
        int n2 = 3;
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length != 3) {
            throw new TiffImageException("Invalid count of rational coefficient values. Must be equal to 3.");
        }
        this.a(529, value);
    }

    public boolean isTiled() {
        if (!(this.isTagPresent(324) && this.isTagPresent(325) && this.isTagPresent(322) && this.isTagPresent(323))) {
            return false;
        }
        TiffDataType tiffDataType = this.getTagByType(322);
        int[] nArray = (int[])com.aspose.imaging.internal.dO.d.a(tiffDataType.getValue(), int[].class);
        if (nArray != null && nArray.length > 0) {
            return false;
        }
        tiffDataType = this.getTagByType(323);
        nArray = (int[])com.aspose.imaging.internal.dO.d.a(tiffDataType.getValue(), int[].class);
        return nArray == null || nArray.length <= 0;
    }

    public String getArtist() {
        return this.f(315);
    }

    public void setArtist(String value) {
        this.a(315, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTagPresent(int tag) {
        boolean bl2;
        Dictionary<Integer, TiffDataType> dictionary = this.a;
        synchronized (dictionary) {
            bl2 = this.a.containsKey(tag);
        }
        return bl2;
    }

    public int getByteOrder() {
        return this.c;
    }

    public void setByteOrder(int value) {
        this.c = value;
    }

    public byte[] getIccProfile() {
        byte[] byArray = this.b(34675);
        return byArray;
    }

    public MemoryStream b() {
        MemoryStream memoryStream = null;
        byte[] byArray = this.b(34675);
        if (byArray != null) {
            memoryStream = new MemoryStream(byArray);
        }
        return memoryStream;
    }

    public int[] getBitsPerSample() {
        int[] nArray = this.c(258);
        if (nArray == null) {
            nArray = new int[]{1};
        } else if (nArray.length < com.aspose.imaging.internal.dO.d.d((Object)this.getSamplesPerPixel(), 8) && (this.getPhotometric() == 2 || this.getPhotometric() == 6)) {
            TiffShortType tiffShortType;
            int n2 = com.aspose.imaging.internal.dO.d.e((Object)this.getSamplesPerPixel(), 8);
            int[] nArray2 = new int[n2];
            com.aspose.imaging.internal.ap.g.a(com.aspose.imaging.internal.ap.g.a((Object)nArray), com.aspose.imaging.internal.ap.g.a((Object)nArray2), nArray.length);
            TiffDataType tiffDataType = this.getTagByType(338);
            int n3 = 0;
            if (com.aspose.imaging.internal.dO.d.b((Object)tiffDataType, TiffShortType.class) && (tiffShortType = (TiffShortType)((Object)com.aspose.imaging.internal.dO.d.a(tiffDataType, TiffShortType.class))).getValues() != null) {
                n3 = tiffShortType.getValues().length;
            }
            for (int i2 = n3; i2 > 0; --i2) {
                nArray2[nArray2.length - i2] = 8;
            }
            nArray = nArray2;
        }
        return nArray;
    }

    public void setBitsPerSample(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length == 0) {
            throw new ArgumentOutOfRangeException("value", "At least single array value must be specified.");
        }
        this.a(258, value);
        this.a(277, (bf)null, com.aspose.imaging.internal.dO.d.d((Object)value.length, 9));
    }

    public int getCompression() {
        return com.aspose.imaging.internal.dO.d.d((Object)this.a(259, 1), 8);
    }

    public void setCompression(int value) {
        this.a(259, com.aspose.imaging.internal.dO.d.a(TiffCompressions.class), value);
    }

    public String getCopyright() {
        return this.f(33432);
    }

    public void setCopyright(String value) {
        this.a(33432, value);
    }

    public int[] getColorMap() {
        return this.c(320);
    }

    public void setColorMap(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (com.aspose.imaging.internal.dO.d.d((Object)this.getSamplesPerPixel(), 8) != 1) {
            throw new TiffImageException("The color map may be defined for samples per pixel equal to 1 only.");
        }
        int n2 = this.getBitsPerPixel();
        if (n2 == 0) {
            throw new TiffImageException("The bits per sample are not defined.");
        }
        int n3 = com.aspose.imaging.internal.dO.d.e((Object)(3.0 * bF.f(2.0, (double)n2)), 14);
        if (value.length != n3) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the followign formula: 3 * (2**BitsPerSample).");
        }
        this.a(320, value);
    }

    @Override
    public IColorPalette getPalette() {
        return this.c();
    }

    @Override
    public void setPalette(IColorPalette value) {
        if (value == null || value.getEntriesCount() == 0) {
            this.removeTag(320);
        } else {
            int[] nArray = value.getArgb32Entries();
            int n2 = value.getEntriesCount();
            int n3 = this.getBitsPerPixel();
            if (n3 == 0) {
                throw new TiffImageException("The bits per sample are not defined. Please specify the BitsPerSample first.");
            }
            int n4 = com.aspose.imaging.internal.dO.d.e((Object)bF.f(2.0, (double)n3), 14);
            int[] nArray2 = new int[3 * n4];
            n2 = bF.d(n2, n4);
            for (int i2 = 0; i2 < n2; ++i2) {
                int n5 = nArray[i2];
                int n6 = n5 >> 16 & 0xFF;
                int n7 = n5 >> 8 & 0xFF;
                int n8 = n5 & 0xFF;
                nArray2[i2] = com.aspose.imaging.internal.dO.d.d((Object)((byte)n6), 6);
                nArray2[i2 + n4] = com.aspose.imaging.internal.dO.d.d((Object)((byte)n7), 6);
                nArray2[i2 + n4 * 2] = com.aspose.imaging.internal.dO.d.d((Object)((byte)n8), 6);
            }
            this.setColorMap(nArray2);
            this.d = value.isCompactPalette();
        }
    }

    public String getDateTime() {
        return this.f(306);
    }

    public void setDateTime(String value) {
        this.a(306, value);
    }

    public String getDocumentName() {
        return this.f(269);
    }

    public void setDocumentName(String value) {
        this.a(269, value);
    }

    public int getAlphaStorage() {
        return com.aspose.imaging.internal.dO.d.d((Object)this.a(338, 0), 8);
    }

    public void setAlphaStorage(int value) {
        this.a(338, com.aspose.imaging.internal.dO.d.a(TiffAlphaStorage.class), value);
    }

    public boolean isExtraSamplesPresent() {
        int n2 = 65535;
        return com.aspose.imaging.internal.dO.d.d((Object)65535, 8) != com.aspose.imaging.internal.dO.d.d((Object)this.a(338, 65535), 8);
    }

    public int getFillOrder() {
        return com.aspose.imaging.internal.dO.d.d((Object)this.a(266, 1), 8);
    }

    public void setFillOrder(int value) {
        this.a(266, com.aspose.imaging.internal.dO.d.a(TiffFillOrders.class), value);
    }

    public int[] getHalfToneHints() {
        return this.c(321);
    }

    public void setHalfToneHints(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length != 2) {
            throw new ArgumentOutOfRangeException("value", "Halftone hints array length must be equal to 2.");
        }
        this.a(321, value);
    }

    public String getImageDescription() {
        return this.f(270);
    }

    public void setImageDescription(String value) {
        this.a(270, value);
    }

    public String getInkNames() {
        return this.f(333);
    }

    public void setInkNames(String value) {
        this.a(333, value);
    }

    public String getScannerManufacturer() {
        return this.f(271);
    }

    public void setScannerManufacturer(String value) {
        this.a(271, value);
    }

    public int[] getMaxSampleValue() {
        int[] nArray = this.c(281);
        if (nArray == null) {
            int[] nArray2 = this.getBitsPerSample();
            nArray = new int[nArray2.length];
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                int n2;
                nArray[i2] = n2 = com.aspose.imaging.internal.dO.d.d((Object)(com.aspose.imaging.internal.dO.d.e((Object)bF.f(2.0, com.aspose.imaging.internal.dO.d.j(nArray2[i2], 8)), 14) - 1), 9);
            }
        }
        return nArray;
    }

    public void setMaxSampleValue(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length != com.aspose.imaging.internal.dO.d.d((Object)this.getSamplesPerPixel(), 8)) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the samples per pixel count.");
        }
        this.a(281, value);
    }

    public int[] getMinSampleValue() {
        int[] nArray = this.c(280);
        if (nArray == null) {
            nArray = new int[this.getSamplesPerPixel()];
        }
        return nArray;
    }

    public void setMinSampleValue(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length != com.aspose.imaging.internal.dO.d.d((Object)this.getSamplesPerPixel(), 8)) {
            throw new ArgumentOutOfRangeException("value", "The array length must correspond to the samples per pixel count.");
        }
        this.a(280, value);
    }

    public String getScannerModel() {
        return this.f(272);
    }

    public void setScannerModel(String value) {
        this.a(272, value);
    }

    public int getOrientation() {
        return com.aspose.imaging.internal.dO.d.d((Object)this.a(274, 1), 8);
    }

    public void setOrientation(int value) {
        this.a(274, com.aspose.imaging.internal.dO.d.a(TiffOrientations.class), value);
    }

    public String getPageName() {
        return this.f(285);
    }

    public void setPageName(String value) {
        this.a(285, value);
    }

    public int[] getPageNumber() {
        return this.c(297);
    }

    public void setPageNumber(int[] value) {
        if (value == null) {
            throw new ArgumentNullException("value");
        }
        if (value.length != 2) {
            throw new ArgumentOutOfRangeException("value", "Expected 2 values in the array: PageNumber[0] is the page number and PageNumber[1] is the total number of pages in the document.");
        }
        this.a(297, value);
    }

    public int getPhotometric() {
        return com.aspose.imaging.internal.dO.d.d((Object)this.a(262, 0), 8);
    }

    public void setPhotometric(int value) {
        this.a(262, com.aspose.imaging.internal.dO.d.a(TiffPhotometrics.class), value);
    }

    public int getPlanarConfiguration() {
        return com.aspose.imaging.internal.dO.d.d((Object)this.a(284, 1), 8);
    }

    public void setPlanarConfiguration(int value) {
        this.a(284, com.aspose.imaging.internal.dO.d.a(TiffPlanarConfigs.class), value);
    }

    public int getResolutionUnit() {
        return com.aspose.imaging.internal.dO.d.d((Object)this.a(296, 2), 8);
    }

    public void setResolutionUnit(int value) {
        this.a(296, com.aspose.imaging.internal.dO.d.a(TiffResolutionUnits.class), value);
    }

    public long getRowsPerStrip() {
        return this.b(278, 0xFFFFFFFFL);
    }

    public void setRowsPerStrip(long value) {
        this.a(278, new long[]{value}, false);
    }

    public int[] getSampleFormat() {
        int[] nArray;
        int[] nArray2 = this.c(339);
        if (nArray2 == null) {
            nArray = new int[this.getSamplesPerPixel()];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = 1;
            }
        } else {
            nArray = new int[nArray2.length];
            for (int i3 = 0; i3 < nArray2.length; ++i3) {
                nArray[i3] = com.aspose.imaging.internal.dO.d.e((Object)nArray2[i3], 8);
            }
        }
        return nArray;
    }

    public void setSampleFormat(int[] value) {
        this.a(com.aspose.imaging.internal.ap.g.a((Object)value), com.aspose.imaging.internal.dO.d.e((Object)this.getSamplesPerPixel(), 8), "samples per pixel.");
        int[] nArray = new int[value.length];
        for (int i2 = 0; i2 < value.length; ++i2) {
            nArray[i2] = value[i2];
        }
        this.a(339, nArray);
    }

    public int getSamplesPerPixel() {
        return this.a(277, 1);
    }

    public long[] getSmaxSampleValue() {
        return this.a(341, 0xFFFFFFFFL, com.aspose.imaging.internal.dO.d.e((Object)this.getSamplesPerPixel(), 8));
    }

    public void setSmaxSampleValue(long[] value) {
        this.a(com.aspose.imaging.internal.ap.g.a((Object)value), com.aspose.imaging.internal.dO.d.e((Object)this.getSamplesPerPixel(), 8), "samples per pixel.");
        this.a(341, value, true);
    }

    public long[] getSminSampleValue() {
        return this.a(340, 0L, com.aspose.imaging.internal.dO.d.e((Object)this.getSamplesPerPixel(), 8));
    }

    public void setSminSampleValue(long[] value) {
        this.a(com.aspose.imaging.internal.ap.g.a((Object)value), com.aspose.imaging.internal.dO.d.e((Object)this.getSamplesPerPixel(), 8), "samples per pixel.");
        this.a(340, value, true);
    }

    public String getSoftwareType() {
        return this.f(305);
    }

    public void setSoftwareType(String value) {
        this.a(305, value);
    }

    public long[] getStripByteCounts() {
        return this.a(279);
    }

    public void setStripByteCounts(long[] value) {
        this.a(279, value, false);
    }

    public long[] getStripOffsets() {
        return this.a(273);
    }

    public void setStripOffsets(long[] value) {
        this.a(273, value, false);
    }

    public long getSubFileType() {
        return com.aspose.imaging.internal.dO.d.f((Object)this.a(254, 0L), 10);
    }

    public void setSubFileType(long value) {
        this.a(254, com.aspose.imaging.internal.dO.d.a(TiffNewSubFileTypes.class), value);
    }

    public String getTargetPrinter() {
        return this.f(337);
    }

    public void setTargetPrinter(String value) {
        this.a(337, value);
    }

    public int getThreshholding() {
        return com.aspose.imaging.internal.dO.d.d((Object)this.a(263, 1), 8);
    }

    public void setThreshholding(int value) {
        this.a(263, com.aspose.imaging.internal.dO.d.a(TiffThresholds.class), value);
    }

    public int getTotalPages() {
        int n2 = 0;
        TiffShortType tiffShortType = (TiffShortType)((Object)com.aspose.imaging.internal.dO.d.a(this.getTagByType(297), TiffShortType.class));
        if (tiffShortType != null && tiffShortType.getValues() != null && tiffShortType.getValues().length > 1) {
            n2 = tiffShortType.getValues()[1];
        }
        return n2;
    }

    public TiffRational getXposition() {
        return this.d(286);
    }

    public void setXposition(TiffRational value) {
        this.a(286, null, value);
    }

    @Override
    public ResolutionSetting getResolutionSettings() {
        return super.getResolutionSettings();
    }

    @Override
    public void setResolutionSettings(ResolutionSetting value) {
        super.setResolutionSettings(value);
        if (value != null) {
            this.setXresolution(new TiffRational(com.aspose.imaging.internal.dO.d.f((Object)value.getHorizontalResolution(), 14), 1L));
            this.setYresolution(new TiffRational(com.aspose.imaging.internal.dO.d.f((Object)value.getVerticalResolution(), 14), 1L));
        } else {
            this.setXresolution(null);
            this.setYresolution(null);
        }
    }

    public TiffRational getXresolution() {
        return this.d(282);
    }

    public void setXresolution(TiffRational value) {
        this.a(282, null, value);
    }

    public TiffRational getYposition() {
        return this.d(287);
    }

    public void setYposition(TiffRational value) {
        this.a(287, null, value);
    }

    public TiffRational getYresolution() {
        return this.d(283);
    }

    public void setYresolution(TiffRational value) {
        this.a(283, null, value);
    }

    public long getFaxT4Options() {
        return com.aspose.imaging.internal.dO.d.f((Object)this.a(292, 0L), 10);
    }

    public void setFaxT4Options(long value) {
        this.a(292, com.aspose.imaging.internal.dO.d.a(Group3Options.class), value);
    }

    public int getPredictor() {
        return com.aspose.imaging.internal.dO.d.d((Object)this.a(317, 1), 8);
    }

    public void setPredictor(int value) {
        this.a(317, com.aspose.imaging.internal.dO.d.a(TiffPredictor.class), value);
    }

    public long getImageLength() {
        return this.b(257, 0L);
    }

    public void setImageLength(long value) {
        this.a(257, new long[]{value}, false);
    }

    public long getImageWidth() {
        return this.b(256, 0L);
    }

    public void setImageWidth(long value) {
        this.a(256, new long[]{value}, false);
    }

    public TiffExifIfd getExifIfd() {
        long l2 = 0xFFFFFFFFL;
        long l3 = this.b(34665, 0xFFFFFFFFL);
        TiffExifIfd tiffExifIfd = com.aspose.imaging.internal.dO.d.f((Object)0xFFFFFFFFL, 10) != com.aspose.imaging.internal.dO.d.f((Object)l3, 10) ? new TiffExifIfd(l3) : new TiffExifIfd();
        return tiffExifIfd;
    }

    public void a(TiffExifIfd tiffExifIfd) {
        TiffExifIfd tiffExifIfd2 = tiffExifIfd;
        if (tiffExifIfd2 == null || !tiffExifIfd2.hasValue()) {
            return;
        }
        this.a(34665, tiffExifIfd2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiffDataType[] getTags() {
        TiffDataType[] tiffDataTypeArray = null;
        List<TiffDataType> list = this.b;
        synchronized (list) {
            tiffDataTypeArray = this.b.toArray((TiffDataType[])new TiffDataType[0]);
        }
        return tiffDataTypeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTags(TiffDataType[] value) {
        List<TiffDataType> list = this.b;
        synchronized (list) {
            Dictionary<Integer, TiffDataType> dictionary = this.a;
            synchronized (dictionary) {
                this.b.clear();
                this.a.clear();
                if (value != null) {
                    for (int i2 = 0; i2 < value.length; ++i2) {
                        this.addTag(value[i2]);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValidTagCount() {
        TiffDataType[] tiffDataTypeArray = null;
        List<TiffDataType> list = this.b;
        synchronized (list) {
            tiffDataTypeArray = this.b.toArray((TiffDataType[])new TiffDataType[0]);
        }
        return TiffOptions.getValidTagsCount(tiffDataTypeArray);
    }

    public int getBitsPerPixel() {
        int[] nArray = this.getBitsPerSample();
        int n2 = 0;
        if (nArray != null) {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                n2 += com.aspose.imaging.internal.dO.d.e((Object)nArray[i2], 8);
            }
        }
        return n2;
    }

    public static int getValidTagsCount(TiffDataType[] tags) {
        int n2 = 0;
        if (tags != null) {
            for (TiffDataType tiffDataType : tags) {
                if (tiffDataType == null || com.aspose.imaging.internal.dO.d.b((Object)tiffDataType, TiffUnknownType.class) || !tiffDataType.isValid()) continue;
                ++n2;
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeTag(int tag) {
        boolean bl2 = false;
        List<TiffDataType> list = this.b;
        synchronized (list) {
            Dictionary<Integer, TiffDataType> dictionary = this.a;
            synchronized (dictionary) {
                if (this.a.containsKey(tag)) {
                    TiffDataType tiffDataType = this.a.get_Item(tag);
                    this.a.removeItemByKey(tag);
                    this.b.removeItem(tiffDataType);
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    public void validate() {
        this.a(false);
    }

    public void addTags(TiffDataType[] tagsToAdd) {
        if (tagsToAdd == null) {
            throw new ArgumentNullException("tagsToAdd");
        }
        for (int i2 = 0; i2 < tagsToAdd.length; ++i2) {
            this.addTag(tagsToAdd[i2]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTag(TiffDataType tagToAdd) {
        if (tagToAdd == null) {
            throw new ArgumentNullException("tagToAdd");
        }
        List<TiffDataType> list = this.b;
        synchronized (list) {
            Dictionary<Integer, TiffDataType> dictionary = this.a;
            synchronized (dictionary) {
                if (!this.a.containsKey(tagToAdd.getTagId())) {
                    this.b.addItem(tagToAdd);
                }
                this.a.set_Item(tagToAdd.getTagId(), tagToAdd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TiffDataType getTagByType(int tagKey) {
        TiffDataType tiffDataType = null;
        Dictionary<Integer, TiffDataType> dictionary = this.a;
        synchronized (dictionary) {
            if (this.a.containsKey(tagKey)) {
                tiffDataType = this.a.get_Item(tagKey);
            }
        }
        return tiffDataType;
    }

    private IColorPalette c() {
        ColorPalette colorPalette = null;
        int[] nArray = this.getColorMap();
        if (nArray != null) {
            int[] nArray2;
            boolean bl2 = false;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (com.aspose.imaging.internal.dO.d.d((Object)nArray[i2], 8) <= 255) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                int[] nArray3 = new int[nArray.length];
                for (int i3 = 0; i3 < nArray3.length; ++i3) {
                    nArray3[i3] = com.aspose.imaging.internal.dO.d.d((Object)(com.aspose.imaging.internal.dO.d.d((Object)nArray[i3], 8) >> 8 & 0xFF), 9);
                }
                nArray2 = nArray3;
            } else {
                nArray2 = nArray;
            }
            int n2 = nArray2.length / 3;
            if (n2 > 0) {
                int[] nArray4 = new int[n2];
                for (int i4 = 0; i4 < nArray4.length; ++i4) {
                    nArray4[i4] = 0xFF000000 | com.aspose.imaging.internal.dO.d.e((Object)com.aspose.imaging.internal.dO.d.b((Object)nArray2[i4], 8), 6) << 16 | com.aspose.imaging.internal.dO.d.e((Object)com.aspose.imaging.internal.dO.d.b((Object)nArray2[i4 + n2], 8), 6) << 8 | com.aspose.imaging.internal.dO.d.e((Object)com.aspose.imaging.internal.dO.d.b((Object)nArray2[i4 + (n2 << 1)], 8), 6);
                }
                colorPalette = new ColorPalette(nArray4, this.d);
            }
        }
        return colorPalette;
    }

    private void a(g g2, int n2, String string) {
        if (g2 == null) {
            throw new ArgumentNullException("array");
        }
        if (g2.g() != n2) {
            throw new ArgumentOutOfRangeException("array", aY.a(new String[]{"The array length is not valid. Expected length equal to ", string}));
        }
    }

    private long[] a(int n2) {
        long[] lArray = null;
        TiffDataType tiffDataType = this.getTagByType(n2);
        if (tiffDataType != null && com.aspose.imaging.internal.dO.d.b(tiffDataType.getValue(), g.class)) {
            g g2 = (g)((Object)com.aspose.imaging.internal.dO.d.a(tiffDataType.getValue(), g.class));
            lArray = new long[g2.g()];
            for (int i2 = 0; i2 < g2.g(); ++i2) {
                lArray[i2] = K.h(g2.c(i2));
            }
        }
        return lArray;
    }

    private byte[] b(int n2) {
        byte[] byArray = null;
        TiffDataType tiffDataType = this.getTagByType(n2);
        if (tiffDataType != null && com.aspose.imaging.internal.dO.d.b(tiffDataType.getValue(), g.class)) {
            g g2 = (g)((Object)com.aspose.imaging.internal.dO.d.a(tiffDataType.getValue(), g.class));
            byArray = new byte[g2.g()];
            for (int i2 = 0; i2 < g2.g(); ++i2) {
                byArray[i2] = K.c(g2.c(i2));
            }
        }
        return byArray;
    }

    private long[] a(int n2, long l2, int n3) {
        long[] lArray = this.a(n2);
        if (lArray == null) {
            lArray = new long[n3];
            for (int i2 = 0; i2 < lArray.length; ++i2) {
                lArray[i2] = l2;
            }
        }
        return lArray;
    }

    private void a(int n2, long[] lArray, boolean bl2) {
        long l2 = 0L;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (com.aspose.imaging.internal.dO.d.f((Object)lArray[i2], 10) <= com.aspose.imaging.internal.dO.d.f((Object)l2, 10)) continue;
            l2 = lArray[i2];
        }
        if (bl2 && com.aspose.imaging.internal.dO.d.f((Object)l2, 10) <= 255L) {
            byte[] byArray = new byte[lArray.length];
            for (int i3 = 0; i3 < lArray.length; ++i3) {
                byArray[i3] = com.aspose.imaging.internal.dO.d.b((Object)lArray[i3], 10);
            }
            TiffDataType tiffDataType = this.getTagByType(n2);
            if (tiffDataType != null && tiffDataType.getTagType() != 1) {
                this.removeTag(n2);
            }
            this.a(n2, byArray);
        } else if (com.aspose.imaging.internal.dO.d.f((Object)l2, 10) <= (long)com.aspose.imaging.internal.dO.d.d((Object)65535, 8)) {
            int[] nArray = new int[lArray.length];
            for (int i4 = 0; i4 < lArray.length; ++i4) {
                nArray[i4] = com.aspose.imaging.internal.dO.d.d((Object)lArray[i4], 10);
            }
            TiffDataType tiffDataType = this.getTagByType(n2);
            if (tiffDataType != null && tiffDataType.getTagType() != 3) {
                this.removeTag(n2);
            }
            this.a(n2, nArray);
        } else {
            TiffDataType tiffDataType = this.getTagByType(n2);
            if (tiffDataType != null && tiffDataType.getTagType() != 4) {
                this.removeTag(n2);
            }
            this.a(n2, lArray);
        }
    }

    private void a(TiffDataType[] tiffDataTypeArray) {
        for (TiffDataType tiffDataType : tiffDataTypeArray) {
            this.addTag(tiffDataType.deepClone());
        }
    }

    private void a(int n2, byte[] byArray) {
        TiffByteType tiffByteType = (TiffByteType)this.a(n2, new b());
        tiffByteType.setValues(byArray);
        this.addTag(tiffByteType);
    }

    private void a(int n2, int[] nArray) {
        TiffShortType tiffShortType = (TiffShortType)this.a(n2, new l());
        tiffShortType.setValues(nArray);
        this.addTag(tiffShortType);
    }

    private void a(int n2, long[] lArray) {
        TiffLongType tiffLongType = (TiffLongType)this.a(n2, new f());
        tiffLongType.setValues(lArray);
        this.addTag(tiffLongType);
    }

    private void a(int n2, TiffExifIfd[] tiffExifIfdArray) {
        List<Long> list = new List<Long>();
        if (tiffExifIfdArray == null) {
            return;
        }
        for (TiffExifIfd tiffExifIfd : tiffExifIfdArray) {
            if (!tiffExifIfd.hasValue()) continue;
            list.addItem(tiffExifIfd.getOffset());
        }
        if (list.size() > 0) {
            TiffIfdType tiffIfdType = (TiffIfdType)this.a(n2, new e());
            tiffIfdType.setValues(bk.b(list));
            this.addTag(tiffIfdType);
        }
    }

    private void a(int n2, TiffRational[] tiffRationalArray) {
        TiffRationalType tiffRationalType = (TiffRationalType)this.a(n2, new com.aspose.imaging.internal.gg.g());
        tiffRationalType.setValues(tiffRationalArray);
        this.addTag(tiffRationalType);
    }

    private void a(int n2, bf bf2, int n3) {
        if (bf2 != null && !Enum.isDefined(bf2, com.aspose.imaging.internal.dO.d.a(n3))) {
            throw new ArgumentOutOfRangeException("value", "The value is not defined.");
        }
        this.a(n2, new int[]{n3});
    }

    private void a(int n2, bf bf2, long l2) {
        if (bf2 != null && !Enum.isDefined(bf2, com.aspose.imaging.internal.dO.d.a(l2))) {
            throw new ArgumentOutOfRangeException("value", "The value is not defined.");
        }
        this.a(n2, new long[]{l2});
    }

    private void a(int n2, TiffExifIfd tiffExifIfd) {
        this.a(n2, new TiffExifIfd[]{tiffExifIfd});
    }

    private void a(int n2, bf bf2, TiffRational tiffRational) {
        if (bf2 != null && !Enum.isDefined(bf2, tiffRational)) {
            throw new ArgumentOutOfRangeException("value", "The value is not defined.");
        }
        this.a(n2, new TiffRational[]{tiffRational});
    }

    private int[] c(int n2) {
        int[] nArray = null;
        TiffShortType tiffShortType = (TiffShortType)((Object)com.aspose.imaging.internal.dO.d.a(this.getTagByType(n2), TiffShortType.class));
        if (tiffShortType != null) {
            nArray = tiffShortType.getValues();
        }
        return nArray;
    }

    private int a(int n2, int n3) {
        int n4 = n3;
        TiffShortType tiffShortType = (TiffShortType)((Object)com.aspose.imaging.internal.dO.d.a(this.getTagByType(n2), TiffShortType.class));
        if (tiffShortType != null && tiffShortType.getValues() != null && tiffShortType.getValues().length > 0) {
            n4 = tiffShortType.getValues()[0];
        }
        return n4;
    }

    private long a(int n2, long l2) {
        long l3 = l2;
        TiffLongType tiffLongType = (TiffLongType)((Object)com.aspose.imaging.internal.dO.d.a(this.getTagByType(n2), TiffLongType.class));
        if (tiffLongType != null && tiffLongType.getValues() != null && tiffLongType.getValues().length > 0) {
            l3 = tiffLongType.getValues()[0];
        }
        return l3;
    }

    private long b(int n2, long l2) {
        long l3 = l2;
        TiffDataType tiffDataType = this.getTagByType(n2);
        if (tiffDataType != null && tiffDataType.getValue() != null && com.aspose.imaging.internal.dO.d.b(tiffDataType.getValue(), g.class) && ((g)((Object)com.aspose.imaging.internal.dO.d.a(tiffDataType.getValue(), g.class))).g() > 0) {
            l3 = K.h(((g)((Object)com.aspose.imaging.internal.dO.d.a(tiffDataType.getValue(), g.class))).c(0));
        }
        return l3;
    }

    private void a(int n2, String string) {
        TiffASCIIType tiffASCIIType = (TiffASCIIType)this.a(n2, new a());
        tiffASCIIType.setText(string);
        this.addTag(tiffASCIIType);
    }

    private TiffRational d(int n2) {
        TiffRational tiffRational = null;
        TiffRationalType tiffRationalType = (TiffRationalType)((Object)com.aspose.imaging.internal.dO.d.a(this.getTagByType(n2), TiffRationalType.class));
        if (tiffRationalType != null && tiffRationalType.getValues() != null && tiffRationalType.getValues().length > 0) {
            tiffRational = tiffRationalType.getValues()[0];
        }
        return tiffRational;
    }

    private TiffRational[] e(int n2) {
        TiffRational[] tiffRationalArray = null;
        TiffRationalType tiffRationalType = (TiffRationalType)((Object)com.aspose.imaging.internal.dO.d.a(this.getTagByType(n2), TiffRationalType.class));
        if (tiffRationalType != null && tiffRationalType.getValues() != null && tiffRationalType.getValues().length > 0) {
            tiffRationalArray = new TiffRational[tiffRationalType.getValues().length];
            com.aspose.imaging.internal.ap.g.a(com.aspose.imaging.internal.ap.g.a(tiffRationalType.getValues()), com.aspose.imaging.internal.ap.g.a(tiffRationalArray), tiffRationalType.getValues().length);
        }
        return tiffRationalArray;
    }

    private String f(int n2) {
        String string = null;
        TiffASCIIType tiffASCIIType = (TiffASCIIType)((Object)com.aspose.imaging.internal.dO.d.a(this.getTagByType(n2), TiffASCIIType.class));
        if (tiffASCIIType != null) {
            string = tiffASCIIType.getText();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TiffDataType a(int n2, ITiffTagCreator iTiffTagCreator) {
        TiffDataType tiffDataType = iTiffTagCreator.createInstance(n2);
        TiffDataType tiffDataType2 = null;
        Dictionary<Integer, TiffDataType> dictionary = this.a;
        synchronized (dictionary) {
            if (this.a.containsKey(n2) && (tiffDataType2 = this.a.get_Item(n2)).getTagType() != tiffDataType.getTagType()) {
                this.removeTag(n2);
                tiffDataType2 = null;
            }
        }
        if (tiffDataType2 == null) {
            tiffDataType2 = tiffDataType;
        }
        return tiffDataType2;
    }

    public static com.aspose.imaging.internal.gM.a a(TiffOptions tiffOptions) {
        if (tiffOptions.getCompression() == 7) {
            switch (tiffOptions.getPhotometric()) {
                case 1: {
                    return new com.aspose.imaging.internal.gM.b(tiffOptions);
                }
                case 2: {
                    return new c(tiffOptions);
                }
                case 6: {
                    return new d(tiffOptions);
                }
            }
        }
        return new com.aspose.imaging.internal.gM.e(tiffOptions);
    }

    private boolean a(boolean bl2) {
        com.aspose.imaging.internal.gM.a a2 = TiffOptions.a(this);
        return a2.a(bl2);
    }
}

