/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1InputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OutputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ParsingException;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.imaging.internal.bouncycastle.asn1.l;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERApplicationSpecific
extends ASN1Primitive {
    private final boolean a;
    private final int b;
    private final byte[] c;

    DERApplicationSpecific(boolean bl2, int n2, byte[] byArray) {
        this.a = bl2;
        this.b = n2;
        this.c = byArray;
    }

    public DERApplicationSpecific(int n2, byte[] byArray) {
        this(false, n2, byArray);
    }

    public DERApplicationSpecific(int n2, ASN1Encodable aSN1Encodable) throws IOException {
        this(true, n2, aSN1Encodable);
    }

    public DERApplicationSpecific(boolean bl2, int n2, ASN1Encodable aSN1Encodable) throws IOException {
        ASN1Primitive aSN1Primitive = aSN1Encodable.toASN1Primitive();
        byte[] byArray = aSN1Primitive.getEncoded("DER");
        this.a = bl2 || aSN1Primitive instanceof ASN1Set || aSN1Primitive instanceof ASN1Sequence;
        this.b = n2;
        if (bl2) {
            this.c = byArray;
        } else {
            int n3 = this.a(byArray);
            byte[] byArray2 = new byte[byArray.length - n3];
            System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
            this.c = byArray2;
        }
    }

    public DERApplicationSpecific(int n2, ASN1EncodableVector aSN1EncodableVector) {
        this.b = n2;
        this.a = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 != aSN1EncodableVector.size(); ++i2) {
            try {
                byteArrayOutputStream.write(((ASN1Object)aSN1EncodableVector.get(i2)).getEncoded("DER"));
                continue;
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("malformed object: " + iOException, iOException);
            }
        }
        this.c = byteArrayOutputStream.toByteArray();
    }

    public static DERApplicationSpecific getInstance(Object object) {
        if (object == null || object instanceof DERApplicationSpecific) {
            return (DERApplicationSpecific)object;
        }
        if (object instanceof byte[]) {
            try {
                return DERApplicationSpecific.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct object from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    private int a(byte[] byArray) {
        int n2 = byArray[1] & 0xFF;
        if (n2 == 128) {
            return 2;
        }
        if (n2 > 127) {
            int n3 = n2 & 0x7F;
            if (n3 > 4) {
                throw new IllegalStateException("DER length more than 4 bytes: " + n3);
            }
            return n3 + 2;
        }
        return 2;
    }

    @Override
    public boolean isConstructed() {
        return this.a;
    }

    public byte[] getContents() {
        return this.c;
    }

    public int getApplicationTag() {
        return this.b;
    }

    public ASN1Primitive getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    public ASN1Primitive getObject(int n2) throws IOException {
        if (n2 >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = this.a(n2, byArray);
        if ((byArray[0] & 0x20) != 0) {
            byArray2[0] = (byte)(byArray2[0] | 0x20);
        }
        return new ASN1InputStream(byArray2).readObject();
    }

    @Override
    int encodedLength() throws IOException {
        return l.b(this.b) + l.a(this.c.length) + this.c.length;
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        int n2 = 64;
        if (this.a) {
            n2 |= 0x20;
        }
        aSN1OutputStream.writeEncoded(n2, this.b, this.c);
    }

    @Override
    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)aSN1Primitive;
        return this.a == dERApplicationSpecific.a && this.b == dERApplicationSpecific.b && Arrays.areEqual(this.c, dERApplicationSpecific.c);
    }

    @Override
    public int hashCode() {
        return (this.a ? 1 : 0) ^ this.b ^ Arrays.hashCode(this.c);
    }

    private byte[] a(int n2, byte[] byArray) throws IOException {
        int n3 = byArray[0] & 0x1F;
        int n4 = 1;
        if (n3 == 31) {
            int n5;
            n3 = 0;
            if (((n5 = byArray[n4++] & 0xFF) & 0x7F) == 0) {
                throw new ASN1ParsingException("corrupted stream - invalid high tag number found");
            }
            while (n5 >= 0 && (n5 & 0x80) != 0) {
                n3 |= n5 & 0x7F;
                n3 <<= 7;
                n5 = byArray[n4++] & 0xFF;
            }
            n3 |= n5 & 0x7F;
        }
        byte[] byArray2 = new byte[byArray.length - n4 + 1];
        System.arraycopy(byArray, n4, byArray2, 1, byArray2.length - 1);
        byArray2[0] = (byte)n2;
        return byArray2;
    }
}

