/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OutputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1String;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.l;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import com.aspose.imaging.internal.bouncycastle.util.io.Streams;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DERBitString
extends ASN1Primitive
implements ASN1String {
    private static final char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected byte[] data;
    protected int padBits;

    protected static int getPadBits(int n2) {
        int n3;
        int n4 = 0;
        for (n3 = 3; n3 >= 0; --n3) {
            if (n3 != 0) {
                if (n2 >> n3 * 8 == 0) continue;
                n4 = n2 >> n3 * 8 & 0xFF;
                break;
            }
            if (n2 == 0) continue;
            n4 = n2 & 0xFF;
            break;
        }
        if (n4 == 0) {
            return 7;
        }
        n3 = 1;
        while (((n4 <<= 1) & 0xFF) != 0) {
            ++n3;
        }
        return 8 - n3;
    }

    protected static byte[] getBytes(int n2) {
        int n3 = 4;
        for (int i2 = 3; i2 >= 1 && (n2 & 255 << i2 * 8) == 0; --i2) {
            --n3;
        }
        byte[] byArray = new byte[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            byArray[i3] = (byte)(n2 >> i3 * 8 & 0xFF);
        }
        return byArray;
    }

    public static DERBitString getInstance(Object object) {
        if (object == null || object instanceof DERBitString) {
            return (DERBitString)object;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBitString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof DERBitString) {
            return DERBitString.getInstance(aSN1Primitive);
        }
        return DERBitString.fromOctetString(((ASN1OctetString)aSN1Primitive).getOctets());
    }

    protected DERBitString(byte by2, int n2) {
        this.data = new byte[1];
        this.data[0] = by2;
        this.padBits = n2;
    }

    public DERBitString(byte[] byArray, int n2) {
        this.data = byArray;
        this.padBits = n2;
    }

    public DERBitString(byte[] byArray) {
        this(byArray, 0);
    }

    public DERBitString(int n2) {
        this.data = DERBitString.getBytes(n2);
        this.padBits = DERBitString.getPadBits(n2);
    }

    public DERBitString(ASN1Encodable aSN1Encodable) throws IOException {
        this.data = aSN1Encodable.toASN1Primitive().getEncoded("DER");
        this.padBits = 0;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public int getPadBits() {
        return this.padBits;
    }

    public int intValue() {
        int n2 = 0;
        for (int i2 = 0; i2 != this.data.length && i2 != 4; ++i2) {
            n2 |= (this.data[i2] & 0xFF) << 8 * i2;
        }
        return n2;
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + l.a(this.data.length + 1) + this.data.length + 1;
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        byte[] byArray = new byte[this.getBytes().length + 1];
        byArray[0] = (byte)this.getPadBits();
        System.arraycopy(this.getBytes(), 0, byArray, 1, byArray.length - 1);
        aSN1OutputStream.writeEncoded(3, byArray);
    }

    @Override
    public int hashCode() {
        return this.padBits ^ Arrays.hashCode(this.data);
    }

    @Override
    protected boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERBitString)) {
            return false;
        }
        DERBitString dERBitString = (DERBitString)aSN1Primitive;
        return this.padBits == dERBitString.padBits && Arrays.areEqual(this.data, dERBitString.data);
    }

    @Override
    public String getString() {
        StringBuffer stringBuffer = new StringBuffer("#");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        try {
            aSN1OutputStream.writeObject(this);
        }
        catch (IOException iOException) {
            throw new RuntimeException("internal error encoding BitString");
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            stringBuffer.append(a[byArray[i2] >>> 4 & 0xF]);
            stringBuffer.append(a[byArray[i2] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getString();
    }

    static DERBitString fromOctetString(byte[] byArray) {
        if (byArray.length < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        byte by2 = byArray[0];
        byte[] byArray2 = new byte[byArray.length - 1];
        if (byArray2.length != 0) {
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
        }
        return new DERBitString(byArray2, (int)by2);
    }

    static DERBitString fromInputStream(int n2, InputStream inputStream) throws IOException {
        if (n2 < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int n3 = inputStream.read();
        byte[] byArray = new byte[n2 - 1];
        if (byArray.length != 0 && Streams.readFully(inputStream, byArray) != byArray.length) {
            throw new EOFException("EOF encountered in middle of BIT STRING");
        }
        return new DERBitString(byArray, n3);
    }
}

