/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OutputStream;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1String;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.l;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import com.aspose.imaging.internal.bouncycastle.util.Strings;
import java.io.IOException;

public class DERNumericString
extends ASN1Primitive
implements ASN1String {
    private byte[] a;

    public static DERNumericString getInstance(Object object) {
        if (object == null || object instanceof DERNumericString) {
            return (DERNumericString)object;
        }
        if (object instanceof byte[]) {
            try {
                return (DERNumericString)DERNumericString.fromByteArray((byte[])object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERNumericString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        ASN1Primitive aSN1Primitive = aSN1TaggedObject.getObject();
        if (bl2 || aSN1Primitive instanceof DERNumericString) {
            return DERNumericString.getInstance(aSN1Primitive);
        }
        return new DERNumericString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
    }

    DERNumericString(byte[] byArray) {
        this.a = byArray;
    }

    public DERNumericString(String string) {
        this(string, false);
    }

    public DERNumericString(String string, boolean bl2) {
        if (bl2 && !DERNumericString.isNumericString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.a = Strings.toByteArray(string);
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.a);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.a);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + l.a(this.a.length) + this.a.length;
    }

    @Override
    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        aSN1OutputStream.writeEncoded(18, this.a);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.a);
    }

    @Override
    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERNumericString)) {
            return false;
        }
        DERNumericString dERNumericString = (DERNumericString)aSN1Primitive;
        return Arrays.areEqual(this.a, dERNumericString.a);
    }

    public static boolean isNumericString(String string) {
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (c2 > '\u007f') {
                return false;
            }
            if ('0' <= c2 && c2 <= '9' || c2 == ' ') continue;
            return false;
        }
        return true;
    }
}

