/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cms;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Choice;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;

public class RecipientIdentifier
extends ASN1Object
implements ASN1Choice {
    private ASN1Encodable a;

    public RecipientIdentifier(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.a = issuerAndSerialNumber;
    }

    public RecipientIdentifier(ASN1OctetString aSN1OctetString) {
        this.a = new DERTaggedObject(false, 0, aSN1OctetString);
    }

    public RecipientIdentifier(ASN1Primitive aSN1Primitive) {
        this.a = aSN1Primitive;
    }

    public static RecipientIdentifier getInstance(Object object) {
        if (object == null || object instanceof RecipientIdentifier) {
            return (RecipientIdentifier)object;
        }
        if (object instanceof IssuerAndSerialNumber) {
            return new RecipientIdentifier((IssuerAndSerialNumber)object);
        }
        if (object instanceof ASN1OctetString) {
            return new RecipientIdentifier((ASN1OctetString)object);
        }
        if (object instanceof ASN1Primitive) {
            return new RecipientIdentifier((ASN1Primitive)object);
        }
        throw new IllegalArgumentException("Illegal object in RecipientIdentifier: " + object.getClass().getName());
    }

    public boolean isTagged() {
        return this.a instanceof ASN1TaggedObject;
    }

    public ASN1Encodable getId() {
        if (this.a instanceof ASN1TaggedObject) {
            return ASN1OctetString.getInstance((ASN1TaggedObject)this.a, false);
        }
        return IssuerAndSerialNumber.getInstance(this.a);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a.toASN1Primitive();
    }
}

