/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.cms.ecc;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERTaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.OriginatorPublicKey;

public class MQVuserKeyingMaterial
extends ASN1Object {
    private OriginatorPublicKey a;
    private ASN1OctetString b;

    public MQVuserKeyingMaterial(OriginatorPublicKey originatorPublicKey, ASN1OctetString aSN1OctetString) {
        this.a = originatorPublicKey;
        this.b = aSN1OctetString;
    }

    private MQVuserKeyingMaterial(ASN1Sequence aSN1Sequence) {
        this.a = OriginatorPublicKey.getInstance(aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.b = ASN1OctetString.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true);
        }
    }

    public static MQVuserKeyingMaterial getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return MQVuserKeyingMaterial.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static MQVuserKeyingMaterial getInstance(Object object) {
        if (object == null || object instanceof MQVuserKeyingMaterial) {
            return (MQVuserKeyingMaterial)object;
        }
        if (object instanceof ASN1Sequence) {
            return new MQVuserKeyingMaterial((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid MQVuserKeyingMaterial: " + object.getClass().getName());
    }

    public OriginatorPublicKey getEphemeralPublicKey() {
        return this.a;
    }

    public ASN1OctetString getAddedukm() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, this.b));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

