/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.pkcs;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.DEROctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.math.BigInteger;
import java.util.Enumeration;

public class PBKDF2Params
extends ASN1Object {
    private static final AlgorithmIdentifier a = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);
    private ASN1OctetString b;
    private ASN1Integer c;
    private ASN1Integer d;
    private AlgorithmIdentifier e;

    public static PBKDF2Params getInstance(Object object) {
        if (object instanceof PBKDF2Params) {
            return (PBKDF2Params)object;
        }
        if (object != null) {
            return new PBKDF2Params(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public PBKDF2Params(byte[] byArray, int n2) {
        this.b = new DEROctetString(byArray);
        this.c = new ASN1Integer(n2);
    }

    public PBKDF2Params(byte[] byArray, int n2, int n3) {
        this(byArray, n2);
        this.d = new ASN1Integer(n3);
    }

    public PBKDF2Params(byte[] byArray, int n2, int n3, AlgorithmIdentifier algorithmIdentifier) {
        this(byArray, n2);
        this.d = new ASN1Integer(n3);
        this.e = algorithmIdentifier;
    }

    public PBKDF2Params(byte[] byArray, int n2, AlgorithmIdentifier algorithmIdentifier) {
        this(byArray, n2);
        this.e = algorithmIdentifier;
    }

    private PBKDF2Params(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.b = (ASN1OctetString)enumeration.nextElement();
        this.c = (ASN1Integer)enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof ASN1Integer) {
                this.d = ASN1Integer.getInstance(object);
                object = enumeration.hasMoreElements() ? enumeration.nextElement() : null;
            } else {
                this.d = null;
            }
            if (object != null) {
                this.e = AlgorithmIdentifier.getInstance(object);
            }
        }
    }

    public byte[] getSalt() {
        return this.b.getOctets();
    }

    public BigInteger getIterationCount() {
        return this.c.getValue();
    }

    public BigInteger getKeyLength() {
        if (this.d != null) {
            return this.d.getValue();
        }
        return null;
    }

    public boolean isDefaultPrf() {
        return this.e == null || this.e.equals(a);
    }

    public AlgorithmIdentifier getPrf() {
        if (this.e != null) {
            return this.e;
        }
        return a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        if (this.e != null && !this.e.equals(a)) {
            aSN1EncodableVector.add(this.e);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

