/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.pkcs;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class RSAPublicKey
extends ASN1Object {
    private BigInteger a;
    private BigInteger b;

    public static RSAPublicKey getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return RSAPublicKey.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static RSAPublicKey getInstance(Object object) {
        if (object instanceof RSAPublicKey) {
            return (RSAPublicKey)object;
        }
        if (object != null) {
            return new RSAPublicKey(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a = bigInteger;
        this.b = bigInteger2;
    }

    private RSAPublicKey(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.a = ASN1Integer.getInstance(enumeration.nextElement()).getPositiveValue();
        this.b = ASN1Integer.getInstance(enumeration.nextElement()).getPositiveValue();
    }

    public BigInteger getModulus() {
        return this.a;
    }

    public BigInteger getPublicExponent() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(this.getModulus()));
        aSN1EncodableVector.add(new ASN1Integer(this.getPublicExponent()));
        return new DERSequence(aSN1EncodableVector);
    }
}

