/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.asn1.x509;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Sequence;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1TaggedObject;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSequence;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Extension;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Extensions
extends ASN1Object {
    private Hashtable a = new Hashtable();
    private Vector b = new Vector();

    public static Extensions getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return Extensions.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl2));
    }

    public static Extensions getInstance(Object object) {
        if (object instanceof Extensions) {
            return (Extensions)object;
        }
        if (object != null) {
            return new Extensions(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private Extensions(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Extension extension = Extension.getInstance(enumeration.nextElement());
            this.a.put(extension.getExtnId(), extension);
            this.b.addElement(extension.getExtnId());
        }
    }

    public Extensions(Extension extension) {
        this.b.addElement(extension.getExtnId());
        this.a.put(extension.getExtnId(), extension);
    }

    public Extensions(Extension[] extensionArray) {
        for (int i2 = 0; i2 != extensionArray.length; ++i2) {
            Extension extension = extensionArray[i2];
            this.b.addElement(extension.getExtnId());
            this.a.put(extension.getExtnId(), extension);
        }
    }

    public Enumeration oids() {
        return this.b.elements();
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (Extension)this.a.get(aSN1ObjectIdentifier);
    }

    public ASN1Encodable getExtensionParsedValue(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Extension extension = this.getExtension(aSN1ObjectIdentifier);
        if (extension != null) {
            return extension.getParsedValue();
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = this.b.elements();
        while (enumeration.hasMoreElements()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)enumeration.nextElement();
            Extension extension = (Extension)this.a.get(aSN1ObjectIdentifier);
            aSN1EncodableVector.add(extension);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public boolean equivalent(Extensions extensions) {
        if (this.a.size() != extensions.a.size()) {
            return false;
        }
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            if (this.a.get(k2).equals(extensions.a.get(k2))) continue;
            return false;
        }
        return true;
    }

    public ASN1ObjectIdentifier[] getExtensionOIDs() {
        return this.a(this.b);
    }

    public ASN1ObjectIdentifier[] getNonCriticalExtensionOIDs() {
        return this.a(false);
    }

    public ASN1ObjectIdentifier[] getCriticalExtensionOIDs() {
        return this.a(true);
    }

    private ASN1ObjectIdentifier[] a(boolean bl2) {
        Vector vector = new Vector();
        for (int i2 = 0; i2 != this.b.size(); ++i2) {
            Object e2 = this.b.elementAt(i2);
            if (((Extension)this.a.get(e2)).isCritical() != bl2) continue;
            vector.addElement(e2);
        }
        return this.a(vector);
    }

    private ASN1ObjectIdentifier[] a(Vector vector) {
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new ASN1ObjectIdentifier[vector.size()];
        for (int i2 = 0; i2 != aSN1ObjectIdentifierArray.length; ++i2) {
            aSN1ObjectIdentifierArray[i2] = (ASN1ObjectIdentifier)vector.elementAt(i2);
        }
        return aSN1ObjectIdentifierArray;
    }
}

