/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.ec;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.sec.SECObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECParameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.a;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.b;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.c;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.d;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.e;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.f;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.g;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.h;
import com.aspose.imaging.internal.bouncycastle.crypto.ec.i;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.math.ec.endo.GLVTypeBEndomorphism;
import com.aspose.imaging.internal.bouncycastle.math.ec.endo.GLVTypeBParameters;
import com.aspose.imaging.internal.bouncycastle.util.Strings;
import java.util.Enumeration;
import java.util.Hashtable;

public class CustomNamedCurves {
    static X9ECParametersHolder curve25519 = new a();
    static X9ECParametersHolder secp192k1 = new b();
    static X9ECParametersHolder secp192r1 = new c();
    static X9ECParametersHolder secp224k1 = new d();
    static X9ECParametersHolder secp224r1 = new e();
    static X9ECParametersHolder secp256k1 = new f();
    static X9ECParametersHolder secp256r1 = new g();
    static X9ECParametersHolder secp384r1 = new h();
    static X9ECParametersHolder secp521r1 = new i();
    static final Hashtable nameToCurve = new Hashtable();
    static final Hashtable nameToOID = new Hashtable();
    static final Hashtable oidToCurve = new Hashtable();
    static final Hashtable oidToName = new Hashtable();

    private static ECCurve a(ECCurve eCCurve) {
        return eCCurve;
    }

    private static ECCurve a(ECCurve eCCurve, GLVTypeBParameters gLVTypeBParameters) {
        return eCCurve.configure().setEndomorphism(new GLVTypeBEndomorphism(eCCurve, gLVTypeBParameters)).create();
    }

    static void defineCurve(String string, X9ECParametersHolder x9ECParametersHolder) {
        nameToCurve.put(string, x9ECParametersHolder);
    }

    static void defineCurveWithOID(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier, X9ECParametersHolder x9ECParametersHolder) {
        nameToCurve.put(string, x9ECParametersHolder);
        nameToOID.put(string, aSN1ObjectIdentifier);
        oidToName.put(aSN1ObjectIdentifier, string);
        oidToCurve.put(aSN1ObjectIdentifier, x9ECParametersHolder);
    }

    static void defineCurveAlias(String string, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        string = Strings.toLowerCase(string);
        nameToOID.put(string, aSN1ObjectIdentifier);
        nameToCurve.put(string, oidToCurve.get(aSN1ObjectIdentifier));
    }

    public static X9ECParameters getByName(String string) {
        X9ECParametersHolder x9ECParametersHolder = (X9ECParametersHolder)nameToCurve.get(Strings.toLowerCase(string));
        return x9ECParametersHolder == null ? null : x9ECParametersHolder.getParameters();
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        X9ECParametersHolder x9ECParametersHolder = (X9ECParametersHolder)oidToCurve.get(aSN1ObjectIdentifier);
        return x9ECParametersHolder == null ? null : x9ECParametersHolder.getParameters();
    }

    public static ASN1ObjectIdentifier getOID(String string) {
        return (ASN1ObjectIdentifier)nameToOID.get(Strings.toLowerCase(string));
    }

    public static String getName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (String)oidToName.get(aSN1ObjectIdentifier);
    }

    public static Enumeration getNames() {
        return nameToCurve.keys();
    }

    static /* synthetic */ ECCurve access$000(ECCurve eCCurve) {
        return CustomNamedCurves.a(eCCurve);
    }

    static /* synthetic */ ECCurve access$100(ECCurve eCCurve, GLVTypeBParameters gLVTypeBParameters) {
        return CustomNamedCurves.a(eCCurve, gLVTypeBParameters);
    }

    static {
        CustomNamedCurves.defineCurve("curve25519", curve25519);
        CustomNamedCurves.defineCurveWithOID("secp192k1", SECObjectIdentifiers.secp192k1, secp192k1);
        CustomNamedCurves.defineCurveWithOID("secp192r1", SECObjectIdentifiers.secp192r1, secp192r1);
        CustomNamedCurves.defineCurveWithOID("secp224k1", SECObjectIdentifiers.secp224k1, secp224k1);
        CustomNamedCurves.defineCurveWithOID("secp224r1", SECObjectIdentifiers.secp224r1, secp224r1);
        CustomNamedCurves.defineCurveWithOID("secp256k1", SECObjectIdentifiers.secp256k1, secp256k1);
        CustomNamedCurves.defineCurveWithOID("secp256r1", SECObjectIdentifiers.secp256r1, secp256r1);
        CustomNamedCurves.defineCurveWithOID("secp384r1", SECObjectIdentifiers.secp384r1, secp384r1);
        CustomNamedCurves.defineCurveWithOID("secp521r1", SECObjectIdentifiers.secp521r1, secp521r1);
        CustomNamedCurves.defineCurveAlias("P-192", SECObjectIdentifiers.secp192r1);
        CustomNamedCurves.defineCurveAlias("P-224", SECObjectIdentifiers.secp224r1);
        CustomNamedCurves.defineCurveAlias("P-256", SECObjectIdentifiers.secp256r1);
        CustomNamedCurves.defineCurveAlias("P-384", SECObjectIdentifiers.secp384r1);
        CustomNamedCurves.defineCurveAlias("P-521", SECObjectIdentifiers.secp521r1);
    }
}

