/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.encodings;

import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.encodings.a;
import com.aspose.imaging.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import java.security.AccessController;
import java.security.SecureRandom;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    public static final String STRICT_LENGTH_ENABLED_PROPERTY = "com.aspose.imaging.internal.bouncycastle.pkcs1.strict";
    private static final int a = 10;
    private SecureRandom b;
    private AsymmetricBlockCipher c;
    private boolean d;
    private boolean e;
    private boolean f;
    private int g = -1;
    private byte[] h = null;

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher) {
        this.c = asymmetricBlockCipher;
        this.f = this.a();
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, int n2) {
        this.c = asymmetricBlockCipher;
        this.f = this.a();
        this.g = n2;
    }

    public PKCS1Encoding(AsymmetricBlockCipher asymmetricBlockCipher, byte[] byArray) {
        this.c = asymmetricBlockCipher;
        this.f = this.a();
        this.h = byArray;
        this.g = byArray.length;
    }

    private boolean a() {
        String string = (String)AccessController.doPrivileged(new a(this));
        return string == null || string.equals("true");
    }

    public AsymmetricBlockCipher getUnderlyingCipher() {
        return this.c;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        AsymmetricKeyParameter asymmetricKeyParameter;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.b = parametersWithRandom.getRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)parametersWithRandom.getParameters();
        } else {
            this.b = new SecureRandom();
            asymmetricKeyParameter = (AsymmetricKeyParameter)cipherParameters;
        }
        this.c.init(bl2, cipherParameters);
        this.e = asymmetricKeyParameter.isPrivate();
        this.d = bl2;
    }

    @Override
    public int getInputBlockSize() {
        int n2 = this.c.getInputBlockSize();
        if (this.d) {
            return n2 - 10;
        }
        return n2;
    }

    @Override
    public int getOutputBlockSize() {
        int n2 = this.c.getOutputBlockSize();
        if (this.d) {
            return n2;
        }
        return n2 - 10;
    }

    @Override
    public byte[] processBlock(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (this.d) {
            return this.a(byArray, n2, n3);
        }
        return this.c(byArray, n2, n3);
    }

    private byte[] a(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (n3 > this.getInputBlockSize()) {
            throw new IllegalArgumentException("input data too large");
        }
        byte[] byArray2 = new byte[this.c.getInputBlockSize()];
        if (this.e) {
            byArray2[0] = 1;
            for (int i2 = 1; i2 != byArray2.length - n3 - 1; ++i2) {
                byArray2[i2] = -1;
            }
        } else {
            this.b.nextBytes(byArray2);
            byArray2[0] = 2;
            for (int i3 = 1; i3 != byArray2.length - n3 - 1; ++i3) {
                while (byArray2[i3] == 0) {
                    byArray2[i3] = (byte)this.b.nextInt();
                }
            }
        }
        byArray2[byArray2.length - n3 - 1] = 0;
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        return this.c.processBlock(byArray2, 0, byArray2.length);
    }

    private static int a(byte[] byArray, int n2) {
        int n3 = 0;
        n3 |= byArray[0] ^ 2;
        int n4 = byArray.length - (n2 + 1);
        for (int i2 = 1; i2 < n4; ++i2) {
            int n5 = byArray[i2];
            n5 |= n5 >> 1;
            n5 |= n5 >> 2;
            n5 |= n5 >> 4;
            n3 |= (n5 & 1) - 1;
        }
        n3 |= byArray[byArray.length - (n2 + 1)];
        n3 |= n3 >> 1;
        n3 |= n3 >> 2;
        n3 |= n3 >> 4;
        return ~((n3 & 1) - 1);
    }

    private byte[] b(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        if (!this.e) {
            throw new InvalidCipherTextException("sorry, this method is only for decryption, not for signing");
        }
        byte[] byArray2 = this.c.processBlock(byArray, n2, n3);
        byte[] byArray3 = null;
        if (this.h == null) {
            byArray3 = new byte[this.g];
            this.b.nextBytes(byArray3);
        } else {
            byArray3 = this.h;
        }
        if (byArray2.length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block truncated");
        }
        if (this.f && byArray2.length != this.c.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block incorrect size");
        }
        int n4 = PKCS1Encoding.a(byArray2, this.g);
        byte[] byArray4 = new byte[this.g];
        for (int i2 = 0; i2 < this.g; ++i2) {
            byArray4[i2] = (byte)(byArray2[i2 + (byArray2.length - this.g)] & ~n4 | byArray3[i2] & n4);
        }
        return byArray4;
    }

    private byte[] c(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte by2;
        int n4;
        if (this.g != -1) {
            return this.b(byArray, n2, n3);
        }
        byte[] byArray2 = this.c.processBlock(byArray, n2, n3);
        if (byArray2.length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block truncated");
        }
        byte by3 = byArray2[0];
        if (this.e ? by3 != 2 : by3 != 1) {
            throw new InvalidCipherTextException("unknown block type");
        }
        if (this.f && byArray2.length != this.c.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block incorrect size");
        }
        for (n4 = 1; n4 != byArray2.length && (by2 = byArray2[n4]) != 0; ++n4) {
            if (by3 != 1 || by2 == -1) continue;
            throw new InvalidCipherTextException("block padding incorrect");
        }
        if (++n4 > byArray2.length || n4 < 10) {
            throw new InvalidCipherTextException("no data in block");
        }
        byte[] byArray3 = new byte[byArray2.length - n4];
        System.arraycopy(byArray2, n4, byArray3, 0, byArray3.length);
        return byArray3;
    }
}

