/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.engines;

import com.aspose.imaging.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.Wrapper;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithIV;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import java.security.SecureRandom;

public class RFC3211WrapEngine
implements Wrapper {
    private CBCBlockCipher a;
    private ParametersWithIV b;
    private boolean c;
    private SecureRandom d;

    public RFC3211WrapEngine(BlockCipher blockCipher) {
        this.a = new CBCBlockCipher(blockCipher);
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.c = bl2;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.d = parametersWithRandom.getRandom();
            this.b = (ParametersWithIV)parametersWithRandom.getParameters();
        } else {
            if (bl2) {
                this.d = new SecureRandom();
            }
            this.b = (ParametersWithIV)cipherParameters;
        }
    }

    @Override
    public String getAlgorithmName() {
        return this.a.getUnderlyingCipher().getAlgorithmName() + "/RFC3211Wrap";
    }

    @Override
    public byte[] wrap(byte[] byArray, int n2, int n3) {
        int n4;
        if (!this.c) {
            throw new IllegalStateException("not set for wrapping");
        }
        this.a.init(true, this.b);
        int n5 = this.a.getBlockSize();
        byte[] byArray2 = n3 + 4 < n5 * 2 ? new byte[n5 * 2] : new byte[(n3 + 4) % n5 == 0 ? n3 + 4 : ((n3 + 4) / n5 + 1) * n5];
        byArray2[0] = (byte)n3;
        byArray2[1] = ~byArray[n2];
        byArray2[2] = ~byArray[n2 + 1];
        byArray2[3] = ~byArray[n2 + 2];
        System.arraycopy(byArray, n2, byArray2, 4, n3);
        for (n4 = n3 + 4; n4 < byArray2.length; ++n4) {
            byArray2[n4] = (byte)this.d.nextInt();
        }
        for (n4 = 0; n4 < byArray2.length; n4 += n5) {
            this.a.processBlock(byArray2, n4, byArray2, n4);
        }
        for (n4 = 0; n4 < byArray2.length; n4 += n5) {
            this.a.processBlock(byArray2, n4, byArray2, n4);
        }
        return byArray2;
    }

    @Override
    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        int n4;
        if (this.c) {
            throw new IllegalStateException("not set for unwrapping");
        }
        int n5 = this.a.getBlockSize();
        if (n3 < 2 * n5) {
            throw new InvalidCipherTextException("input too short");
        }
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n5];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        System.arraycopy(byArray, n2, byArray3, 0, byArray3.length);
        this.a.init(false, new ParametersWithIV(this.b.getParameters(), byArray3));
        for (n4 = n5; n4 < byArray2.length; n4 += n5) {
            this.a.processBlock(byArray2, n4, byArray2, n4);
        }
        System.arraycopy(byArray2, byArray2.length - byArray3.length, byArray3, 0, byArray3.length);
        this.a.init(false, new ParametersWithIV(this.b.getParameters(), byArray3));
        this.a.processBlock(byArray2, 0, byArray2, 0);
        this.a.init(false, this.b);
        for (n4 = 0; n4 < byArray2.length; n4 += n5) {
            this.a.processBlock(byArray2, n4, byArray2, n4);
        }
        if ((byArray2[0] & 0xFF) > byArray2.length - 4) {
            throw new InvalidCipherTextException("wrapped key corrupted");
        }
        byte[] byArray4 = new byte[byArray2[0] & 0xFF];
        System.arraycopy(byArray2, 4, byArray4, 0, byArray2[0]);
        int n6 = 0;
        for (int i2 = 0; i2 != 3; ++i2) {
            byte by2 = ~byArray2[1 + i2];
            n6 |= by2 ^ byArray4[i2];
        }
        if (n6 != 0) {
            throw new InvalidCipherTextException("wrapped key fails checksum");
        }
        return byArray4;
    }
}

