/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.generators;

import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.aspose.imaging.internal.bouncycastle.crypto.KeyGenerationParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RSAKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import com.aspose.imaging.internal.bouncycastle.math.ec.WNafUtil;
import java.math.BigInteger;

public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger a = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters b;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.b = (RSAKeyGenerationParameters)keyGenerationParameters;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = null;
        boolean bl2 = false;
        while (!bl2) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            BigInteger bigInteger7;
            BigInteger bigInteger8;
            int n2 = this.b.getStrength();
            int n3 = (n2 + 1) / 2;
            int n4 = n2 - n3;
            int n5 = n2 / 3;
            int n6 = n2 >> 2;
            BigInteger bigInteger9 = this.b.getPublicExponent();
            BigInteger bigInteger10 = this.chooseRandomPrime(n3, bigInteger9);
            while (true) {
                if ((bigInteger8 = (bigInteger7 = this.chooseRandomPrime(n4, bigInteger9)).subtract(bigInteger10).abs()).bitLength() < n5) {
                    continue;
                }
                bigInteger6 = bigInteger10.multiply(bigInteger7);
                if (bigInteger6.bitLength() != n2) {
                    bigInteger10 = bigInteger10.max(bigInteger7);
                    continue;
                }
                if (WNafUtil.getNafWeight(bigInteger6) >= n6) break;
                bigInteger10 = this.chooseRandomPrime(n3, bigInteger9);
            }
            if (bigInteger10.compareTo(bigInteger7) < 0) {
                bigInteger5 = bigInteger10;
                bigInteger10 = bigInteger7;
                bigInteger7 = bigInteger5;
            }
            if ((bigInteger4 = bigInteger9.modInverse(bigInteger3 = (bigInteger5 = (bigInteger2 = bigInteger10.subtract(a)).multiply(bigInteger = bigInteger7.subtract(a))).divide(bigInteger2.gcd(bigInteger)))).bitLength() <= n4 || !bigInteger4.equals(bigInteger9.modInverse(bigInteger5))) continue;
            bl2 = true;
            bigInteger8 = bigInteger4.remainder(bigInteger2);
            BigInteger bigInteger11 = bigInteger4.remainder(bigInteger);
            BigInteger bigInteger12 = bigInteger7.modInverse(bigInteger10);
            asymmetricCipherKeyPair = new AsymmetricCipherKeyPair(new RSAKeyParameters(false, bigInteger6, bigInteger9), new RSAPrivateCrtKeyParameters(bigInteger6, bigInteger9, bigInteger4, bigInteger10, bigInteger7, bigInteger8, bigInteger11, bigInteger12));
        }
        return asymmetricCipherKeyPair;
    }

    protected BigInteger chooseRandomPrime(int n2, BigInteger bigInteger) {
        BigInteger bigInteger2;
        while ((bigInteger2 = new BigInteger(n2, 1, this.b.getRandom())).mod(bigInteger).equals(a) || !bigInteger2.isProbablePrime(this.b.getCertainty()) || !bigInteger.gcd(bigInteger2.subtract(a)).equals(a)) {
        }
        return bigInteger2;
    }
}

