/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.macs;

import com.aspose.imaging.internal.bouncycastle.crypto.BlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.Mac;
import com.aspose.imaging.internal.bouncycastle.crypto.modes.CBCBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.paddings.ISO7816d4Padding;
import com.aspose.imaging.internal.bouncycastle.crypto.params.KeyParameter;

public class CMac
implements Mac {
    private static final byte a = -121;
    private static final byte b = 27;
    private byte[] c;
    private byte[] d;
    private byte[] e;
    private int f;
    private BlockCipher g;
    private int h;
    private byte[] i;
    private byte[] j;
    private byte[] k;

    public CMac(BlockCipher blockCipher) {
        this(blockCipher, blockCipher.getBlockSize() * 8);
    }

    public CMac(BlockCipher blockCipher, int n2) {
        if (n2 % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (n2 > blockCipher.getBlockSize() * 8) {
            throw new IllegalArgumentException("MAC size must be less or equal to " + blockCipher.getBlockSize() * 8);
        }
        if (blockCipher.getBlockSize() != 8 && blockCipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("Block size must be either 64 or 128 bits");
        }
        this.g = new CBCBlockCipher(blockCipher);
        this.h = n2 / 8;
        this.d = new byte[blockCipher.getBlockSize()];
        this.e = new byte[blockCipher.getBlockSize()];
        this.c = new byte[blockCipher.getBlockSize()];
        this.f = 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.g.getAlgorithmName();
    }

    private static int a(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = 0;
        while (--n2 >= 0) {
            int n4 = byArray[n2] & 0xFF;
            byArray2[n2] = (byte)(n4 << 1 | n3);
            n3 = n4 >>> 7 & 1;
        }
        return n3;
    }

    private static byte[] a(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n2 = CMac.a(byArray, byArray2);
        int n3 = 0xFF & (byArray.length == 16 ? -121 : 27);
        int n4 = byArray.length - 1;
        byArray2[n4] = (byte)(byArray2[n4] ^ n3 >>> (1 - n2 << 3));
        return byArray2;
    }

    @Override
    public void init(CipherParameters cipherParameters) {
        this.validate(cipherParameters);
        this.g.init(true, cipherParameters);
        this.i = new byte[this.c.length];
        this.g.processBlock(this.c, 0, this.i, 0);
        this.j = CMac.a(this.i);
        this.k = CMac.a(this.j);
        this.reset();
    }

    void validate(CipherParameters cipherParameters) {
        if (cipherParameters != null && !(cipherParameters instanceof KeyParameter)) {
            throw new IllegalArgumentException("CMac mode only permits key to be set.");
        }
    }

    @Override
    public int getMacSize() {
        return this.h;
    }

    @Override
    public void update(byte by2) {
        if (this.f == this.e.length) {
            this.g.processBlock(this.e, 0, this.d, 0);
            this.f = 0;
        }
        this.e[this.f++] = by2;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int n4 = this.g.getBlockSize();
        int n5 = n4 - this.f;
        if (n3 > n5) {
            System.arraycopy(byArray, n2, this.e, this.f, n5);
            this.g.processBlock(this.e, 0, this.d, 0);
            this.f = 0;
            n3 -= n5;
            n2 += n5;
            while (n3 > n4) {
                this.g.processBlock(byArray, n2, this.d, 0);
                n3 -= n4;
                n2 += n4;
            }
        }
        System.arraycopy(byArray, n2, this.e, this.f, n3);
        this.f += n3;
    }

    @Override
    public int doFinal(byte[] byArray, int n2) {
        byte[] byArray2;
        int n3 = this.g.getBlockSize();
        if (this.f == n3) {
            byArray2 = this.j;
        } else {
            new ISO7816d4Padding().addPadding(this.e, this.f);
            byArray2 = this.k;
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            int n4 = i2;
            this.e[n4] = (byte)(this.e[n4] ^ byArray2[i2]);
        }
        this.g.processBlock(this.e, 0, this.d, 0);
        System.arraycopy(this.d, 0, byArray, n2, this.h);
        this.reset();
        return this.h;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.e.length; ++i2) {
            this.e[i2] = 0;
        }
        this.f = 0;
        this.g.reset();
    }
}

