/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.signers;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.DSA;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DSAKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DSAParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.imaging.internal.bouncycastle.crypto.signers.DSAKCalculator;
import com.aspose.imaging.internal.bouncycastle.crypto.signers.RandomDSAKCalculator;
import java.math.BigInteger;
import java.security.SecureRandom;

public class DSASigner
implements DSA {
    private final DSAKCalculator a;
    private DSAKeyParameters b;
    private SecureRandom c;

    public DSASigner() {
        this.a = new RandomDSAKCalculator();
    }

    public DSASigner(DSAKCalculator dSAKCalculator) {
        this.a = dSAKCalculator;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        SecureRandom secureRandom = null;
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.b = (DSAPrivateKeyParameters)parametersWithRandom.getParameters();
                secureRandom = parametersWithRandom.getRandom();
            } else {
                this.b = (DSAPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.b = (DSAPublicKeyParameters)cipherParameters;
        }
        this.c = this.initSecureRandom(bl2 && !this.a.isDeterministic(), secureRandom);
    }

    @Override
    public BigInteger[] generateSignature(byte[] byArray) {
        DSAParameters dSAParameters = this.b.getParameters();
        BigInteger bigInteger = dSAParameters.getQ();
        BigInteger bigInteger2 = this.a(bigInteger, byArray);
        BigInteger bigInteger3 = ((DSAPrivateKeyParameters)this.b).getX();
        if (this.a.isDeterministic()) {
            this.a.init(bigInteger, bigInteger3, byArray);
        } else {
            this.a.init(bigInteger, this.c);
        }
        BigInteger bigInteger4 = this.a.nextK();
        BigInteger bigInteger5 = dSAParameters.getG().modPow(bigInteger4, dSAParameters.getP()).mod(bigInteger);
        bigInteger4 = bigInteger4.modInverse(bigInteger).multiply(bigInteger2.add(bigInteger3.multiply(bigInteger5)));
        BigInteger bigInteger6 = bigInteger4.mod(bigInteger);
        return new BigInteger[]{bigInteger5, bigInteger6};
    }

    @Override
    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        DSAParameters dSAParameters = this.b.getParameters();
        BigInteger bigInteger3 = dSAParameters.getQ();
        BigInteger bigInteger4 = this.a(bigInteger3, byArray);
        BigInteger bigInteger5 = BigInteger.valueOf(0L);
        if (bigInteger5.compareTo(bigInteger) >= 0 || bigInteger3.compareTo(bigInteger) <= 0) {
            return false;
        }
        if (bigInteger5.compareTo(bigInteger2) >= 0 || bigInteger3.compareTo(bigInteger2) <= 0) {
            return false;
        }
        BigInteger bigInteger6 = bigInteger2.modInverse(bigInteger3);
        BigInteger bigInteger7 = bigInteger4.multiply(bigInteger6).mod(bigInteger3);
        BigInteger bigInteger8 = bigInteger.multiply(bigInteger6).mod(bigInteger3);
        BigInteger bigInteger9 = dSAParameters.getP();
        bigInteger7 = dSAParameters.getG().modPow(bigInteger7, bigInteger9);
        bigInteger8 = ((DSAPublicKeyParameters)this.b).getY().modPow(bigInteger8, bigInteger9);
        BigInteger bigInteger10 = bigInteger7.multiply(bigInteger8).mod(bigInteger9).mod(bigInteger3);
        return bigInteger10.equals(bigInteger);
    }

    private BigInteger a(BigInteger bigInteger, byte[] byArray) {
        if (bigInteger.bitLength() >= byArray.length * 8) {
            return new BigInteger(1, byArray);
        }
        byte[] byArray2 = new byte[bigInteger.bitLength() / 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return new BigInteger(1, byArray2);
    }

    protected SecureRandom initSecureRandom(boolean bl2, SecureRandom secureRandom) {
        return !bl2 ? null : (secureRandom != null ? secureRandom : new SecureRandom());
    }
}

