/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.signers;

import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.DSA;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.imaging.internal.bouncycastle.crypto.signers.DSAKCalculator;
import com.aspose.imaging.internal.bouncycastle.crypto.signers.RandomDSAKCalculator;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECAlgorithms;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECConstants;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECMultiplier;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.imaging.internal.bouncycastle.math.ec.FixedPointCombMultiplier;
import java.math.BigInteger;
import java.security.SecureRandom;

public class ECDSASigner
implements DSA,
ECConstants {
    private final DSAKCalculator a;
    private ECKeyParameters b;
    private SecureRandom c;

    public ECDSASigner() {
        this.a = new RandomDSAKCalculator();
    }

    public ECDSASigner(DSAKCalculator dSAKCalculator) {
        this.a = dSAKCalculator;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        SecureRandom secureRandom = null;
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.b = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
                secureRandom = parametersWithRandom.getRandom();
            } else {
                this.b = (ECPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.b = (ECPublicKeyParameters)cipherParameters;
        }
        this.c = this.initSecureRandom(bl2 && !this.a.isDeterministic(), secureRandom);
    }

    @Override
    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        ECPoint eCPoint;
        BigInteger bigInteger3;
        ECDomainParameters eCDomainParameters = this.b.getParameters();
        BigInteger bigInteger4 = eCDomainParameters.getN();
        BigInteger bigInteger5 = this.calculateE(bigInteger4, byArray);
        BigInteger bigInteger6 = ((ECPrivateKeyParameters)this.b).getD();
        if (this.a.isDeterministic()) {
            this.a.init(bigInteger4, bigInteger6, byArray);
        } else {
            this.a.init(bigInteger4, this.c);
        }
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        do {
            bigInteger2 = this.a.nextK();
        } while ((bigInteger3 = (eCPoint = eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger2).normalize()).getAffineXCoord().toBigInteger().mod(bigInteger4)).equals(ZERO) || (bigInteger = bigInteger2.modInverse(bigInteger4).multiply(bigInteger5.add(bigInteger6.multiply(bigInteger3))).mod(bigInteger4)).equals(ZERO));
        return new BigInteger[]{bigInteger3, bigInteger};
    }

    @Override
    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        ECDomainParameters eCDomainParameters = this.b.getParameters();
        BigInteger bigInteger3 = eCDomainParameters.getN();
        BigInteger bigInteger4 = this.calculateE(bigInteger3, byArray);
        if (bigInteger.compareTo(ONE) < 0 || bigInteger.compareTo(bigInteger3) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ONE) < 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger2.modInverse(bigInteger3);
        BigInteger bigInteger6 = bigInteger4.multiply(bigInteger5).mod(bigInteger3);
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger5).mod(bigInteger3);
        ECPoint eCPoint2 = eCDomainParameters.getG();
        ECPoint eCPoint3 = ECAlgorithms.sumOfTwoMultiplies(eCPoint2, bigInteger6, eCPoint = ((ECPublicKeyParameters)this.b).getQ(), bigInteger7).normalize();
        if (eCPoint3.isInfinity()) {
            return false;
        }
        BigInteger bigInteger8 = eCPoint3.getAffineXCoord().toBigInteger().mod(bigInteger3);
        return bigInteger8.equals(bigInteger);
    }

    protected BigInteger calculateE(BigInteger bigInteger, byte[] byArray) {
        int n2 = bigInteger.bitLength();
        int n3 = byArray.length * 8;
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        if (n2 < n3) {
            bigInteger2 = bigInteger2.shiftRight(n3 - n2);
        }
        return bigInteger2;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    protected SecureRandom initSecureRandom(boolean bl2, SecureRandom secureRandom) {
        return !bl2 ? null : (secureRandom != null ? secureRandom : new SecureRandom());
    }
}

