/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.signers;

import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.CryptoException;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.SignerWithRecovery;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RSAKeyParameters;
import com.aspose.imaging.internal.bouncycastle.util.Arrays;
import com.aspose.imaging.internal.bouncycastle.util.Integers;
import java.util.Hashtable;

public class ISO9796d2Signer
implements SignerWithRecovery {
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    private static Hashtable a = new Hashtable();
    private Digest b;
    private AsymmetricBlockCipher c;
    private int d;
    private int e;
    private byte[] f;
    private byte[] g;
    private int h;
    private boolean i;
    private byte[] j;
    private byte[] k;
    private byte[] l;

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, boolean bl2) {
        this.c = asymmetricBlockCipher;
        this.b = digest;
        if (bl2) {
            this.d = 188;
        } else {
            Integer n2 = (Integer)a.get(digest.getAlgorithmName());
            if (n2 != null) {
                this.d = n2;
            } else {
                throw new IllegalArgumentException("no valid trailer for digest");
            }
        }
    }

    public ISO9796d2Signer(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this(asymmetricBlockCipher, digest, false);
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)cipherParameters;
        this.c.init(bl2, rSAKeyParameters);
        this.e = rSAKeyParameters.getModulus().bitLength();
        this.f = new byte[(this.e + 7) / 8];
        this.g = this.d == 188 ? new byte[this.f.length - this.b.getDigestSize() - 2] : new byte[this.f.length - this.b.getDigestSize() - 3];
        this.reset();
    }

    private boolean a(byte[] byArray, byte[] byArray2) {
        boolean bl2 = true;
        if (this.h > this.g.length) {
            if (this.g.length > byArray2.length) {
                bl2 = false;
            }
            for (int i2 = 0; i2 != this.g.length; ++i2) {
                if (byArray[i2] == byArray2[i2]) continue;
                bl2 = false;
            }
        } else {
            if (this.h != byArray2.length) {
                bl2 = false;
            }
            for (int i3 = 0; i3 != byArray2.length; ++i3) {
                if (byArray[i3] == byArray2[i3]) continue;
                bl2 = false;
            }
        }
        return bl2;
    }

    private void a(byte[] byArray) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    @Override
    public void updateWithRecoveredMessage(byte[] byArray) throws InvalidCipherTextException {
        int n2;
        byte[] byArray2 = this.c.processBlock(byArray, 0, byArray.length);
        if ((byArray2[0] & 0xC0 ^ 0x40) != 0) {
            throw new InvalidCipherTextException("malformed signature");
        }
        if ((byArray2[byArray2.length - 1] & 0xF ^ 0xC) != 0) {
            throw new InvalidCipherTextException("malformed signature");
        }
        int n3 = 0;
        if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) == 0) {
            n3 = 1;
        } else {
            n2 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
            Integer n4 = (Integer)a.get(this.b.getAlgorithmName());
            if (n4 != null) {
                if (n2 != n4) {
                    throw new IllegalStateException("signer initialised with wrong digest for trailer " + n2);
                }
            } else {
                throw new IllegalArgumentException("unrecognised hash in signature");
            }
            n3 = 2;
        }
        n2 = 0;
        for (n2 = 0; n2 != byArray2.length && (byArray2[n2] & 0xF ^ 0xA) != 0; ++n2) {
        }
        int n5 = byArray2.length - n3 - this.b.getDigestSize();
        if (n5 - ++n2 <= 0) {
            throw new InvalidCipherTextException("malformed block");
        }
        if ((byArray2[0] & 0x20) == 0) {
            this.i = true;
            this.j = new byte[n5 - n2];
            System.arraycopy(byArray2, n2, this.j, 0, this.j.length);
        } else {
            this.i = false;
            this.j = new byte[n5 - n2];
            System.arraycopy(byArray2, n2, this.j, 0, this.j.length);
        }
        this.k = byArray;
        this.l = byArray2;
        this.b.update(this.j, 0, this.j.length);
        this.h = this.j.length;
        System.arraycopy(this.j, 0, this.g, 0, this.j.length);
    }

    @Override
    public void update(byte by2) {
        this.b.update(by2);
        if (this.h < this.g.length) {
            this.g[this.h] = by2;
        }
        ++this.h;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        while (n3 > 0 && this.h < this.g.length) {
            this.update(byArray[n2]);
            ++n2;
            --n3;
        }
        this.b.update(byArray, n2, n3);
        this.h += n3;
    }

    @Override
    public void reset() {
        this.b.reset();
        this.h = 0;
        this.a(this.g);
        if (this.j != null) {
            this.a(this.j);
        }
        this.j = null;
        this.i = false;
        if (this.k != null) {
            this.k = null;
            this.a(this.l);
            this.l = null;
        }
    }

    @Override
    public byte[] generateSignature() throws CryptoException {
        int n2;
        int n3 = this.b.getDigestSize();
        int n4 = 0;
        int n5 = 0;
        if (this.d == 188) {
            n4 = 8;
            n5 = this.f.length - n3 - 1;
            this.b.doFinal(this.f, n5);
            this.f[this.f.length - 1] = -68;
        } else {
            n4 = 16;
            n5 = this.f.length - n3 - 2;
            this.b.doFinal(this.f, n5);
            this.f[this.f.length - 2] = (byte)(this.d >>> 8);
            this.f[this.f.length - 1] = (byte)this.d;
        }
        int n6 = 0;
        int n7 = (n3 + this.h) * 8 + n4 + 4 - this.e;
        if (n7 > 0) {
            n2 = this.h - (n7 + 7) / 8;
            n6 = 96;
            System.arraycopy(this.g, 0, this.f, n5 -= n2, n2);
        } else {
            n6 = 64;
            System.arraycopy(this.g, 0, this.f, n5 -= this.h, this.h);
        }
        if (n5 - 1 > 0) {
            for (n2 = n5 - 1; n2 != 0; --n2) {
                this.f[n2] = -69;
            }
            int n8 = n5 - 1;
            this.f[n8] = (byte)(this.f[n8] ^ 1);
            this.f[0] = 11;
            this.f[0] = (byte)(this.f[0] | n6);
        } else {
            this.f[0] = 10;
            this.f[0] = (byte)(this.f[0] | n6);
        }
        byte[] byArray = this.c.processBlock(this.f, 0, this.f.length);
        this.a(this.g);
        this.a(this.f);
        return byArray;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        Object object;
        int n2;
        byte[] byArray2 = null;
        if (this.k == null) {
            try {
                byArray2 = this.c.processBlock(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                return false;
            }
        } else {
            if (!Arrays.areEqual(this.k, byArray)) {
                throw new IllegalStateException("updateWithRecoveredMessage called on different signature");
            }
            byArray2 = this.l;
            this.k = null;
            this.l = null;
        }
        if ((byArray2[0] & 0xC0 ^ 0x40) != 0) {
            return this.b(byArray2);
        }
        if ((byArray2[byArray2.length - 1] & 0xF ^ 0xC) != 0) {
            return this.b(byArray2);
        }
        int n3 = 0;
        if ((byArray2[byArray2.length - 1] & 0xFF ^ 0xBC) == 0) {
            n3 = 1;
        } else {
            n2 = (byArray2[byArray2.length - 2] & 0xFF) << 8 | byArray2[byArray2.length - 1] & 0xFF;
            object = (Integer)a.get(this.b.getAlgorithmName());
            if (object != null) {
                if (n2 != object.intValue()) {
                    throw new IllegalStateException("signer initialised with wrong digest for trailer " + n2);
                }
            } else {
                throw new IllegalArgumentException("unrecognised hash in signature");
            }
            n3 = 2;
        }
        n2 = 0;
        for (n2 = 0; n2 != byArray2.length && (byArray2[n2] & 0xF ^ 0xA) != 0; ++n2) {
        }
        object = new byte[this.b.getDigestSize()];
        int n4 = byArray2.length - n3 - ((byte[])object).length;
        if (n4 - ++n2 <= 0) {
            return this.b(byArray2);
        }
        if ((byArray2[0] & 0x20) == 0) {
            this.i = true;
            if (this.h > n4 - n2) {
                return this.b(byArray2);
            }
            this.b.reset();
            this.b.update(byArray2, n2, n4 - n2);
            this.b.doFinal((byte[])object, 0);
            boolean bl2 = true;
            for (int i2 = 0; i2 != ((Object)object).length; ++i2) {
                int n5 = n4 + i2;
                byArray2[n5] = (byte)(byArray2[n5] ^ object[i2]);
                if (byArray2[n4 + i2] == 0) continue;
                bl2 = false;
            }
            if (!bl2) {
                return this.b(byArray2);
            }
            this.j = new byte[n4 - n2];
            System.arraycopy(byArray2, n2, this.j, 0, this.j.length);
        } else {
            this.i = false;
            this.b.doFinal((byte[])object, 0);
            boolean bl3 = true;
            for (int i3 = 0; i3 != ((Object)object).length; ++i3) {
                int n6 = n4 + i3;
                byArray2[n6] = (byte)(byArray2[n6] ^ object[i3]);
                if (byArray2[n4 + i3] == 0) continue;
                bl3 = false;
            }
            if (!bl3) {
                return this.b(byArray2);
            }
            this.j = new byte[n4 - n2];
            System.arraycopy(byArray2, n2, this.j, 0, this.j.length);
        }
        if (this.h != 0 && !this.a(this.g, this.j)) {
            return this.b(byArray2);
        }
        this.a(this.g);
        this.a(byArray2);
        return true;
    }

    private boolean b(byte[] byArray) {
        this.a(this.g);
        this.a(byArray);
        return false;
    }

    @Override
    public boolean hasFullMessage() {
        return this.i;
    }

    @Override
    public byte[] getRecoveredMessage() {
        return this.j;
    }

    static {
        a.put("RIPEMD128", Integers.valueOf(13004));
        a.put("RIPEMD160", Integers.valueOf(12748));
        a.put("SHA-1", Integers.valueOf(13260));
        a.put("SHA-256", Integers.valueOf(13516));
        a.put("SHA-384", Integers.valueOf(14028));
        a.put("SHA-512", Integers.valueOf(13772));
        a.put("Whirlpool", Integers.valueOf(14284));
    }
}

