/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.signers;

import com.aspose.imaging.internal.bouncycastle.crypto.AsymmetricBlockCipher;
import com.aspose.imaging.internal.bouncycastle.crypto.CipherParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.CryptoException;
import com.aspose.imaging.internal.bouncycastle.crypto.DataLengthException;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.Signer;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ParametersWithRandom;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RSABlindingParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RSAKeyParameters;
import java.security.SecureRandom;

public class PSSSigner
implements Signer {
    public static final byte TRAILER_IMPLICIT = -68;
    private Digest a;
    private Digest b;
    private AsymmetricBlockCipher c;
    private SecureRandom d;
    private int e;
    private int f;
    private int g;
    private int h;
    private byte[] i;
    private byte[] j;
    private byte[] k;
    private byte l;

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n2) {
        this(asymmetricBlockCipher, digest, n2, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, int n2) {
        this(asymmetricBlockCipher, digest, digest2, n2, -68);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, int n2, byte by2) {
        this(asymmetricBlockCipher, digest, digest, n2, by2);
    }

    public PSSSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest, Digest digest2, int n2, byte by2) {
        this.c = asymmetricBlockCipher;
        this.a = digest;
        this.b = digest2;
        this.e = digest.getDigestSize();
        this.f = digest2.getDigestSize();
        this.g = n2;
        this.i = new byte[n2];
        this.j = new byte[8 + n2 + this.e];
        this.l = by2;
    }

    @Override
    public void init(boolean bl2, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        CipherParameters cipherParameters3;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters3 = (ParametersWithRandom)cipherParameters;
            cipherParameters2 = ((ParametersWithRandom)cipherParameters3).getParameters();
            this.d = ((ParametersWithRandom)cipherParameters3).getRandom();
        } else {
            cipherParameters2 = cipherParameters;
            if (bl2) {
                this.d = new SecureRandom();
            }
        }
        this.c.init(bl2, cipherParameters2);
        cipherParameters3 = cipherParameters2 instanceof RSABlindingParameters ? ((RSABlindingParameters)cipherParameters2).getPublicKey() : (RSAKeyParameters)cipherParameters2;
        this.h = ((RSAKeyParameters)cipherParameters3).getModulus().bitLength() - 1;
        if (this.h < 8 * this.e + 8 * this.g + 9) {
            throw new IllegalArgumentException("key too small for specified hash and salt lengths");
        }
        this.k = new byte[(this.h + 7) / 8];
        this.reset();
    }

    private void a(byte[] byArray) {
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byArray[i2] = 0;
        }
    }

    @Override
    public void update(byte by2) {
        this.a.update(by2);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        this.a.update(byArray, n2, n3);
    }

    @Override
    public void reset() {
        this.a.reset();
    }

    @Override
    public byte[] generateSignature() throws CryptoException, DataLengthException {
        this.a.doFinal(this.j, this.j.length - this.e - this.g);
        if (this.g != 0) {
            this.d.nextBytes(this.i);
            System.arraycopy(this.i, 0, this.j, this.j.length - this.g, this.g);
        }
        byte[] byArray = new byte[this.e];
        this.a.update(this.j, 0, this.j.length);
        this.a.doFinal(byArray, 0);
        this.k[this.k.length - this.g - 1 - this.e - 1] = 1;
        System.arraycopy(this.i, 0, this.k, this.k.length - this.g - this.e - 1, this.g);
        byte[] byArray2 = this.a(byArray, 0, byArray.length, this.k.length - this.e - 1);
        for (int i2 = 0; i2 != byArray2.length; ++i2) {
            int n2 = i2;
            this.k[n2] = (byte)(this.k[n2] ^ byArray2[i2]);
        }
        this.k[0] = (byte)(this.k[0] & 255 >> this.k.length * 8 - this.h);
        System.arraycopy(byArray, 0, this.k, this.k.length - this.e - 1, this.e);
        this.k[this.k.length - 1] = this.l;
        byte[] byArray3 = this.c.processBlock(this.k, 0, this.k.length);
        this.a(this.k);
        return byArray3;
    }

    @Override
    public boolean verifySignature(byte[] byArray) {
        int n2;
        byte[] byArray2;
        this.a.doFinal(this.j, this.j.length - this.e - this.g);
        try {
            byArray2 = this.c.processBlock(byArray, 0, byArray.length);
            System.arraycopy(byArray2, 0, this.k, this.k.length - byArray2.length, byArray2.length);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.k[this.k.length - 1] != this.l) {
            this.a(this.k);
            return false;
        }
        byArray2 = this.a(this.k, this.k.length - this.e - 1, this.e, this.k.length - this.e - 1);
        for (n2 = 0; n2 != byArray2.length; ++n2) {
            int n3 = n2;
            this.k[n3] = (byte)(this.k[n3] ^ byArray2[n2]);
        }
        this.k[0] = (byte)(this.k[0] & 255 >> this.k.length * 8 - this.h);
        for (n2 = 0; n2 != this.k.length - this.e - this.g - 2; ++n2) {
            if (this.k[n2] == 0) continue;
            this.a(this.k);
            return false;
        }
        if (this.k[this.k.length - this.e - this.g - 2] != 1) {
            this.a(this.k);
            return false;
        }
        System.arraycopy(this.k, this.k.length - this.g - this.e - 1, this.j, this.j.length - this.g, this.g);
        this.a.update(this.j, 0, this.j.length);
        this.a.doFinal(this.j, this.j.length - this.e);
        n2 = this.k.length - this.e - 1;
        for (int i2 = this.j.length - this.e; i2 != this.j.length; ++i2) {
            if ((this.k[n2] ^ this.j[i2]) != 0) {
                this.a(this.j);
                this.a(this.k);
                return false;
            }
            ++n2;
        }
        this.a(this.j);
        this.a(this.k);
        return true;
    }

    private void a(int n2, byte[] byArray) {
        byArray[0] = (byte)(n2 >>> 24);
        byArray[1] = (byte)(n2 >>> 16);
        byArray[2] = (byte)(n2 >>> 8);
        byArray[3] = (byte)(n2 >>> 0);
    }

    private byte[] a(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[this.f];
        byte[] byArray4 = new byte[4];
        this.b.reset();
        for (n5 = 0; n5 < n4 / this.f; ++n5) {
            this.a(n5, byArray4);
            this.b.update(byArray, n2, n3);
            this.b.update(byArray4, 0, byArray4.length);
            this.b.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * this.f, this.f);
        }
        if (n5 * this.f < n4) {
            this.a(n5, byArray4);
            this.b.update(byArray, n2, n3);
            this.b.update(byArray4, 0, byArray4.length);
            this.b.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, byArray2, n5 * this.f, byArray2.length - n5 * this.f);
        }
        return byArray2;
    }
}

