/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.crypto.util;

import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Integer;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Object;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.DERNull;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.RSAPublicKey;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X962Parameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECParameters;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ECPoint;
import com.aspose.imaging.internal.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECNamedDomainParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.aspose.imaging.internal.bouncycastle.crypto.params.RSAKeyParameters;
import java.io.IOException;

public class SubjectPublicKeyInfoFactory {
    public static SubjectPublicKeyInfo createSubjectPublicKeyInfo(AsymmetricKeyParameter asymmetricKeyParameter) throws IOException {
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAKeyParameters rSAKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPublicKey(rSAKeyParameters.getModulus(), rSAKeyParameters.getExponent()));
        }
        if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dSAPublicKeyParameters = (DSAPublicKeyParameters)asymmetricKeyParameter;
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa), new ASN1Integer(dSAPublicKeyParameters.getY()));
        }
        if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
            ASN1Object aSN1Object;
            X962Parameters x962Parameters;
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricKeyParameter;
            ECDomainParameters eCDomainParameters = eCPublicKeyParameters.getParameters();
            if (eCDomainParameters == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else if (eCDomainParameters instanceof ECNamedDomainParameters) {
                x962Parameters = new X962Parameters(((ECNamedDomainParameters)eCDomainParameters).getName());
            } else {
                aSN1Object = new X9ECParameters(eCDomainParameters.getCurve(), eCDomainParameters.getG(), eCDomainParameters.getN(), eCDomainParameters.getH(), eCDomainParameters.getSeed());
                x962Parameters = new X962Parameters((X9ECParameters)aSN1Object);
            }
            aSN1Object = (ASN1OctetString)new X9ECPoint(eCPublicKeyParameters.getQ()).toASN1Primitive();
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), ((ASN1OctetString)aSN1Object).getOctets());
        }
        throw new IOException("key parameters not recognised.");
    }
}

