/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.bouncycastle.math.ec;

import com.aspose.imaging.internal.bouncycastle.math.ec.AbstractECMultiplier;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECCurve;
import com.aspose.imaging.internal.bouncycastle.math.ec.ECPoint;
import com.aspose.imaging.internal.bouncycastle.math.ec.PreCompInfo;
import com.aspose.imaging.internal.bouncycastle.math.ec.WTauNafPreCompInfo;
import com.aspose.imaging.internal.bouncycastle.math.ec.c;
import com.aspose.imaging.internal.bouncycastle.math.ec.d;
import java.math.BigInteger;

public class WTauNafMultiplier
extends AbstractECMultiplier {
    static final String PRECOMP_NAME = "bc_wtnaf";

    @Override
    protected ECPoint multiplyPositive(ECPoint eCPoint, BigInteger bigInteger) {
        if (!(eCPoint instanceof ECPoint.F2m)) {
            throw new IllegalArgumentException("Only ECPoint.F2m can be used in WTauNafMultiplier");
        }
        ECPoint.F2m f2m = (ECPoint.F2m)eCPoint;
        ECCurve.F2m f2m2 = (ECCurve.F2m)f2m.getCurve();
        int n2 = f2m2.getM();
        byte by2 = f2m2.getA().toBigInteger().byteValue();
        byte by3 = f2m2.getMu();
        BigInteger[] bigIntegerArray = f2m2.getSi();
        d d2 = c.a(bigInteger, n2, by2, bigIntegerArray, by3, (byte)10);
        return this.a(f2m, d2, f2m2.getPreCompInfo(f2m, PRECOMP_NAME), by2, by3);
    }

    private ECPoint.F2m a(ECPoint.F2m f2m, d d2, PreCompInfo preCompInfo, byte by2, byte by3) {
        d[] dArray = by2 == 0 ? c.c : c.e;
        BigInteger bigInteger = c.a(by3, 4);
        byte[] byArray = c.a(by3, d2, (byte)4, BigInteger.valueOf(16L), bigInteger, dArray);
        return WTauNafMultiplier.a(f2m, byArray, preCompInfo);
    }

    private static ECPoint.F2m a(ECPoint.F2m f2m, byte[] byArray, PreCompInfo preCompInfo) {
        Object object;
        ECPoint.F2m[] f2mArray;
        ECCurve.F2m f2m2 = (ECCurve.F2m)f2m.getCurve();
        byte by2 = f2m2.getA().toBigInteger().byteValue();
        if (preCompInfo == null || !(preCompInfo instanceof WTauNafPreCompInfo)) {
            f2mArray = c.a(f2m, by2);
            object = new WTauNafPreCompInfo();
            ((WTauNafPreCompInfo)object).setPreComp(f2mArray);
            f2m2.setPreCompInfo(f2m, PRECOMP_NAME, (PreCompInfo)object);
        } else {
            f2mArray = ((WTauNafPreCompInfo)preCompInfo).getPreComp();
        }
        object = (ECPoint.F2m)f2m.getCurve().getInfinity();
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            object = c.a((ECPoint.F2m)object);
            byte by3 = byArray[i2];
            if (by3 == 0) continue;
            object = by3 > 0 ? ((ECPoint.F2m)object).addSimple(f2mArray[by3]) : ((ECPoint.F2m)object).subtractSimple(f2mArray[-by3]);
        }
        return object;
    }
}

