/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.internal.dh;

import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.InvalidOperationException;
import com.aspose.imaging.internal.Exceptions.Security.Cryptography.CryptographicException;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Encodable;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1EncodableVector;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Null;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1OctetString;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Primitive;
import com.aspose.imaging.internal.bouncycastle.asn1.ASN1Set;
import com.aspose.imaging.internal.bouncycastle.asn1.DERSet;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.AttributeTable;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.CMSAttributes;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.SignerIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.SignerInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.cms.Time;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.aspose.imaging.internal.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.Attribute;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.DigestInfo;
import com.aspose.imaging.internal.bouncycastle.asn1.x509.X509Name;
import com.aspose.imaging.internal.bouncycastle.crypto.Digest;
import com.aspose.imaging.internal.bouncycastle.crypto.InvalidCipherTextException;
import com.aspose.imaging.internal.bouncycastle.crypto.Signer;
import com.aspose.imaging.internal.bouncycastle.crypto.engines.RSABlindedEngine;
import com.aspose.imaging.internal.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.aspose.imaging.internal.bouncycastle.crypto.signers.PSSSigner;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.dh.A;
import com.aspose.imaging.internal.dh.B;
import com.aspose.imaging.internal.dh.Q;
import com.aspose.imaging.internal.dh.R;
import com.aspose.imaging.internal.dh.T;
import com.aspose.imaging.internal.dh.i;
import com.aspose.imaging.internal.dh.j;
import com.aspose.imaging.internal.dh.l;
import com.aspose.imaging.internal.dh.u;
import com.aspose.imaging.internal.dh.y;
import com.aspose.imaging.internal.dq.f;
import com.aspose.imaging.internal.dq.g;
import com.aspose.imaging.internal.dq.s;
import com.aspose.imaging.internal.dq.t;
import com.aspose.imaging.internal.ds.a;
import com.aspose.imaging.internal.ds.c;
import java.io.IOException;

public class S {
    private static final u a = u.a;
    private R b;
    private SignerInfo c;
    private AlgorithmIdentifier d;
    private AlgorithmIdentifier e;
    private final ASN1Set f;
    private final ASN1Set g;
    private l h;
    private byte[] i;
    private ASN1ObjectIdentifier j;
    private B k;
    private byte[] l;
    private AttributeTable m;
    private AttributeTable n;
    private final boolean o;

    public S(SignerInfo signerInfo, ASN1ObjectIdentifier aSN1ObjectIdentifier, l l2, B b2) {
        this.c = signerInfo;
        this.b = new R();
        this.j = aSN1ObjectIdentifier;
        this.o = aSN1ObjectIdentifier == null;
        try {
            SignerIdentifier signerIdentifier = signerInfo.getSID();
            if (signerIdentifier.isTagged()) {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(signerIdentifier.getId());
                this.b.c(aSN1OctetString.getEncoded());
            } else {
                IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(signerIdentifier.getId());
                this.b.a(X509Name.getInstance(issuerAndSerialNumber.getName()));
                this.b.a(issuerAndSerialNumber.getSerialNumber().getValue());
            }
        }
        catch (IOException iOException) {
            throw new ArgumentException("invalid sid in SignerInfo");
        }
        this.d = signerInfo.getDigestAlgorithm();
        this.f = signerInfo.getAuthenticatedAttributes();
        this.g = signerInfo.getUnauthenticatedAttributes();
        this.e = signerInfo.getDigestEncryptionAlgorithm();
        this.i = signerInfo.getEncryptedDigest().getOctets();
        this.h = l2;
        this.k = b2;
    }

    public boolean a() {
        return this.o;
    }

    public ASN1ObjectIdentifier b() {
        return this.j;
    }

    public R c() {
        return this.b;
    }

    public int d() {
        return this.c.getVersion().getValue().intValue();
    }

    public AlgorithmIdentifier e() {
        return this.d;
    }

    public String f() {
        return this.d.getObjectId().getId();
    }

    public ASN1Primitive g() {
        ASN1Encodable aSN1Encodable = this.d.getParameters();
        return aSN1Encodable == null ? null : aSN1Encodable.toASN1Primitive();
    }

    public byte[] h() {
        if (this.l == null) {
            throw new InvalidOperationException("method can only be called after verify.");
        }
        return (byte[])this.l.clone();
    }

    public AlgorithmIdentifier i() {
        return this.e;
    }

    public String j() {
        return this.e.getObjectId().getId();
    }

    public ASN1Primitive k() {
        ASN1Encodable aSN1Encodable = this.e.getParameters();
        return aSN1Encodable == null ? null : aSN1Encodable.toASN1Primitive();
    }

    public AttributeTable l() {
        if (this.f != null && this.m == null) {
            this.m = new AttributeTable(this.f);
        }
        return this.m;
    }

    public AttributeTable m() {
        if (this.g != null && this.n == null) {
            this.n = new AttributeTable(this.g);
        }
        return this.n;
    }

    public byte[] n() {
        return (byte[])this.i.clone();
    }

    public T o() {
        AttributeTable attributeTable = this.m();
        if (attributeTable == null) {
            return new T(com.aspose.imaging.internal.ds.c.a(0));
        }
        com.aspose.imaging.internal.aq.s s2 = com.aspose.imaging.internal.ds.c.a();
        ASN1EncodableVector aSN1EncodableVector = attributeTable.getAll(CMSAttributes.counterSignature);
        for (com.aspose.imaging.internal.bouncycastle.asn1.cms.Attribute attribute : (Iterable)((Object)aSN1EncodableVector)) {
            ASN1Set aSN1Set = attribute.getAttrValues();
            if (aSN1Set.size() < 1) {
                // empty if block
            }
            for (ASN1Encodable aSN1Encodable : (Iterable)((Object)aSN1Set)) {
                SignerInfo signerInfo = SignerInfo.getInstance(aSN1Encodable.toASN1Primitive());
                String string = u.a.a(signerInfo.getDigestAlgorithm().getObjectId().getId());
                s2.addItem(new S(signerInfo, null, null, new y(string, this.n())));
            }
        }
        return new T(s2);
    }

    public byte[] p() {
        try {
            return this.f == null ? null : this.f.getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CryptographicException(iOException.getMessage());
        }
    }

    private boolean b(AsymmetricKeyParameter asymmetricKeyParameter) {
        Signer signer;
        int n2;
        Object object;
        Object object2;
        String string = a.a(this.f());
        Digest digest = a.d(string);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = this.e.getObjectId();
        ASN1Encodable aSN1Encodable = this.e.getParameters();
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_RSASSA_PSS)) {
            if (aSN1Encodable == null) {
                throw new j("RSASSA-PSS signature must specify algorithm parameters");
            }
            try {
                object2 = RSASSAPSSparams.getInstance(aSN1Encodable.toASN1Primitive());
                if (!((RSASSAPSSparams)object2).getHashAlgorithm().getObjectId().equals(this.d.getObjectId())) {
                    throw new j("RSASSA-PSS signature parameters specified incorrect hash algorithm");
                }
                if (!((RSASSAPSSparams)object2).getMaskGenAlgorithm().getObjectId().equals(PKCSObjectIdentifiers.id_mgf1)) {
                    throw new j("RSASSA-PSS signature parameters specified unknown MGF");
                }
                object = com.aspose.imaging.internal.dq.g.a(((RSASSAPSSparams)object2).getHashAlgorithm().getObjectId());
                int n3 = ((RSASSAPSSparams)object2).getSaltLength().intValue();
                n2 = com.aspose.imaging.internal.dO.d.b((Object)((RSASSAPSSparams)object2).getTrailerField().intValue(), 9);
                if (com.aspose.imaging.internal.dO.d.e((Object)((byte)n2), 6) != 1) {
                    throw new j("RSASSA-PSS signature parameters must have trailerField of 1");
                }
                signer = new PSSSigner(new RSABlindedEngine(), (Digest)object, n3);
            }
            catch (RuntimeException runtimeException) {
                throw new j("failed to set RSASSA-PSS signature parameters", runtimeException);
            }
        } else {
            object2 = aY.a(new String[]{string, "with", a.c(this.j())});
            signer = a.e((String)object2);
        }
        try {
            if (this.k != null) {
                this.l = this.k.a();
            } else {
                if (this.h != null) {
                    this.h.a(new A(digest));
                } else if (this.f == null) {
                    throw new j("data not encapsulated in signature - use detached constructor.");
                }
                this.l = com.aspose.imaging.internal.dq.g.a(digest);
            }
        }
        catch (com.aspose.imaging.internal.Exceptions.IO.IOException iOException) {
            throw new j("can't process mime object to create signature.", iOException);
        }
        object2 = this.a(CMSAttributes.contentType, "content-type");
        if (object2 == null) {
            if (!this.o && this.f != null) {
                throw new j("The content-type attribute type MUST be present whenever signed attributes are present in signed-data");
            }
        } else {
            if (this.o) {
                throw new j("[For counter signatures,] the signedAttributes field MUST NOT contain a content-type attribute");
            }
            if (!com.aspose.imaging.internal.dO.d.b(object2, ASN1ObjectIdentifier.class)) {
                throw new j("content-type attribute value not of ASN.1 type 'OBJECT IDENTIFIER'");
            }
            object = (ASN1ObjectIdentifier)object2;
            if (!((ASN1Primitive)object).equals(this.j)) {
                throw new j("content-type attribute value does not match eContentType");
            }
        }
        if ((object2 = this.a(CMSAttributes.messageDigest, "message-digest")) == null) {
            if (this.f != null) {
                throw new j("the message-digest signed attribute type MUST be present when there are any signed attributes present");
            }
        } else {
            if (!com.aspose.imaging.internal.dO.d.b(object2, ASN1OctetString.class)) {
                throw new j("message-digest attribute value not of ASN.1 type 'OCTET STRING'");
            }
            object = (ASN1OctetString)object2;
            if (!com.aspose.imaging.internal.ds.a.a(this.l, ((ASN1OctetString)object).getOctets())) {
                throw new j("message-digest attribute value does not match calculated value");
            }
        }
        if ((object2 = this.l()) != null && ((AttributeTable)object2).getAll(CMSAttributes.counterSignature).size() > 0) {
            throw new j("A countersignature attribute MUST NOT be a signed attribute");
        }
        object = this.m();
        if (object != null) {
            ASN1EncodableVector aSN1EncodableVector = ((AttributeTable)object).getAll(CMSAttributes.counterSignature);
            for (n2 = 0; n2 < aSN1EncodableVector.size(); ++n2) {
                if (((Attribute)aSN1EncodableVector.get(n2)).getAttrValues().size() >= 1) continue;
                throw new j("A countersignature attribute MUST contain at least one AttributeValue");
            }
        }
        try {
            signer.init(false, asymmetricKeyParameter);
            if (this.f == null) {
                if (this.k != null) {
                    return this.a(this.l, asymmetricKeyParameter, this.n());
                }
                if (this.h != null) {
                    this.h.a(new Q(signer));
                }
            } else {
                object2 = this.p();
                signer.update((byte[])object2, 0, ((Object)object2).length);
            }
            return signer.verifySignature(this.n());
        }
        catch (com.aspose.imaging.internal.dq.l l2) {
            throw new j("key not appropriate to signature in message.", l2);
        }
        catch (com.aspose.imaging.internal.Exceptions.IO.IOException iOException) {
            throw new j("can't process mime object to create signature.", iOException);
        }
        catch (t t2) {
            throw new j(aY.a(new String[]{"invalid signature format in message: ", t2.getMessage()}), t2);
        }
    }

    private boolean a(ASN1Encodable aSN1Encodable) {
        return com.aspose.imaging.internal.dO.d.b((Object)aSN1Encodable, ASN1Null.class) || aSN1Encodable == null;
    }

    private DigestInfo a(byte[] byArray) throws IOException {
        if (com.aspose.imaging.internal.dO.d.e((Object)byArray[0], 6) != 48) {
            throw new com.aspose.imaging.internal.Exceptions.IO.IOException("not a digest info object");
        }
        DigestInfo digestInfo = DigestInfo.getInstance(ASN1Primitive.fromByteArray(byArray));
        if (digestInfo.getEncoded().length != byArray.length) {
            throw new j("malformed RSA signature");
        }
        return digestInfo;
    }

    private boolean a(byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray2) {
        String string = a.c(this.j());
        try {
            if (aY.e(string, "RSA")) {
                f f2 = new f(com.aspose.imaging.internal.dh.i.a.a("RSA/ECB/PKCS1Padding"));
                f2.a(false, asymmetricKeyParameter);
                byte[] byArray3 = f2.b(byArray2, 0, byArray2.length);
                DigestInfo digestInfo = this.a(byArray3);
                if (!digestInfo.getAlgorithmId().getObjectId().equals(this.d.getObjectId())) {
                    return false;
                }
                if (!this.a(digestInfo.getAlgorithmId().getParameters())) {
                    return false;
                }
                byte[] byArray4 = digestInfo.getDigest();
                return com.aspose.imaging.internal.ds.a.c(byArray, byArray4);
            }
            if (aY.e(string, "DSA")) {
                Signer signer = com.aspose.imaging.internal.dq.u.c("NONEwithDSA");
                signer.init(false, asymmetricKeyParameter);
                signer.update(byArray, 0, byArray.length);
                return signer.verifySignature(byArray2);
            }
            throw new j(aY.a(new String[]{"algorithm: ", string, " not supported in base signatures."}));
        }
        catch (s s2) {
            throw s2;
        }
        catch (com.aspose.imaging.internal.dq.j j2) {
            throw new j("Exception processing signature: " + j2, j2);
        }
        catch (IOException iOException) {
            throw new j("Exception decoding signature: " + iOException, iOException);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new j("Exception decoding signature: " + invalidCipherTextException, invalidCipherTextException);
        }
    }

    public boolean a(AsymmetricKeyParameter asymmetricKeyParameter) {
        if (asymmetricKeyParameter.isPrivate()) {
            throw new ArgumentException("Expected public key", "pubKey");
        }
        this.r();
        return this.b(asymmetricKeyParameter);
    }

    public boolean a(com.aspose.imaging.internal.dA.j j2) {
        Time time = this.r();
        if (time != null) {
            j2.b(com.aspose.imaging.internal.ap.S.a(time.getDate()));
        }
        return this.b(j2.y());
    }

    public SignerInfo q() {
        return this.c;
    }

    private ASN1Primitive a(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        AttributeTable attributeTable = this.m();
        if (attributeTable != null && attributeTable.getAll(aSN1ObjectIdentifier).size() > 0) {
            throw new j(aY.a(new String[]{"The ", string, " attribute MUST NOT be an unsigned attribute"}));
        }
        AttributeTable attributeTable2 = this.l();
        if (attributeTable2 == null) {
            return null;
        }
        ASN1EncodableVector aSN1EncodableVector = attributeTable2.getAll(aSN1ObjectIdentifier);
        switch (aSN1EncodableVector.size()) {
            case 0: {
                return null;
            }
            case 1: {
                com.aspose.imaging.internal.bouncycastle.asn1.cms.Attribute attribute = (com.aspose.imaging.internal.bouncycastle.asn1.cms.Attribute)aSN1EncodableVector.get(0);
                ASN1Set aSN1Set = attribute.getAttrValues();
                if (aSN1Set.size() != 1) {
                    throw new j(aY.a(new String[]{"A ", string, " attribute MUST have a single attribute value"}));
                }
                return aSN1Set.getObjectAt(0).toASN1Primitive();
            }
        }
        throw new j(aY.a(new String[]{"The SignedAttributes in a signerInfo MUST NOT include multiple instances of the ", string, " attribute"}));
    }

    private Time r() {
        ASN1Primitive aSN1Primitive = this.a(CMSAttributes.signingTime, "signing-time");
        if (aSN1Primitive == null) {
            return null;
        }
        try {
            return Time.getInstance(aSN1Primitive);
        }
        catch (ArgumentException argumentException) {
            throw new j("signing-time attribute value not a valid 'Time' structure");
        }
    }

    public static S a(S s2, AttributeTable attributeTable) {
        SignerInfo signerInfo = s2.c;
        DERSet dERSet = null;
        if (attributeTable != null) {
            dERSet = new DERSet(attributeTable.toASN1EncodableVector());
        }
        return new S(new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), dERSet), s2.j, s2.h, null);
    }

    public static S a(S s2, T t2) {
        SignerInfo signerInfo = s2.c;
        AttributeTable attributeTable = s2.m();
        ASN1EncodableVector aSN1EncodableVector = attributeTable != null ? attributeTable.toASN1EncodableVector() : new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        for (S s3 : t2.b()) {
            aSN1EncodableVector2.add(s3.q());
        }
        aSN1EncodableVector.add(new com.aspose.imaging.internal.bouncycastle.asn1.cms.Attribute(CMSAttributes.counterSignature, new DERSet(aSN1EncodableVector2)));
        return new S(new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), new DERSet(aSN1EncodableVector)), s2.j, s2.h, null);
    }
}

