/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.xmp;

import com.aspose.imaging.internal.Exceptions.ArgumentException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.FormatException;
import com.aspose.imaging.internal.ap.aV;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.ap.at;
import com.aspose.imaging.internal.aq.p;
import com.aspose.imaging.internal.be.A;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.system.collections.Generic.Dictionary;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerable;
import com.aspose.imaging.system.collections.Generic.IGenericEnumerator;
import com.aspose.imaging.system.collections.Generic.KeyValuePair;
import com.aspose.imaging.xmp.IXmlValue;
import com.aspose.imaging.xmp.XmpArray;
import com.aspose.imaging.xmp.types.IXmpType;
import com.aspose.imaging.xmp.types.XmpTypeBase;
import com.aspose.imaging.xmp.types.basic.XmpBoolean;
import com.aspose.imaging.xmp.types.basic.XmpDate;
import com.aspose.imaging.xmp.types.basic.XmpInteger;
import com.aspose.imaging.xmp.types.basic.XmpText;
import com.aspose.imaging.xmp.types.derived.XmpGuid;

public class XmpPackage
implements IGenericEnumerable<KeyValuePair<String, Object>>,
IXmlValue {
    protected final String prefix;
    protected final String namespaceUri;
    protected Dictionary<String, Object> properties;
    private final Dictionary<String, String> a;

    public XmpPackage(String prefix, String namespaceUri) {
        this.prefix = prefix;
        this.namespaceUri = namespaceUri;
        this.properties = new Dictionary(aV.f());
        this.a = new Dictionary(aV.f());
    }

    public String getXmlNamespace() {
        return aY.a("xmlns:{0}=\"{1}\"", new Object[]{this.prefix, this.namespaceUri});
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    protected String getKeyValueAsXml(String key) {
        Object object = null;
        Object[] objectArray = new Object[]{object};
        this.properties.tryGetValue(key, objectArray);
        object = objectArray[0];
        String string = aY.a;
        if (object != null) {
            string = d.b(object, IXmlValue.class) ? ((IXmlValue)object).getXmlValue() : (d.b(object, IXmpType.class) ? ((IXmpType)object).getXmpRepresentation() : object.toString());
        }
        return aY.a("<{0}>{1}</{0}>", new Object[]{key, string});
    }

    public Dictionary.KeyCollection<String, Object> getKeys() {
        return this.properties.getKeys();
    }

    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    public Object get_Item(String key) {
        Object object = null;
        Object[] objectArray = new Object[]{object};
        this.properties.tryGetValue(key, objectArray);
        object = objectArray[0];
        return this.a(object);
    }

    public void set_Item(String key, Object value) {
        this.properties.set_Item(key, value);
    }

    public void addValue(String key, String value) {
        if (aY.b(key)) {
            throw new ArgumentNullException("key");
        }
        this.set_Item(key, value);
    }

    public boolean remove(String key) {
        if (this.properties.containsKey(key)) {
            return this.properties.removeItemByKey(key);
        }
        return false;
    }

    public void clear() {
        this.properties.clear();
    }

    public void setValue(String key, IXmlValue value) {
        this.set_Item(key, value);
    }

    public void setXmpTypeValue(String key, XmpTypeBase value) {
        this.set_Item(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getXmlValue() {
        A a2 = new A();
        IGenericEnumerator iGenericEnumerator = this.getKeys().iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                String string = (String)iGenericEnumerator.next();
                a2.a('\n');
                String string2 = this.getKeyValueAsXml(string);
                a2.a(string2);
            }
        }
        finally {
            if (d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        return a2.toString();
    }

    @Override
    public IGenericEnumerator<KeyValuePair<String, Object>> iterator() {
        return this.properties.iterator();
    }

    protected void setXmpGuid(String key, String guid) {
        try {
            this.setXmpTypeValue(key, new XmpGuid(guid));
        }
        catch (ArgumentException argumentException) {
            this.setXmpTypeValue(key, new XmpText(guid));
        }
    }

    protected void setXmpDate(String key, String date) {
        try {
            this.setXmpTypeValue(key, new XmpDate(date));
        }
        catch (ArgumentException argumentException) {
            this.setXmpTypeValue(key, new XmpText(date));
        }
    }

    protected void setXmpInteger(String key, String intValue) {
        try {
            this.setXmpTypeValue(key, new XmpInteger(intValue));
        }
        catch (ArgumentException argumentException) {
            this.setXmpTypeValue(key, new XmpText(intValue));
        }
    }

    protected void setXmpBoolean(String key, String boolValue) {
        try {
            this.setXmpTypeValue(key, new XmpBoolean(boolValue));
        }
        catch (FormatException formatException) {
            this.setXmpTypeValue(key, new XmpText(boolValue));
        }
    }

    public void a(String string, String string2) {
        if (aY.b(string)) {
            throw new ArgumentNullException("typePrefix");
        }
        if (aY.b(string2)) {
            throw new ArgumentNullException("typeNamespaceUri");
        }
        this.a.set_Item(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getComplexTypesNamespaces() {
        if (this.a.size() == 0) {
            return aY.a;
        }
        A a2 = new A(" ");
        IGenericEnumerator iGenericEnumerator = this.a.iterator();
        try {
            while (iGenericEnumerator.hasNext()) {
                KeyValuePair keyValuePair = (KeyValuePair)iGenericEnumerator.next();
                a2.a("xmlns:{0}=\"{1}\"", keyValuePair.getKey(), keyValuePair.getValue());
            }
        }
        finally {
            if (d.b((Object)iGenericEnumerator, at.class)) {
                ((at)iGenericEnumerator).dispose();
            }
        }
        return a2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(XmpPackage xmpPackage) {
        if (xmpPackage == null) {
            throw new ArgumentNullException("other");
        }
        p p2 = xmpPackage.iterator();
        try {
            while (p2.hasNext()) {
                KeyValuePair keyValuePair = (KeyValuePair)p2.next();
                if (this.containsKey((String)keyValuePair.getKey())) continue;
                this.set_Item((String)keyValuePair.getKey(), keyValuePair.getValue());
            }
        }
        finally {
            if (d.b((Object)p2, at.class)) {
                ((at)((Object)p2)).dispose();
            }
        }
    }

    private Object a(Object object) {
        if (d.b(object, XmpTypeBase.class)) {
            if (d.b(object, XmpText.class)) {
                return ((XmpText)object).getValue();
            }
            if (d.b(object, XmpInteger.class)) {
                return d.a(((XmpInteger)object).getValue());
            }
            if (d.b(object, XmpDate.class)) {
                return d.a(((XmpDate)object).a());
            }
            if (d.b(object, XmpBoolean.class)) {
                return d.a(((XmpBoolean)object).getValue());
            }
            if (d.b(object, XmpGuid.class)) {
                return d.a(((XmpGuid)object).a());
            }
        }
        if (d.b(object, XmpArray.class)) {
            return ((XmpArray)object).getValues();
        }
        return object;
    }
}

