/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.imaging.xmp.schemas.photoshop;

import com.aspose.imaging.coreexceptions.XmpException;
import com.aspose.imaging.internal.Exceptions.ArgumentNullException;
import com.aspose.imaging.internal.Exceptions.ArgumentOutOfRangeException;
import com.aspose.imaging.internal.Exceptions.NotImplementedException;
import com.aspose.imaging.internal.ap.S;
import com.aspose.imaging.internal.ap.aY;
import com.aspose.imaging.internal.dO.d;
import com.aspose.imaging.internal.dO.h;
import com.aspose.imaging.internal.hj.b;
import com.aspose.imaging.xmp.XmpArray;
import com.aspose.imaging.xmp.XmpPackage;
import com.aspose.imaging.xmp.schemas.photoshop.Layer;
import com.aspose.imaging.xmp.types.basic.XmpDate;
import com.aspose.imaging.xmp.types.basic.XmpInteger;
import com.aspose.imaging.xmp.types.basic.XmpText;
import java.util.Date;

public final class PhotoshopPackage
extends XmpPackage {
    public static final int URGENCY_MAX = 8;
    public static final int URGENCY_MIN = 1;
    private static final h a = new h("photoshop:urgency", "photoshop:colorMode");

    public PhotoshopPackage() {
        super("photoshop", "http://ns.adobe.com/photoshop/1.0/");
    }

    @Override
    public void addValue(String key, String value) {
        if (aY.b(key)) {
            throw new ArgumentNullException("key", "Photoshop property could not be null");
        }
        switch (a.a(aY.g(key))) {
            case 0: {
                this.setXmpInteger(key, value);
                return;
            }
            case 1: {
                throw new XmpException("Color mode should be recognized before");
            }
        }
        super.addValue(key, value);
    }

    public void setAuthorsPosition(String authorsPosition) {
        this.setXmpTypeValue(b.a, new XmpText(authorsPosition));
    }

    public void setCaptionWriter(String captionWriter) {
        this.setXmpTypeValue(b.b, new XmpText(captionWriter));
    }

    public void setCategory(String category) {
        if (!aY.b(category) && category.length() > 3) {
            throw new ArgumentOutOfRangeException("category", "Category is limited to 3 characters");
        }
        this.setXmpTypeValue(b.c, new XmpText(category));
    }

    public void setCity(String city) {
        this.setXmpTypeValue(b.d, new XmpText(city));
    }

    public void setColorMode(byte colorMode) {
        byte by2 = colorMode;
        this.setXmpTypeValue(b.e, new XmpInteger(by2));
    }

    public void setCountry(String country) {
        this.setXmpTypeValue(b.f, new XmpText(country));
    }

    public void setCredit(String credit) {
        this.setXmpTypeValue(b.g, new XmpText(credit));
    }

    public void setCreatedDate(Date createdDate) {
        this.a(S.a(createdDate));
    }

    public void a(S s2) {
        this.setXmpTypeValue(b.h, new XmpDate(s2.H()));
    }

    public void setDocumentAncestors(String[] ancestors) {
        XmpArray xmpArray = new XmpArray(0, ancestors);
        this.setValue(b.i, xmpArray);
    }

    public void setHeadline(String headline) {
        this.setXmpTypeValue(b.j, new XmpText(headline));
    }

    public void setHistory(String history) {
        this.setXmpTypeValue(b.k, new XmpText(history));
    }

    public void setIccProfile(String iccProfile) {
        this.setXmpTypeValue(b.l, new XmpText(iccProfile));
    }

    public void setInstructions(String instructions) {
        this.setXmpTypeValue(b.m, new XmpText(instructions));
    }

    public void setSource(String source) {
        this.setXmpTypeValue(b.n, new XmpText(source));
    }

    public void setState(String state) {
        this.setXmpTypeValue(b.o, new XmpText(state));
    }

    public void setSupplementalCategories(String[] supplementalCategories) {
        XmpArray xmpArray = new XmpArray(0, supplementalCategories);
        this.setValue(b.p, xmpArray);
    }

    void setLayers(Layer[] layers) {
        throw new NotImplementedException();
    }

    public void setTransmissionReference(String transmissionReference) {
        this.setXmpTypeValue(b.r, new XmpText(transmissionReference));
    }

    public void setUrgency(int urgency) {
        if (urgency < 1 || urgency > 8) {
            throw new ArgumentOutOfRangeException("urgency", aY.a("Valid range is from {0} to {1}", d.a(1), d.a(8)));
        }
        this.setXmpTypeValue(b.s, new XmpInteger(urgency));
    }
}

