/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtEnvironment;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;
import com.aspose.ocr.Config;
import com.aspose.ocr.HoughTransform;
import com.aspose.ocr.ImageUtils;
import com.aspose.ocr.License;
import com.aspose.ocr.Resources;
import com.aspose.ocr.TensorHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.imageio.ImageIO;

public class AsposeOCR {
    private static final double LONG_STRING_TRESH = 5.0;
    private static final double RATIO_NUMERATOR = 800.0;
    private static final float DEFAULT_CONFIDENCE = 0.6f;
    private static final int THRESHOLD = 5;
    private static final int THRESHOLD_LINE_HEIGHT = 10;
    private BufferedImage image;
    private BufferedImage invertBinImage;
    private String allowed;
    private ArrayList<Rectangle> boxes;

    public AsposeOCR() {
    }

    public AsposeOCR(String alphabet) {
        this.allowed = alphabet;
    }

    public double CalcSkewImage(String fullPath) throws IOException {
        BufferedImage loaded = ImageIO.read(new File(fullPath));
        return this.CalcSkewImage(loaded);
    }

    public double CalcSkewImage(BufferedImage image) throws IOException {
        this.TransformImage(image);
        return this.CalcSkewImage();
    }

    public ArrayList<Rectangle> getTextAreas() {
        if (this.boxes == null) {
            throw new RuntimeException("Before run RecognizePage method.");
        }
        return this.boxes;
    }

    public String RecognizePage(String fullPath) throws IOException {
        return this.RecognizePage(fullPath, true);
    }

    public String RecognizePage(String fullPath, boolean autoSkew) throws IOException {
        BufferedImage loaded = ImageIO.read(new File(fullPath));
        return this.RecognizePage(loaded, autoSkew);
    }

    public String RecognizePage(BufferedImage image) throws IOException {
        return this.RecognizePage(image, true);
    }

    public String RecognizePage(BufferedImage image, boolean autoSkew) throws IOException {
        this.TransformImage(image);
        return this.RecognizePage(autoSkew);
    }

    public String RecognizePage(String fullPath, ArrayList<Rectangle> boxes_) throws IOException {
        BufferedImage loaded = ImageIO.read(new File(fullPath));
        return this.RecognizePage(loaded, boxes_);
    }

    public String RecognizePage(BufferedImage image_, ArrayList<Rectangle> boxes_) throws IOException {
        this.TransformImage(image_);
        int h = image_.getHeight();
        int w = image_.getWidth();
        Rectangle rect = new Rectangle(0, 0, w, h);
        for (Rectangle r : boxes_) {
            if (rect.contains(r)) continue;
            throw new IllegalArgumentException("Image does not contain a rectangle.");
        }
        this.boxes = boxes_;
        return this.RecognizeBoxes();
    }

    public String RecognizePage(String fullPath, Rectangle box) throws IOException {
        BufferedImage loaded = ImageIO.read(new File(fullPath));
        return this.RecognizePage(loaded, box);
    }

    public String RecognizePage(BufferedImage image_, Rectangle box) throws IOException {
        ArrayList<Rectangle> input_boxes = new ArrayList<Rectangle>();
        input_boxes.add(box);
        return this.RecognizePage(image_, input_boxes);
    }

    public String RecognizeLine(String fullPath) throws IOException {
        BufferedImage loaded = ImageIO.read(new File(fullPath));
        return this.RecognizeLine(loaded);
    }

    public String RecognizeLine(BufferedImage image_) throws IOException {
        this.TransformImage(image_);
        BufferedImage line = ImageUtils.trimImage(this.image);
        ArrayList<BufferedImage> allLines = new ArrayList<BufferedImage>();
        allLines.add(line);
        return this.RecognizeLines(allLines);
    }

    private String RecognizePage(boolean autoSkew) throws IOException {
        double angle;
        if (autoSkew && Math.abs(angle = this.CalcSkewImage()) > 0.05) {
            ImageUtils.invertRGBImage(this.image);
            this.image = ImageUtils.rotateImage(this.image, -angle);
            ImageUtils.invertRGBImage(this.image);
        }
        this.boxes = this.getTextBoxes();
        return this.RecognizeBoxes();
    }

    private String RecognizeBoxes() throws IOException {
        if (this.boxes.size() == 0) {
            this.boxes.add(new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight()));
        }
        this.boxes.sort((r1, r2) -> r1.y == r2.y ? r1.x - r2.x : r1.y - r2.y);
        ArrayList<BufferedImage> allLines = new ArrayList<BufferedImage>();
        boolean count = false;
        for (Rectangle rect : this.boxes) {
            BufferedImage box = ImageUtils.clone(this.image.getSubimage(rect.x, rect.y, rect.width, rect.height));
            ArrayList<Rectangle> rectLines = this.splitToLine(box);
            BufferedImage oneBox = ImageUtils.clone(box);
            for (Rectangle r : rectLines) {
                BufferedImage oneLine = ImageUtils.clone(oneBox.getSubimage(r.x, r.y, r.width, r.height));
                allLines.add(oneLine);
            }
        }
        return this.RecognizeLines(allLines);
    }

    private void TransformImage(BufferedImage img) {
        try {
            this.image = ImageUtils.makeCompatible(img);
        }
        catch (Exception e) {
            throw new RuntimeException("File not found");
        }
        if (this.image == null) {
            throw new IllegalArgumentException("Invalid image type.");
        }
    }

    private double CalcSkewImage() throws IOException {
        this.invertBinImage = ImageUtils.thresholdImage(this.image, true);
        Rectangle rect = ImageUtils.getBoundaryBox(this.invertBinImage);
        if ((double)(rect.width / rect.height) > 5.0) {
            return 0.0;
        }
        int minSide = Math.min(rect.width, rect.height);
        BufferedImage bounded = ImageUtils.clone(this.invertBinImage.getSubimage(rect.x, rect.y, minSide, minSide));
        BufferedImage scaleImg = ImageUtils.scaleImage(bounded, 800.0 / (double)bounded.getWidth());
        HoughTransform hough = new HoughTransform(scaleImg.getWidth());
        BufferedImage dilate = ImageUtils.dilation(scaleImg);
        BufferedImage linearize = ImageUtils.linearization(dilate);
        BufferedImage houghImage = hough.Transform(linearize);
        return hough.GetAngleInDegrees(hough.getMaxPoint());
    }

    private String RecognizeLines(ArrayList<BufferedImage> allLines) {
        int i;
        StringBuilder result = new StringBuilder();
        int size = 38400;
        ArrayList<float[]> batch = new ArrayList<float[]>();
        float[] batchLine = new float[8 * size];
        Arrays.fill(batchLine, 1.0f);
        int lineCount = allLines.size();
        for (i = 0; i < lineCount; ++i) {
            float[] chunk = TensorHelper.imageToOcrTensor(allLines.get(i));
            System.arraycopy(chunk, 0, batchLine, i % 8 * size, size);
            if ((i + 1) % 8 == 0) {
                batch.add(batchLine);
                batchLine = new float[8 * size];
                Arrays.fill(batchLine, 1.0f);
            }
            if (i + 1 != lineCount || lineCount % 8 == 0) continue;
            batch.add(batchLine);
        }
        block46: for (i = 0; i < batch.size(); ++i) {
            try (OrtEnvironment env = OrtEnvironment.getEnvironment();
                 OrtSession.SessionOptions opts = new OrtSession.SessionOptions();){
                opts.setOptimizationLevel(OrtSession.SessionOptions.OptLevel.BASIC_OPT);
                byte[] ocr = Resources.ocrModel;
                try {
                    OrtSession session = env.createSession(ocr, opts);
                    FloatBuffer data = FloatBuffer.wrap((float[])batch.get(i), 0, ((float[])batch.get(i)).length);
                    String inputName = (String)session.getInputNames().iterator().next();
                    long[] shape = new long[]{8L, 1L, 32L, 1200L};
                    try (OnnxTensor test = OnnxTensor.createTensor((OrtEnvironment)env, (FloatBuffer)data, (long[])shape);
                         OrtSession.Result output = session.run(Collections.singletonMap(inputName, test));){
                        float[][][] res = (float[][][])output.get(0).getValue();
                        for (int b = 0; b < 8; ++b) {
                            ArrayList<Integer> index = new ArrayList<Integer>();
                            for (int linePos = 0; linePos < 126; ++linePos) {
                                int char_idx = 0;
                                float max_prob = res[linePos][b][0];
                                for (int alpha = 0; alpha < Config.ALPHABET.length; ++alpha) {
                                    if (this.allowed != null && this.allowed.indexOf(Config.ALPHABET[alpha]) == -1 || !(res[linePos][b][alpha] > max_prob)) continue;
                                    char_idx = alpha;
                                    max_prob = res[linePos][b][alpha];
                                }
                                index.add(char_idx);
                            }
                            for (int idx = 0; idx < index.size(); ++idx) {
                                if ((Integer)index.get(idx) == 0 || idx != 0 && index.get(idx) == index.get(idx - 1)) continue;
                                result.append(Config.ALPHABET[(Integer)index.get(idx)]);
                            }
                            result.append('\n');
                            if (--lineCount != 0) continue;
                            continue block46;
                        }
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getMessage());
                    }
                    finally {
                        session.close();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            catch (OrtException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (!License.isValid()) {
            if (result.length() > 300) {
                result.setLength(300);
            }
            result.append("\n ************* Trial Licenses ************* \n");
        }
        return result.toString();
    }

    /*
     * Exception decompiling
     */
    private ArrayList<Rectangle> getTextBoxes() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [34[CATCHBLOCK], 3[TRYBLOCK], 2[TRYBLOCK], 37[CATCHBLOCK]], but top level block is 16[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ArrayList<Rectangle> splitToLine(BufferedImage img) {
        ArrayList<Rectangle> result = new ArrayList<Rectangle>();
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage binaryImage = ImageUtils.thresholdImage(img, true);
        byte[] pixels = ((DataBufferByte)binaryImage.getRaster().getDataBuffer()).getData();
        int[] hyst = new int[h];
        for (int r = 0; r < h; ++r) {
            for (int c = 0; c < w; ++c) {
                int n = r;
                hyst[n] = hyst[n] + (pixels[r * w + c] & 0xFF);
            }
        }
        for (int i = 0; i < hyst.length; ++i) {
            hyst[i] = hyst[i] < 1275 ? 0 : hyst[i];
        }
        int beginString = 0;
        for (int i = 1; i < hyst.length; ++i) {
            if (hyst[i - 1] == 0 && hyst[i] != 0) {
                beginString = i;
                continue;
            }
            if ((hyst[i - 1] == 0 || hyst[i] != 0) && (i + 1 != hyst.length || hyst[i] == 0) || i - beginString <= 10) continue;
            Point right = new Point(w - 1, i);
            block4: for (int c = w - 1; c >= 0; --c) {
                for (int r = i - 1; r >= beginString; --r) {
                    if ((pixels[r * w + c] & 0xFF) == 0) continue;
                    right = new Point(c, r);
                    break block4;
                }
            }
            Point left = new Point(0, i);
            block6: for (int c = 0; c < w; ++c) {
                for (int r = beginString; r < i; ++r) {
                    if ((pixels[r * w + c] & 0xFF) == 0) continue;
                    left = new Point(c, r);
                    break block6;
                }
            }
            result.add(new Rectangle(left.x, beginString, right.x - left.x, i - beginString));
        }
        return result;
    }
}

