/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.ArrayList;

class HoughTransform {
    private int size;
    private int even_size;
    private int[][] xcos_theta;
    private int[][] ysin_theta;
    private static final double sqrt_2 = Math.sqrt(2.0);
    private Point max_point;

    Point getMaxPoint() {
        return this.max_point;
    }

    public HoughTransform(int size_) {
        int t;
        if (size_ <= 0) {
            throw new IllegalArgumentException("Invalid arguments given to this function.");
        }
        this.size = size_;
        this.even_size = this.size - this.size % 2;
        Point cent = new Point(this.size / 2, this.size / 2);
        this.xcos_theta = new int[this.size][this.size];
        this.ysin_theta = new int[this.size][this.size];
        ArrayList<Double> cos_theta = new ArrayList<Double>();
        ArrayList<Double> sin_theta = new ArrayList<Double>();
        double scale = 65536.0;
        for (int t2 = 0; t2 < this.size; ++t2) {
            double theta = (double)t2 * Math.PI / (double)this.even_size;
            cos_theta.add(scale * Math.cos(theta) / sqrt_2);
            sin_theta.add(scale * Math.sin(theta) / sqrt_2);
        }
        double offset = scale * (double)this.even_size / 4.0;
        for (int c = 0; c < this.size; ++c) {
            int x = c - (int)cent.getX();
            for (t = 0; t < this.size; ++t) {
                this.xcos_theta[c][t] = (int)((double)x * (Double)cos_theta.get(t) + offset);
            }
        }
        for (int r = 0; r < this.size; ++r) {
            int y = r - (int)cent.getY();
            for (t = 0; t < this.size; ++t) {
                this.ysin_theta[r][t] = (int)((double)y * (Double)sin_theta.get(t) + offset);
            }
        }
    }

    BufferedImage Transform(BufferedImage image) {
        if (image.getWidth() != this.size || image.getHeight() != this.size) {
            throw new IllegalArgumentException("Invalid size for HoughTransform.");
        }
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int[][] result_matrix = new int[this.size][this.size];
        Rectangle rect = new Rectangle(0, 0, this.size, this.size);
        int max_element = 0;
        for (int r = 0; r < this.size; ++r) {
            for (int c = 0; c < this.size; ++c) {
                byte val = pixels[r * this.size + c];
                if (val == 0) continue;
                Point cent = new Point(rect.width / 2, rect.height / 2);
                int x = c - (int)cent.getX();
                int y = r - (int)cent.getY();
                for (int t = 0; t < this.size; ++t) {
                    double theta = (double)t * Math.PI / (double)this.even_size;
                    double radius = ((double)x * Math.cos(theta) + (double)y * Math.sin(theta)) / sqrt_2 + (double)(this.even_size / 2);
                    int rr = (int)radius;
                    Point pp = new Point(t, rr);
                    int xx = (int)pp.getX();
                    int yy = (int)pp.getY();
                    int[] nArray = result_matrix[xx];
                    int n = yy;
                    nArray[n] = nArray[n] + (val & 0xFF);
                    if (result_matrix[xx][yy] <= max_element) continue;
                    this.max_point = pp;
                    max_element = result_matrix[xx][yy];
                }
            }
        }
        if (max_element == 0) {
            throw new IllegalArgumentException("Empty data for hough transform.");
        }
        BufferedImage out_img = new BufferedImage(this.size, this.size, 10);
        byte[] out_pixels = ((DataBufferByte)out_img.getRaster().getDataBuffer()).getData();
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                int index = y * this.size + x;
                out_pixels[index] = (byte)(result_matrix[x][y] * 255 / max_element);
            }
        }
        return out_img;
    }

    double GetAngleInDegrees(Point p) {
        Point cent = new Point(this.size / 2, this.size / 2);
        double theta = p.getX() - cent.getX();
        return 180.0 * theta / (double)this.even_size;
    }
}

