/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;

class ImageUtils {
    static final int on_pixel = 255;
    static final int off_pixel = 0;
    static final int M = 5;
    static final int N = 7;
    static final int[][] struct_dilation = new int[][]{{255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 255}, {255, 255, 255, 255, 255, 255, 0}};
    static final int Me = 5;
    static final int Ne = 3;
    static final int[][] struct_erosion = new int[][]{{255, 255, 255}, {255, 0, 0}, {255, 0, 0}, {255, 0, 0}, {255, 0, 0}};

    ImageUtils() {
    }

    static BufferedImage makeCompatible(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage result = new BufferedImage(w, h, 1);
        Graphics2D g = result.createGraphics();
        g.drawRenderedImage(image, new AffineTransform());
        g.dispose();
        return result;
    }

    static BufferedImage clone(BufferedImage image) {
        BufferedImage clone = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics2D g2d = clone.createGraphics();
        g2d.drawImage((Image)image, 0, 0, null);
        g2d.dispose();
        return clone;
    }

    static BufferedImage thresholdImage(BufferedImage image, boolean invert) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int pixelCount = width * height;
        BufferedImage out_img = new BufferedImage(width, height, 10);
        byte[] out_pixels = ((DataBufferByte)out_img.getRaster().getDataBuffer()).getData();
        int[] intHistogram = new int[256];
        double[] histogram = new double[256];
        int threshold = 0;
        for (int i = 0; i < pixels.length; ++i) {
            int result;
            int red = pixels[i] >> 16 & 0xFF;
            int green = pixels[i] >> 8 & 0xFF;
            int blue = pixels[i] & 0xFF;
            int n = result = (int)(0.2126 * (double)red + 0.7152 * (double)green + 0.0722 * (double)blue);
            intHistogram[n] = intHistogram[n] + 1;
            out_pixels[i] = (byte)result;
        }
        double imageMean = 0.0;
        for (int i = 0; i < 256; ++i) {
            histogram[i] = (double)intHistogram[i] / (double)pixelCount;
            imageMean += histogram[i] * (double)i;
        }
        double max = Double.MIN_VALUE;
        double c1Prob = 0.0;
        double c2Prob = 1.0;
        double c1MeanInit = 0.0;
        for (int i = 0; i < 256 && c2Prob > 0.0; ++i) {
            double c1Mean = c1MeanInit;
            double c2Mean = (imageMean - c1Mean * c1Prob) / c2Prob;
            double classVariance = c1Prob * (1.0 - c1Prob) * Math.pow(c1Mean - c2Mean, 2.0);
            if (classVariance > max) {
                max = classVariance;
                threshold = i;
            }
            c1MeanInit *= c1Prob;
            c1Prob += histogram[i];
            c2Prob -= histogram[i];
            c1MeanInit += (double)i * histogram[i];
            if (!(Math.abs(c1Prob) > 0.0)) continue;
            c1MeanInit /= c1Prob;
        }
        boolean black_pixel = false;
        int white_pixel = -1;
        for (int i = 0; i < pixelCount; ++i) {
            out_pixels[i] = (out_pixels[i] & 0xFF) <= threshold ? (invert ? -1 : 0) : (invert ? 0 : -1);
        }
        return out_img;
    }

    static BufferedImage dilation(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        BufferedImage out_img = new BufferedImage(width, height, 10);
        byte[] out_pixels = ((DataBufferByte)out_img.getRaster().getDataBuffer()).getData();
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int index = row * width + col;
                int out_pixel = 0;
                for (int m = 0; m < 5 && out_pixel == 0; ++m) {
                    for (int n = 0; n < 7 && out_pixel == 0; ++n) {
                        if (struct_dilation[m][n] != 255 || row + m < 2 || col + n < 3 || row + m - 2 >= height || col + n - 3 >= width) continue;
                        int col1 = index - row * width + n - 3;
                        int row1 = (index - col) / width + m - 2;
                        int index1 = row1 * width + col1;
                        out_pixel = pixels[index1] & 0xFF;
                    }
                }
                out_pixels[row * width + col] = (byte)out_pixel;
            }
        }
        return out_img;
    }

    static BufferedImage erosion(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        BufferedImage out_img = new BufferedImage(width, height, 10);
        byte[] out_pixels = ((DataBufferByte)out_img.getRaster().getDataBuffer()).getData();
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int index = row * width + col;
                int out_pixel = 255;
                for (int m = 0; m < 5 && out_pixel == 255; ++m) {
                    for (int n = 0; n < 3 && out_pixel == 255; ++n) {
                        if (struct_erosion[m][n] != 255) continue;
                        if (row + m >= 2 && col + n >= 1 && row + m - 2 < height && col + n - 1 < width) {
                            int col1 = index - row * width + n - 1;
                            int row1 = (index - col) / width + m - 2;
                            int index1 = row1 * width + col1;
                            out_pixel = pixels[index1] & 0xFF;
                            continue;
                        }
                        out_pixel = 0;
                    }
                }
                out_pixels[row * width + col] = (byte)out_pixel;
            }
        }
        return out_img;
    }

    static BufferedImage linearization(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        BufferedImage out_img = new BufferedImage(width, height, 10);
        byte[] out_pixels = ((DataBufferByte)out_img.getRaster().getDataBuffer()).getData();
        int start = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int index = y * width + x;
                int col = index - y * width;
                int row = ((index - x) / width + start + 1) / 2;
                int index1 = row * width + col;
                if (y == height - 1 && start != 0) {
                    out_pixels[index1] = -1;
                    continue;
                }
                if (pixels[index] == 0 && start == 0 || pixels[index] != 0 && start != 0) continue;
                if (pixels[index] != 0 && start == 0) {
                    start = y;
                }
                if (pixels[index] != 0 || start == 0) continue;
                out_pixels[index1] = -1;
                start = 0;
            }
        }
        return out_img;
    }

    static BufferedImage trimImage(BufferedImage image) {
        BufferedImage binary = ImageUtils.thresholdImage(image, true);
        Rectangle rect = ImageUtils.getBoundary(binary);
        return ImageUtils.clone(image.getSubimage(rect.x, rect.y, rect.width, rect.height));
    }

    static Rectangle getBoundaryBox(BufferedImage image) {
        BufferedImage erode = ImageUtils.erosion(image);
        return ImageUtils.getBoundary(erode);
    }

    private static Rectangle getBoundary(BufferedImage image) {
        int r;
        int c;
        int c2;
        int r2;
        int col = image.getWidth();
        int row = image.getHeight();
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        Point right = null;
        Point left = null;
        Point down = null;
        Point up = null;
        block0: for (r2 = 0; r2 < row; ++r2) {
            for (c2 = 0; c2 < col; ++c2) {
                if ((pixels[r2 * col + c2] & 0xFF) != 255) continue;
                up = new Point(c2, r2);
                break block0;
            }
        }
        block2: for (r2 = row - 1; r2 >= 0; --r2) {
            for (c2 = 0; c2 < col; ++c2) {
                if ((pixels[r2 * col + c2] & 0xFF) != 255) continue;
                down = new Point(c2, r2);
                break block2;
            }
        }
        block4: for (c = 0; c < col; ++c) {
            for (r = 0; r < row; ++r) {
                if ((pixels[r * col + c] & 0xFF) != 255) continue;
                left = new Point(c, r);
                break block4;
            }
        }
        block6: for (c = col - 1; c >= 0; --c) {
            for (r = row - 1; r >= 0; --r) {
                if ((pixels[r * col + c] & 0xFF) != 255) continue;
                right = new Point(c, r);
                break block6;
            }
        }
        if (up == null || down == null || left == null || right == null || up == down || left == right) {
            throw new IllegalArgumentException("Empty data");
        }
        return new Rectangle((int)left.getX(), (int)up.getY(), (int)(right.getX() - left.getX()), (int)(down.getY() - up.getY()));
    }

    static BufferedImage resizeRGBImage(BufferedImage before, int w, int h) {
        int y;
        BufferedImage img = new BufferedImage(w, h, before.getType());
        int ww = before.getWidth();
        int hh = before.getHeight();
        int[] ys = new int[h];
        for (y = 0; y < h; ++y) {
            ys[y] = y * hh / h;
        }
        for (int x = 0; x < w; ++x) {
            int newX = x * ww / w;
            for (y = 0; y < h; ++y) {
                int col = before.getRGB(newX, ys[y]);
                img.setRGB(x, y, col);
            }
        }
        return img;
    }

    static BufferedImage scaleImage(BufferedImage before, double scale) {
        int w = before.getWidth();
        int h = before.getHeight();
        int w2 = (int)((double)w * scale);
        int h2 = (int)((double)h * scale);
        int type = scale < 1.0 ? 3 : 1;
        BufferedImage after = new BufferedImage(w2, h2, before.getType());
        AffineTransform scaleInstance = AffineTransform.getScaleInstance(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(scaleInstance, type);
        scaleOp.filter(before, after);
        return after;
    }

    static BufferedImage scalePaddingImage(BufferedImage img, int w, int h) {
        BufferedImage result = new BufferedImage(w, h, img.getType());
        Graphics g = result.getGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.drawImage(img, 0, 0, null);
        g.dispose();
        return result;
    }

    static void invertBinaryImage(BufferedImage img) {
        byte[] pixels = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = (byte)(pixels[i] == 0 ? -1 : 0);
        }
    }

    static void invertRGBImage(BufferedImage img) {
        int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
        int i = 0;
        while (i < pixels.length) {
            int n = i++;
            pixels[n] = ~pixels[n];
        }
    }

    static void drawRect(BufferedImage img, Rectangle rect, Color col) {
        Graphics2D graph = img.createGraphics();
        graph.setColor(col);
        graph.draw(rect);
        graph.dispose();
    }

    static BufferedImage rotateImage(BufferedImage img, double rotation) {
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, img.getType());
        Graphics2D g2 = newImage.createGraphics();
        g2.rotate(Math.toRadians(rotation), w / 2, h / 2);
        g2.drawImage(img, null, 0, 0);
        return newImage;
    }
}

