/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import com.aspose.ocr.Resources;
import com.aspose.ocr.XmlHelper;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.RSAPublicKeySpec;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;

public class License {
    private static boolean isValid;
    private static final String KeyModulusStringRsa1024Aspose = "0nRuwNEddXwLfXB7pw66G71MS93gW8mNzJ7vuh3Sf4VAEOBfpxtHLCotymv1PoeukxYe31K441Ivq0Pkvx1yZZG4O1KCv3Omdbs7uqzUB4xXHlOub4VsTODzDJ5MWHqlRCB1HHcGjlyT2sVGiovLt0Grvqw5+QXBuinoBY0suX0=";
    private static final String KeyModulusStringRsa1024Conholdate = "qKFqqhFovZvEYCHeD3N8Oy+AuxrOA8cVvIl4u4qIBMQlzejGyXkiTUjoryuzlhlS2bG80FGmFsH+wUKbYiEkW/4zseZCV/Ej/usbu6yHACQKO/SCy3pYw68Pcv901pvywUnoaYCI2ccCG29+XM+FwpFQuiPb2H7YbI/++SQs6Hk=";
    private static final String KeyModulusStringRsa2048Aspose = "3ki45T6C4lt12J5MbKfrADBCZcE8OTefdngc9IDKg+lzCGYLuxJFDt16awhJFnA23sX+kQ4/eZQ5pNAYjc+ZJ0+pWwvQR4h8GJ3eWvecdFs7KSWwNmFXZCSN+sbrxwEjzzns1kIHuLNf5r+Zaggns+8rqXR19RSJBOcuFqVipIHv56lF53Hc+hx+y9URIaadO1W8dkTqgwExyfjnbDOaCBEH0CqUL1YIICS/wIUTEKhM0ZlwEcIcHl8XTHLVx96DMX4bbVajj78L4KzevQc442DX28KGDJTveEB1pSKWsr0d4FTx7wKS36RBnWv5lwsRErtTZb5ciVIG1iIJrp87VQ==";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLicense(String filename) {
        Class<License> clazz = License.class;
        synchronized (License.class) {
            LocalDateTime now;
            isValid = false;
            if (filename.isEmpty()) {
                throw new IllegalArgumentException("Path to license is empty.");
            }
            String lic_file = "";
            try {
                File f = new File(filename);
                byte[] bytes = Files.readAllBytes(f.toPath());
                lic_file = new String(bytes, "UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String data = XmlHelper.getFirstValueByTag(lic_file, "Data", true);
            String signature = XmlHelper.getFirstValueByTag(lic_file, "Signature");
            byte[] signatureBytes = Base64.getDecoder().decode(signature);
            ArrayList<String> products = XmlHelper.getValuesByTag(lic_file, "Product");
            boolean conholdate = false;
            String public_key = "";
            for (String p : products) {
                if (p.toUpperCase().indexOf("CONHOLDATE") == -1) continue;
                conholdate = true;
                break;
            }
            public_key = conholdate ? KeyModulusStringRsa1024Conholdate : (signatureBytes.length == 128 ? KeyModulusStringRsa1024Aspose : KeyModulusStringRsa2048Aspose);
            byte[] PK = Base64.getDecoder().decode(public_key);
            boolean result = License.VerifySignature(data, signatureBytes, PK);
            String editionType = XmlHelper.getFirstValueByTag(lic_file, "EditionType");
            if (!editionType.equalsIgnoreCase("Enterprise") && !editionType.equalsIgnoreCase("Professional")) {
                throw new IllegalArgumentException("Invalid edition type.");
            }
            boolean prod_family = false;
            for (String p : products) {
                if (!p.equals("Aspose.Total") && !p.equals("Aspose.Total for Java") && !p.equals("Aspose.Total Product Family") && !p.equals("Aspose.OCR for Java") && !p.equals("Aspose.OCR Product Family") && !p.equals("Conholdate.Total") && !p.equals("Conholdate.Total for Java") && !p.equals("Conholdate.Total Product Family")) continue;
                prod_family = true;
                break;
            }
            if (!prod_family) {
                throw new IllegalArgumentException("The license is not valid for this product.");
            }
            String serialNumber = XmlHelper.getFirstValueByTag(lic_file, "SerialNumber");
            String bl = new String(Resources.blackList);
            ArrayList<String> sn_blacklist = XmlHelper.getValuesByTag(bl, "SN");
            if (sn_blacklist.contains(serialNumber)) {
                throw new IllegalArgumentException("The license in blacklist.");
            }
            String tmp = XmlHelper.getFirstValueByTag(lic_file, "SubscriptionExpiry");
            String tmp1 = XmlHelper.getFirstValueByTag(lic_file, "LicenseExpiry");
            if ((tmp + tmp1).isEmpty()) {
                throw new IllegalArgumentException("Expiry termination license invalid.");
            }
            String expiry = tmp1.compareToIgnoreCase(tmp) == 1 ? tmp1 : tmp;
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
            String timeNow = dtf.format(now = LocalDateTime.now());
            if (timeNow.compareTo(expiry) == 1) {
                throw new IllegalArgumentException("The license has expired.");
            }
            if (result) {
                isValid = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isValid() {
        return isValid;
    }

    private static boolean VerifySignature(String data, byte[] signature, byte[] publicKey) {
        byte[] exp_arr = Base64.getDecoder().decode("AQAB");
        BigInteger mod = new BigInteger(License.byteArrayToHexString(publicKey), 16);
        BigInteger exp = new BigInteger(License.byteArrayToHexString(exp_arr), 16);
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(mod, exp);
        try {
            byte[] data_arr;
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey PK = kf.generatePublic(keySpec);
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initVerify(PK);
            ByteBuffer bb = ByteBuffer.allocate(data.length() * 2);
            for (byte b : data_arr = data.getBytes()) {
                bb.put(b);
                bb.put((byte)0);
            }
            byte[] result_data = bb.array();
            sig.update(result_data);
            return sig.verify(signature);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to check license.");
        }
    }

    private static String byteArrayToHexString(byte[] byteArray) {
        String hexString = "";
        for (int i = 0; i < byteArray.length; ++i) {
            String thisByte = String.format("%02x", byteArray[i]);
            hexString = hexString + thisByte;
        }
        return hexString;
    }
}

