/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

final class Resources {
    public static final byte[] ocrModel = Resources.getResource("ocr_model.onnx");
    public static final byte[] dsrModel = Resources.getResource("detection_model.onnx");
    public static final byte[] blackList = Resources.getResource("Aspose.License.BlackList.xml");

    Resources() {
    }

    static byte[] getResource(String resource) {
        try {
            int nRead;
            InputStream inputStream = Resources.class.getClassLoader().getResourceAsStream(resource);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable load resource");
        }
    }
}

