/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import com.aspose.ocr.ImageUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;

class TensorHelper {
    static int count = 0;

    TensorHelper() {
    }

    static float[] imageToDsrTensor(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        int size = h * w;
        float[] result = new float[size * 3];
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int index = i * w + j;
                result[index + 2 * size] = (float)((pixels[index] & 0xFF0000) >> 16) - 122.7717f;
                result[index + size] = (float)((pixels[index] & 0xFF00) >> 8) - 115.9465f;
                result[index] = (float)(pixels[index] & 0xFF) - 102.9801f;
            }
        }
        return result;
    }

    static float[] imageToOcrTensor(BufferedImage line) {
        double ratio_out;
        int h;
        int w = line.getWidth();
        double ratio_in = (double)w / (double)(h = line.getHeight());
        if (ratio_in > (ratio_out = 37.5)) {
            line = ImageUtils.resizeRGBImage(line, 1200, 32);
        } else {
            if (h != 32) {
                double ratio = 32.0 / (double)h;
                int height = 32;
                int width = (int)(ratio * (double)w);
                line = ImageUtils.resizeRGBImage(line, width, height);
            }
            line = ImageUtils.scalePaddingImage(line, 1200, 32);
        }
        BufferedImage binImage = ImageUtils.thresholdImage(line, false);
        byte[] data = ((DataBufferByte)binImage.getRaster().getDataBuffer()).getData();
        float[] result = new float[38400];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (float)(data[i] & 0xFF) / 255.0f;
        }
        return result;
    }
}

