/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.ocr;

import java.util.ArrayList;

class XmlHelper {
    XmlHelper() {
    }

    static String getFirstValueByTag(String source, String tag) {
        return XmlHelper.getFirstValueByTag(source, tag, false);
    }

    static String getFirstValueByTag(String source, String tag, boolean outer) {
        ArrayList<String> result = XmlHelper.getValuesByTag(source, tag, outer);
        return result.get(0);
    }

    static ArrayList<String> getValuesByTag(String source, String tag) {
        return XmlHelper.getValuesByTag(source, tag, false);
    }

    static ArrayList<String> getValuesByTag(String source, String tag, boolean outer) {
        ArrayList<String> result = new ArrayList<String>();
        String[] lines = source.split("\\r?\\n");
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line.trim());
        }
        String lo_source = sb.toString().toLowerCase();
        String open_tag = "<" + tag.toLowerCase() + ">";
        String close_tag = "</" + tag.toLowerCase() + ">";
        int begin_section = lo_source.indexOf(open_tag);
        while (begin_section != -1 && begin_section < lo_source.length()) {
            int end_section = lo_source.indexOf(close_tag, begin_section + open_tag.length());
            if (end_section == -1) {
                result.clear();
                break;
            }
            int shift_start = outer ? 0 : open_tag.length();
            int start = begin_section + shift_start;
            int shift_end = outer ? close_tag.length() : 0;
            int end = end_section + shift_end;
            result.add(sb.substring(start, end));
            begin_section = lo_source.indexOf(open_tag, end_section + close_tag.length());
        }
        if (result.isEmpty()) {
            result.add("");
        }
        return result;
    }
}

