/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz8V;
import asposewobfuscated.zz8Y;
import asposewobfuscated.zzEG;
import asposewobfuscated.zzEV;
import asposewobfuscated.zzS6;
import asposewobfuscated.zzW;
import asposewobfuscated.zzZ;
import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.zzZZO;
import java.io.EOFException;
import java.io.InputStream;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static zzEV zzZf4 = new zzEV();
    private static zzEV zzZf3 = new zzEV();
    private static zzEV zzZf2 = new zzEV();
    private static zzEV zzZf1 = new zzEV();
    private static zzEV zzZf0 = new zzEV();
    private static zzEV zzZeZ = new zzEV();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZ.zzZ(fileName, "fileName");
        zz8Y zz8Y2 = zzZ.zzT(fileName);
        try {
            FileFormatInfo fileFormatInfo = FileFormatUtil.zz5(zz8Y2);
            return fileFormatInfo;
        }
        finally {
            ((zz8V)zz8Y2).close();
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zz5(zzW.zzZ(stream));
    }

    static FileFormatInfo zz5(zz8V zz8V2) throws Exception {
        if (zz8V2 == null) {
            throw new NullPointerException("stream");
        }
        try {
            zzZZO zzZZO2 = new zzZZO();
            zz8V zz8V3 = zz8V2;
            zzZZO zzZZO3 = zzZZO2;
            return zzZZO2.zzY(zz8V3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzZ(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzLk(zzS6.zzj(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzLo(zzS6.zzj(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string = zzS6.zzY0(FileFormatUtil.zzLm(loadFormat));
        if (zzEG.zzYN(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzLk(FileFormatUtil.zzLl(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzLo(FileFormatUtil.zzLm(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzS6.zzY0(FileFormatUtil.zzLl(saveFormat));
        if (zzEG.zzYN(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("extension");
        }
        return FileFormatUtil.zzLo(zzS6.zzi(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        int n = imageType;
        Object object = zzZf2.get(n);
        return "." + zzS6.zzY0(object == null ? 0 : (Integer)object);
    }

    static Exception zzZ(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzLp(int n) {
        return zzS6.toString(FileFormatUtil.zzLl(n));
    }

    static int zzLo(int n) {
        Object object = zzZf0.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    static int zzLn(int n) {
        Object object = zzZeZ.get(n);
        if (object != null) {
            return (Integer)object;
        }
        return 1;
    }

    private static int zzLm(int n) {
        Object object = zzZf4.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzLl(int n) {
        Object object = zzZf3.get(n);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    private static int zzLk(int n) {
        Object object = zzZf1.get(n);
        if (object == null) {
            return 255;
        }
        return (Integer)object;
    }

    static {
        Object[] objectArray = new Object[]{11, 10, 10, null, 11, null, 0, null, 12, 11, 11, null, 13, 20, 20, null, 13, null, 254, null, 14, 21, 21, null, 15, 22, 22, null, 16, 23, 23, null, 18, 24, 24, null, 19, 25, 25, null, 20, 26, 26, null, 21, 27, 27, null, 24, 30, 30, null, 17, 31, 31, null, 25, 50, 50, null, 26, 45, null, null, 27, 51, 51, null, 28, null, 52, null, 22, 60, 60, null, 23, 61, 61, null, 31, 40, null, null, 39, 47, null, null, 32, 41, null, null, 33, 46, null, null, 36, 42, null, null, 34, 43, null, null, 35, 44, null, null, 29, 52, null, null, 30, 70, 62, null, 37, 71, null, null, 8, 100, null, null, 9, 105, null, null, 6, 101, null, 6, 7, 102, null, 7, 5, 104, null, 5, 4, null, null, 4, 3, null, null, 3, 38, 72, null, null, 2, 103, null, 2};
        for (int i = 0; i < 156; i += 4) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            Object object3 = objectArray[i + 2];
            Object object4 = objectArray[i + 3];
            if (object2 != null) {
                zzZf0.add((Integer)object, object2);
                zzZf3.add((Integer)object2, object);
            }
            if (object3 != null) {
                if (!zzZf1.contains((Integer)object)) {
                    zzZf1.add((Integer)object, object3);
                }
                zzZf4.add((Integer)object3, object);
            }
            if (object4 == null) continue;
            zzZeZ.add((Integer)object, object4);
            zzZf2.add((Integer)object4, object);
        }
    }
}

