/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz3C;
import asposewobfuscated.zz42;
import asposewobfuscated.zzA0;
import asposewobfuscated.zzEG;
import asposewobfuscated.zzRH;
import asposewobfuscated.zzZ;
import com.aspose.words.BookmarkStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.DropDownItemCollection;
import com.aspose.words.Field;
import com.aspose.words.FieldChar;
import com.aspose.words.FieldOptions;
import com.aspose.words.FieldStart;
import com.aspose.words.Node;
import com.aspose.words.SpecialChar;
import com.aspose.words.zzYQW;
import com.aspose.words.zzZ16;
import com.aspose.words.zzZFD;
import com.aspose.words.zzZON;
import com.aspose.words.zzZYF;

public class FormField
extends SpecialChar {
    private zzZYF zzZcG;
    private Field zzZcF;
    static String zzZcE = zz42.zzV('\u2002', 5);
    private static final zz3C zzVU = new zz3C("uppercase", "lowercase", "first capital", "title case");

    FormField(DocumentBase doc, zzZYF formFieldPr, zzZ16 runPr) {
        super(doc, '\u0001', runPr);
        this.zzZcG = formFieldPr;
    }

    @Override
    final Node zzZ(boolean bl, zzZON zzZON2) {
        FormField formField = (FormField)super.zzZ(bl, zzZON2);
        ((FormField)super.zzZ(bl, zzZON2)).zzZcG = (zzZYF)this.zzZcG.zzzM();
        formField.zzZcF = null;
        return formField;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return FormField.visitorActionToBool(visitor.visitFormField(this));
    }

    public void removeField() throws Exception {
        if (this.getField() == null) {
            return;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart != null) {
            bookmarkStart.remove();
            this.getField().getStart().zzZEz().insertBefore(bookmarkStart, this.getField().getStart());
        }
        this.getField().remove();
    }

    public void setTextInputValue(Object newValue) throws Exception {
        if (newValue == null) {
            throw new NullPointerException("newValue");
        }
        if (this.getType() != 70) {
            throw new IllegalStateException("The form field is not a text form field.");
        }
        switch (this.getTextInputType()) {
            case 0: {
                int n;
                String string = this.getTextInputFormat();
                string = string.toLowerCase();
                switch (zzVU.zzWZ(string)) {
                    case 0: {
                        n = 1;
                        break;
                    }
                    case 1: {
                        n = 2;
                        break;
                    }
                    case 2: {
                        n = 4;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 0;
                    }
                }
                int n2 = n;
                this.setResult(zzEG.zzI((String)newValue, n2));
                return;
            }
            case 1: {
                double d;
                FieldOptions fieldOptions = this.zzZEy().getFieldOptions();
                Object object = newValue;
                if (object == null) {
                    d = 0.0;
                } else if (object instanceof Byte) {
                    d = ((Byte)object).byteValue();
                } else if (object instanceof Short) {
                    d = ((Short)object).shortValue();
                } else if (object instanceof Integer) {
                    d = ((Integer)object).intValue();
                } else if (object instanceof Long) {
                    d = ((Long)object).longValue();
                } else if (object instanceof Float) {
                    d = ((Float)object).floatValue();
                } else if (object instanceof Double) {
                    d = (Double)object;
                } else {
                    throw new ClassCastException("Cannot convert a value to double.");
                }
                this.setResult(zzRH.zzZ(d, this.getTextInputFormat(), true, fieldOptions.getLegacyNumberFormat(), fieldOptions.getUseInvariantCultureNumberFormat()));
                return;
            }
            case 2: {
                this.setResult(zzYQW.zzY((zzA0)newValue, this.getTextInputFormat()));
                return;
            }
            case 3: 
            case 4: 
            case 5: {
                throw new IllegalStateException("Cannot set the form field value because it is calculated.");
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    @Override
    public int getNodeType() {
        return 25;
    }

    public String getName() {
        return this.zzZcG.getName();
    }

    public void setName(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        BookmarkStart bookmarkStart = this.getBookmarkStart();
        if (bookmarkStart != null) {
            bookmarkStart.getBookmark().setName(value);
        }
        this.zzZcG.setName(value);
    }

    public int getType() {
        if (this.getField() != null) {
            return this.getField().getType();
        }
        return 0;
    }

    final int zzZVr() {
        switch (this.getType()) {
            case 70: {
                return 0;
            }
            case 71: {
                return 1;
            }
            case 83: {
                return 2;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    /*
     * Enabled aggressive block sorting
     */
    final Field getField() {
        if (this.zzZcF == null) {
            FieldChar fieldChar;
            FieldChar fieldChar2;
            block7: {
                FormField formField = this;
                int n = 0;
                Node node = formField.getPreviousSibling();
                while (node != null) {
                    switch (node.getNodeType()) {
                        case 22: {
                            if (n-- != 0) break;
                            fieldChar2 = (FieldStart)node;
                            break block7;
                        }
                        case 24: {
                            ++n;
                        }
                    }
                    node = node.getPreviousSibling();
                }
                fieldChar2 = fieldChar = null;
            }
            if (fieldChar2 != null) {
                this.zzZcF = fieldChar.getField();
            }
        }
        return this.zzZcF;
    }

    public String getResult() {
        switch (this.getType()) {
            case 70: {
                if (this.getField() == null) {
                    return "";
                }
                String string = this.getField().getResult();
                if (zz42.equals(string, zzZcE)) {
                    return "";
                }
                return string;
            }
            case 71: {
                if (this.getChecked()) {
                    return "1";
                }
                return "0";
            }
            case 83: {
                return this.zzZVq();
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public void setResult(String value) throws Exception {
        zzZ.zzZ((Object)value, "value");
        switch (this.getType()) {
            case 70: {
                this.getField().setResult(value);
                return;
            }
            case 71: {
                this.setChecked(zzRH.parseInt(value) != 0);
                return;
            }
            case 83: {
                this.zzQI(value);
                return;
            }
        }
        throw new IllegalStateException("Unknown form field type.");
    }

    public String getStatusText() {
        return this.zzZcG.getStatusText();
    }

    public void setStatusText(String value) {
        this.zzZcG.setStatusText(value);
    }

    public boolean getOwnStatus() {
        return this.zzZcG.zzZVm();
    }

    public void setOwnStatus(boolean value) {
        this.zzZcG.zzWS(value);
    }

    public String getHelpText() {
        return this.zzZcG.getHelpText();
    }

    public void setHelpText(String value) {
        this.zzZcG.setHelpText(value);
    }

    public boolean getOwnHelp() {
        return this.zzZcG.zzZVn();
    }

    public void setOwnHelp(boolean value) {
        this.zzZcG.zzWT(value);
    }

    public boolean getCalculateOnExit() {
        return this.zzZcG.zzZVo();
    }

    public void setCalculateOnExit(boolean value) {
        this.zzZcG.zzWU(value);
    }

    public String getEntryMacro() {
        return this.zzZcG.getEntryMacro();
    }

    public void setEntryMacro(String value) {
        this.zzZcG.setEntryMacro(value);
    }

    public String getExitMacro() {
        return this.zzZcG.getExitMacro();
    }

    public void setExitMacro(String value) {
        this.zzZcG.setExitMacro(value);
    }

    public boolean getEnabled() {
        return this.zzZcG.getEnabled();
    }

    public void setEnabled(boolean value) {
        this.zzZcG.setEnabled(value);
    }

    public String getTextInputFormat() {
        return this.zzZcG.getTextInputFormat();
    }

    public void setTextInputFormat(String value) {
        this.zzZcG.setTextInputFormat(value);
    }

    public int getTextInputType() {
        return this.zzZcG.getTextInputType();
    }

    public void setTextInputType(int value) {
        this.zzZcG.setTextInputType(value);
    }

    public String getTextInputDefault() {
        return this.zzZcG.getTextInputDefault();
    }

    public void setTextInputDefault(String value) throws Exception {
        this.zzZcG.setTextInputDefault(value);
        if (this.getTextInputType() == 5) {
            Node node = this.getField().getStart().zzGx(21);
            zzZFD.zzZ(node, false, this, false);
            DocumentBuilder documentBuilder = new DocumentBuilder(this.zzZEy());
            documentBuilder.moveTo(this);
            documentBuilder.insertField(value, "");
            this.getField().update();
        }
    }

    public int getMaxLength() {
        return this.zzZcG.zzZVl();
    }

    public void setMaxLength(int value) {
        this.zzZcG.zzKH(value);
    }

    public DropDownItemCollection getDropDownItems() {
        return this.zzZcG.getDropDownItems();
    }

    public int getDropDownSelectedIndex() {
        zzZYF zzZYF2 = this.zzZcG;
        if (zzZYF2.contains(21070)) {
            return this.zzZcG.zzZVf();
        }
        return this.zzZcG.zzZVg();
    }

    public void setDropDownSelectedIndex(int value) {
        this.zzZcG.zzKE(value);
    }

    final String zzZVq() {
        int n = this.getDropDownSelectedIndex();
        if (n < 0 || n >= this.getDropDownItems().getCount()) {
            return "";
        }
        return this.getDropDownItems().get(n);
    }

    final void zzQI(String string) {
        for (int i = 0; i < this.getDropDownItems().getCount(); ++i) {
            if (!zzEG.equalsIgnoreCase(this.getDropDownItems().get(i), string)) continue;
            this.setDropDownSelectedIndex(i);
            return;
        }
    }

    public boolean getChecked() {
        zzZYF zzZYF2 = this.zzZcG;
        if (zzZYF2.contains(21010)) {
            return this.zzZcG.zzZVh();
        }
        return this.zzZcG.zzZVi();
    }

    public void setChecked(boolean value) {
        this.zzZcG.zzWP(value);
    }

    public boolean getDefault() {
        return this.zzZcG.zzZVi();
    }

    public void setDefault(boolean value) {
        this.zzZcG.zzWQ(value);
    }

    public boolean isCheckBoxExactSize() {
        return !this.zzZcG.zzZVk();
    }

    public void isCheckBoxExactSize(boolean value) {
        this.zzZcG.zzWR(!value);
    }

    public double getCheckBoxSize() {
        int n = this.zzZcG.zzZVj();
        return (double)n / 2.0;
    }

    public void setCheckBoxSize(double value) {
        this.zzZcG.zzKG(zzZ.zzV(value));
    }

    final BookmarkStart getBookmarkStart() {
        if (this.getField() == null) {
            return null;
        }
        BookmarkStart bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getNextSibling(), BookmarkStart.class);
        if (bookmarkStart == null) {
            bookmarkStart = zzZ.zzZ((Object)this.getField().getStart().getPreviousSibling(), BookmarkStart.class);
        }
        return bookmarkStart;
    }

    final zzZYF zzZVp() {
        return this.zzZcG;
    }
}

