/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzA2;
import asposewobfuscated.zzZ;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.zzX;
import com.aspose.words.zzYTZ;
import com.aspose.words.zzZON;
import com.aspose.words.zzZPX;
import com.aspose.words.zzZVD;

public abstract class Node
implements Cloneable {
    private Node zzYLX;
    private Node zzYLW;
    private Node zzYLV;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this.zzZ(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYLX == null) {
            return null;
        }
        if (this.zzYLX.getNodeType() == 36) {
            return null;
        }
        return (CompositeNode)this.zzYLX;
    }

    final CompositeNode zzZEz() {
        if (zzX.zzK(this.getParentNode())) {
            return this.getParentNode().zzZEz();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this instanceof DocumentBase) {
            return (DocumentBase)this;
        }
        if (this.zzYLX == null) {
            return null;
        }
        return this.zzYLX.getDocument();
    }

    final Document zzZEy() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzZEx() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zz8g();
    }

    public Node getPreviousSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getFirstChild()) {
            Node node = this;
            return node.zzYLV;
        }
        return null;
    }

    final Node zzZEw() {
        Node node = zzX.zzI(this.getPreviousSibling());
        if (node == null && zzX.zzK(this.getParentNode())) {
            node = this.getParentNode().zzZEw();
        }
        return node;
    }

    final Node zzZEv() {
        Node node = zzX.zzJ(this.getNextSibling());
        if (node == null && zzX.zzK(this.getParentNode())) {
            node = this.getParentNode().zzZEv();
        }
        return node;
    }

    public Node getNextSibling() {
        CompositeNode compositeNode = this.getParentNode();
        if (compositeNode != null && this != compositeNode.getLastChild()) {
            Node node = this;
            return node.zzYLW;
        }
        return null;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzZEu() {
        return this.getParentNode() == null || this == this.getParentNode().getLastChild();
    }

    final boolean isFirstChild() {
        return this.getParentNode() == null || this == this.getParentNode().getFirstChild();
    }

    final boolean zzZEt() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzX.zzT(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZEs() {
        return this.zzYLW;
    }

    final void zzZn(Node node) {
        this.zzYLW = node;
    }

    final Node zzZEr() {
        return this.zzYLV;
    }

    final void zzZm(Node node) {
        this.zzYLV = node;
    }

    final int zzZEq() {
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        if (zzX.zzP(this)) {
            return 3;
        }
        if (zzX.zzO(this)) {
            return 4;
        }
        if (zzX.zzN(this)) {
            return 5;
        }
        if (zzX.zzM(this)) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzZ(isCloneChildren, null);
    }

    Node zzZ(boolean bl, zzZON zzZON2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYLX != null) {
            node.zzYLX = this.getDocument().zz73();
        }
        node.zzYLW = null;
        node.zzYLV = null;
        if (zzZON2 != null) {
            zzZON2.zzV(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzV(StringBuilder stringBuilder) {
        zzZ.zzY(stringBuilder, this.getText());
    }

    public Node getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isAssignableFrom(compositeNode.getClass())) continue;
            return compositeNode;
        }
        return null;
    }

    public Node getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZl(Node node) {
        this.zzYLX = node != null ? node : this.getDocument().zz73();
    }

    final void zzZ(DocumentBase documentBase) {
        this.zzYLX = documentBase != null ? documentBase.zz73() : null;
    }

    final boolean zzZk(Node node) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzZEp() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzGx(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzGw(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzUj(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    @Deprecated
    public String toTxt() throws Exception {
        return this.toString(70);
    }

    public String toString(int saveFormat) throws Exception {
        zzZPX zzZPX2;
        int n = saveFormat;
        switch (n) {
            case 50: {
                zzZPX2 = new zzZVD();
                break;
            }
            case 70: {
                zzZPX2 = new zzYTZ();
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZPX zzZPX3 = zzZPX2;
        return zzZPX2.zzZz(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZPX zzZPX2;
        SaveOptions saveOptions2 = saveOptions;
        switch (saveOptions2.getSaveFormat()) {
            case 50: {
                zzZPX2 = new zzZVD((HtmlSaveOptions)saveOptions2);
                break;
            }
            case 70: {
                zzZPX2 = new zzYTZ((TxtSaveOptions)saveOptions2);
                break;
            }
            default: {
                throw new IllegalStateException("Exporting fragments of a document in this format is not supported.");
            }
        }
        zzZPX zzZPX3 = zzZPX2;
        return zzZPX2.zzZz(this);
    }

    final Node zzGv(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzX.zzQ(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final boolean zzZj(Node node) {
        Node node2;
        zzA2 zzA22;
        zzA2 zzA23;
        Node node3 = node;
        Node node4 = this;
        if (node4 == null || node3 == null) {
            return false;
        }
        zzA2 zzA24 = Node.zzZi(node4);
        zzA2 zzA25 = zzA23 = Node.zzZi(node3);
        zzA2 zzA26 = zzA24;
        Object var13_8 = null;
        while (zzA26.peek() == zzA25.peek()) {
            var13_8 = zzA26.pop();
            zzA25.pop();
            zzA22 = zzA26;
            if (zzA22.size() != 0 && (zzA22 = zzA25).size() != 0) continue;
        }
        if ((node2 = (Node)var13_8) != null) {
            zzA22 = zzA24;
            if (zzA22.size() == 0 || (zzA22 = zzA23).size() == 0) {
                zzA22 = zzA23;
                boolean bl = zzA22.size() > 0;
                return bl;
            }
            Object e = zzA24.peek();
            Object e2 = zzA23.peek();
            for (Node node5 : ((CompositeNode)node2).getChildNodes()) {
                if (node5 == e) {
                    return true;
                }
                if (node5 != e2) continue;
            }
        }
        return false;
    }

    final boolean isRemoved() {
        return this.getAncestor(1) == null;
    }

    private static zzA2 zzZi(Node node) {
        zzA2 zzA22 = new zzA2();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzA22.push(node2);
        }
        return zzA22;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "GlossaryDocument";
            }
            case 30: {
                return "BuildingBlock";
            }
            case 31: {
                return "CommentRangeStart";
            }
            case 32: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 33: {
                return "OfficeMath";
            }
            case 34: {
                return "SubDocument";
            }
            case 35: {
                return "System";
            }
            case 36: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }
}

