/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz8W;
import asposewobfuscated.zzS6;
import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IWarningCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.SwfSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;

public abstract class SaveOptions {
    private boolean zzYj8 = false;
    private boolean zzYj7 = true;
    private boolean zzGF;
    private String zzYj6;
    private boolean zzYj5;
    private boolean zzYj4 = false;
    private boolean zzYj3 = true;
    private int zzYj2 = 1;
    private int zzZ38 = 0;
    private IWarningCallback zz5F;
    private int zzFF = 0;
    private String zzYj1 = "";
    private boolean zzYj0 = true;

    protected SaveOptions() {
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZRn() {
        return false;
    }

    boolean zzZWF() {
        return true;
    }

    final boolean zzZpm() {
        return this.zzYj7;
    }

    public String getTempFolder() {
        return this.zzYj6;
    }

    public void setTempFolder(String value) {
        this.zzYj6 = value;
    }

    public boolean getPrettyFormat() {
        return this.zzGF;
    }

    public void setPrettyFormat(boolean value) {
        this.zzGF = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYj5;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYj5 = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYj4;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYj4 = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzYj3;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzYj3 = value;
    }

    public int getColorMode() {
        return this.zzFF;
    }

    public void setColorMode(int value) {
        this.zzFF = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYj2;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYj2 = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzZ38;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzZ38 = value;
    }

    public String getDefaultTemplate() {
        return this.zzYj1;
    }

    public void setDefaultTemplate(String value) {
        this.zzYj1 = value;
    }

    public boolean getUpdateFields() {
        return this.zzYj0;
    }

    public void setUpdateFields(boolean value) {
        this.zzYj0 = value;
    }

    @Deprecated
    public IWarningCallback getWarningCallback() {
        return this.zz5F;
    }

    @Deprecated
    public void setWarningCallback(IWarningCallback value) {
        this.zz5F = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzYj8;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzYj8 = value;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 43: {
                return new SwfSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzLo(zzS6.zzi(zz8W.zzXL(fileName))));
    }
}

