/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zzNY;
import asposewobfuscated.zzNZ;
import asposewobfuscated.zzZ;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellCollection;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.PreferredWidth;
import com.aspose.words.Row;
import com.aspose.words.RowCollection;
import com.aspose.words.Shading;
import com.aspose.words.Style;
import com.aspose.words.zzX;
import com.aspose.words.zzYH;
import com.aspose.words.zzYR2;
import com.aspose.words.zzYVC;
import com.aspose.words.zzYVG;
import com.aspose.words.zzYVI;
import com.aspose.words.zzZE8;
import com.aspose.words.zzZLG;
import com.aspose.words.zzZON;
import com.aspose.words.zzZX3;
import java.awt.Color;
import java.util.Iterator;

public class Table
extends CompositeNode<Row> {
    private RowCollection zzYaF;
    private zzYVC zzZul;

    public Table(DocumentBase doc) {
        super(doc);
    }

    @Override
    public int getNodeType() {
        return 5;
    }

    public Row getFirstRow() {
        Table table = this;
        return (Row)zzX.zzJ(table.getFirstChild());
    }

    public Row getLastRow() {
        Table table = this;
        return (Row)zzX.zzI(table.getLastChild());
    }

    public RowCollection getRows() {
        if (this.zzYaF == null) {
            this.zzYaF = new RowCollection(this);
        }
        return this.zzYaF;
    }

    final boolean zzZia() {
        for (Row row : this.getRows()) {
            Iterator iterator = row.getCells().iterator();
            if (!iterator.hasNext()) continue;
            iterator.next();
            return true;
        }
        return false;
    }

    @Override
    final Node zzZ(boolean bl, zzZON zzZON2) {
        Table table = (Table)super.zzZ(bl, zzZON2);
        if (this.zzZul != null) {
            table.zzZul = (zzYVC)this.zzZul.zzzM();
        }
        table.zzYaF = null;
        return table;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzZ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableStart(this);
    }

    @Override
    final int zzY(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitTableEnd(this);
    }

    public void ensureMinimum() {
        Row row = this.getFirstRow();
        if (row == null) {
            row = (Row)this.appendChild(new Row(this.getDocument()));
        }
        row.ensureMinimum();
    }

    final Cell zzXG(int n, int n2) {
        try {
            if (n2 < 0 || n2 >= this.getRows().getCount()) {
                return null;
            }
            CellCollection cellCollection = this.getRows().get(n2).getCells();
            if (n < 0 || n >= cellCollection.getCount()) {
                return null;
            }
            return cellCollection.get(n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    final int getColumnCount() {
        int n = 0;
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Row row2 = row;
            int n2 = 0;
            Cell cell = row2.getFirstCell();
            while (cell != null) {
                n2 += cell.zzxG().zzzx();
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZEv();
            }
            n = Math.max(n, n2);
            compositeNode = row;
            row = (Row)compositeNode.zzZEv();
        }
        return n;
    }

    final zzZLG zzZi9() {
        zzYVG zzYVG2 = new zzYVG(this);
        return zzYVG2.zzZhk();
    }

    final void zzZi8() {
        for (Row row = this.getFirstRow(); row != null; row = row.zzZtB()) {
            Cell cell = null;
            block6: for (Cell cell2 = row.getFirstCell(); cell2 != null; cell2 = cell2.zzxI()) {
                switch (cell2.zzxG().getHorizontalMerge()) {
                    case 1: {
                        cell = cell2;
                        cell.zzxG().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 2: {
                        if (cell != null) {
                            Cell cell3;
                            cell.zzxG().setWidth(cell.zzxG().getWidth() + cell2.zzxG().getWidth());
                            cell.zzxG().zzTV(cell.zzxG().zzzx() + cell2.zzxG().zzzx());
                            if (cell2.zzxG().getWidth() != 0 && cell.zzxG().getPreferredWidth().zzBo() && cell2.zzxG().getPreferredWidth().zzBo()) {
                                int n = cell.zzxG().getPreferredWidth().zzZvf() + cell2.zzxG().getPreferredWidth().zzZvf();
                                cell.zzxG().setPreferredWidth(PreferredWidth.zzDx(n));
                            }
                            if ((Cell)(cell3 = cell2).zzZEv() == null || ((Cell)(cell3 = cell2).zzZEv()).zzxG().getHorizontalMerge() != 2) {
                                Object object = cell2.zzxG().zzU4(3140);
                                if (object != null) {
                                    cell.zzxG().zzU(3140, object);
                                } else {
                                    cell.zzxG().remove(3140);
                                }
                            }
                            cell2.remove();
                            cell2 = cell;
                            continue block6;
                        }
                        cell2.zzxG().setHorizontalMerge(0);
                        continue block6;
                    }
                    case 0: {
                        cell = null;
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unknown cell merge type.");
                    }
                }
            }
        }
    }

    final void zzZi7() {
        Object object;
        if (!this.zztj()) {
            return;
        }
        zzYVI zzYVI2 = new zzYVI(this);
        if (zzYVI2.zzwt().length == 0) {
            return;
        }
        zzNZ zzNZ2 = new zzNZ();
        zzNY zzNY2 = new zzNY();
        CompositeNode compositeNode = this.getFirstRow();
        while (compositeNode != null) {
            zzYVI2.zzF((Row)compositeNode);
            zzNZ zzNZ3 = new zzNZ();
            zzNY zzNY3 = new zzNY();
            int n = zzYVI2.zzZkR();
            Object object2 = ((Row)compositeNode).getFirstCell();
            while (object2 != null) {
                int n2 = zzYVI2.zzZhA();
                if (((Cell)object2).zzxG().getVerticalMerge() != 0) {
                    boolean bl;
                    int n3 = zzNZ2.get(n);
                    if (zzNZ.zzXD(n3) || n3 != n2) {
                        ((Cell)object2).zzxG().setVerticalMerge(1);
                    }
                    if (bl = !((Row)compositeNode).zz6E().zzXj(4120) && ((Row)compositeNode).getCells().getCount() == 1) {
                        CompositeNode compositeNode2 = compositeNode;
                        int n4 = ((Row)compositeNode2).getFirstCell().getLastParagraph() != null ? (int)(23.0 * ((Row)compositeNode2).getFirstCell().getLastParagraph().getParagraphBreakFont().getSize()) : 276;
                        ((Row)compositeNode2).zz6E().zzU(4120, new zzZX3(0, n4));
                    }
                    zzNZ3.set(n, n2);
                    zzNY3.set(n, object2);
                }
                n += n2;
                object = object2;
                object2 = (Cell)((Node)object).zzZEv();
            }
            object2 = zzNY2.zzOn();
            while (((zzNY.zzZ)object2).moveNext()) {
                Cell cell = (Cell)((zzNY.zzZ)object2).zzOl();
                if (cell.zzxG().getVerticalMerge() != 1 || zzNY3.get(((zzNY.zzZ)object2).zzOp()) != null) continue;
                cell.zzxG().setVerticalMerge(0);
            }
            zzNZ2 = zzNZ3;
            zzNY2 = zzNY3;
            object = compositeNode;
            compositeNode = (Row)((Node)object).zzZEv();
        }
        compositeNode = this.getLastRow().getFirstCell();
        while (compositeNode != null) {
            if (((Cell)compositeNode).zzxG().getVerticalMerge() == 1) {
                ((Cell)compositeNode).zzxG().setVerticalMerge(0);
            }
            object = compositeNode;
            compositeNode = (Cell)((Node)object).zzZEv();
        }
    }

    final void zzZi6() throws Exception {
        if (!this.isNested() || this.getFirstRow() == null) {
            return;
        }
        Table table = (Table)this.getAncestor(5);
        boolean bl = table.getAllowAutoFit();
        if (bl != this.getAllowAutoFit()) {
            if (!bl) {
                this.zzZi9();
            }
            this.setAllowAutoFit(bl);
        }
    }

    final int zz7R() {
        Row row = this.getFirstRow();
        if (row == null) {
            return 0;
        }
        zzYH zzYH2 = row.getFirstCell().zzxG();
        boolean bl = this.isNested();
        zzYH zzYH3 = zzYH2;
        zzYVC zzYVC2 = row.zz6E();
        return zzYVC2.zzZIS() - zzYVC2.zzY(zzYH3, bl);
    }

    @Override
    final boolean zzn(Node node) {
        return zzX.zzO(node);
    }

    final boolean isNested() {
        if (this.zzZEz() == null) {
            return false;
        }
        return this.zzZEz().getNodeType() == 7;
    }

    public int getAlignment() {
        return (Integer)this.zzAk(4010);
    }

    public void setAlignment(int value) throws Exception {
        this.zzw(4010, value);
    }

    public boolean getAllowAutoFit() {
        return (Boolean)this.zzAk(4240);
    }

    public void setAllowAutoFit(boolean value) throws Exception {
        this.zzw(4240, value);
    }

    public PreferredWidth getPreferredWidth() {
        return (PreferredWidth)this.zzAk(4230);
    }

    public void setPreferredWidth(PreferredWidth value) throws Exception {
        this.zzw(4230, value);
    }

    public boolean getBidi() {
        return (Boolean)this.zzAk(4380);
    }

    public void setBidi(boolean value) throws Exception {
        this.zzw(4380, value);
    }

    public double getLeftPadding() {
        int n = (Integer)this.zzAk(4020);
        return (double)n / 20.0;
    }

    public void setLeftPadding(double value) throws Exception {
        this.zzw(4020, zzZ.zzU(value));
    }

    public double getRightPadding() {
        int n = (Integer)this.zzAk(4320);
        return (double)n / 20.0;
    }

    public void setRightPadding(double value) throws Exception {
        this.zzw(4320, zzZ.zzU(value));
    }

    public double getTopPadding() {
        int n = (Integer)this.zzAk(4300);
        return (double)n / 20.0;
    }

    public void setTopPadding(double value) throws Exception {
        this.zzw(4300, zzZ.zzU(value));
    }

    public double getBottomPadding() {
        int n = (Integer)this.zzAk(4310);
        return (double)n / 20.0;
    }

    public void setBottomPadding(double value) throws Exception {
        this.zzw(4310, zzZ.zzU(value));
    }

    public double getCellSpacing() {
        int n = (Integer)this.zzAk(4290);
        return (double)n / 20.0;
    }

    public void setCellSpacing(double value) throws Exception {
        this.zzw(4290, zzZ.zzU(value));
    }

    public double getLeftIndent() {
        int n = (Integer)this.zzAk(4340);
        return (double)n / 20.0;
    }

    public void setLeftIndent(double value) throws Exception {
        this.zzw(4340, zzZ.zzU(value));
    }

    public int getStyleOptions() {
        return (Integer)this.zzAk(4140);
    }

    public void setStyleOptions(int value) throws Exception {
        this.zzw(4140, value);
    }

    public Style getStyle() {
        return this.getDocument().getStyles().zzXI(this.zzZVE(), 11);
    }

    public void setStyle(Style value) throws Exception {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("This style belongs to a different document.");
        }
        if (value.getType() != 3) {
            throw new IllegalArgumentException("This style is not a table style.");
        }
        int n = value.zzZVE();
        Table table = this;
        table.zzw(4005, n);
    }

    public String getStyleName() {
        return this.getStyle().getName();
    }

    public void setStyleName(String value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzJY(value));
    }

    public int getStyleIdentifier() {
        return this.getStyle().getStyleIdentifier();
    }

    public void setStyleIdentifier(int value) throws Exception {
        this.setStyle(this.getDocument().getStyles().zzAD(value));
    }

    public int getTextWrapping() {
        if (this.isFloating()) {
            return 1;
        }
        return 0;
    }

    public void setTextWrapping(int value) throws Exception {
        if (value == 1) {
            Table table = this;
            zzYVC zzYVC2 = table.getFirstRow().zz6E();
            table.zzw(4160, 2);
            table.zzw(4190, 0);
            table.zzw(4210, 180);
            table.zzw(4270, 180);
            table.zzw(4350, false);
            int n = (Integer)zzYVC2.zzU3(4010);
            if (n == 2) {
                table.zzw(4180, 3);
            } else if (n == 1) {
                table.zzw(4180, 2);
            }
            table.zzAm(4010);
            if (zzYVC2.contains(4340)) {
                int n2 = (Integer)zzYVC2.zzU4(4340);
                table.zzw(4170, n2 - 1);
            }
            table.zzAm(4340);
            return;
        }
        Table table = this;
        zzYVC zzYVC3 = table.getFirstRow().zz6E();
        int n = (Integer)zzYVC3.zzU3(4180);
        if (n == 3) {
            table.zzw(4010, 2);
        } else if (n == 2) {
            table.zzw(4010, 1);
        }
        table.zzAm(4170);
        table.zzAm(4160);
        table.zzAm(4150);
        table.zzAm(4190);
        table.zzAm(4210);
        table.zzAm(4270);
        table.zzAm(4350);
        table.zzAm(4180);
        table.zzAm(4200);
    }

    final int zzZVE() {
        return (Integer)this.zzAk(4005);
    }

    final boolean isFloating() {
        return this.getRows().getCount() > 0 && this.getRows().get(0).zz6E().isFloating();
    }

    final zzYVC zz6E() {
        if (this.zzZul == null) {
            this.zzZul = new zzYVC();
        }
        return this.zzZul;
    }

    public void setBorders(int lineStyle, double lineWidth, Color color) throws Exception {
        Iterator iterator = zzYVC.zz1x.zzEn().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.setBorder(n, lineStyle, lineWidth, color, true);
        }
    }

    public void setBorder(int borderType, int lineStyle, double lineWidth, Color color, boolean isOverrideCellBorders) throws Exception {
        if (isOverrideCellBorders) {
            int n = borderType;
            Table table = this;
            switch (n) {
                case 3: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzxG().remove(3110);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZEv();
                    }
                    break;
                }
                case 0: {
                    CompositeNode compositeNode;
                    Row row = table.getLastRow();
                    if (row == null) break;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        cell.zzxG().remove(3130);
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZEv();
                    }
                    break;
                }
                case 1: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        if (cell != null) {
                            cell.zzxG().remove(3120);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZEv();
                    }
                    break;
                }
                case 2: {
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getLastCell();
                        if (cell != null) {
                            cell.zzxG().remove(3140);
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZEv();
                    }
                    break;
                }
                case 4: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        boolean bl2 = !row.isFirstRow();
                        bl = !row.isLastRow();
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            if (bl2) {
                                cell.zzxG().remove(3110);
                            }
                            if (bl) {
                                cell.zzxG().remove(3130);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZEv();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZEv();
                    }
                    break;
                }
                case 5: {
                    boolean bl;
                    CompositeNode compositeNode;
                    Row row = table.getFirstRow();
                    while (row != null) {
                        Cell cell = row.getFirstCell();
                        while (cell != null) {
                            boolean bl3;
                            bl = !cell.isFirstCell();
                            boolean bl4 = bl3 = !cell.isLastCell();
                            if (bl) {
                                cell.zzxG().remove(3120);
                            }
                            if (bl3) {
                                cell.zzxG().remove(3140);
                            }
                            compositeNode = cell;
                            cell = (Cell)compositeNode.zzZEv();
                        }
                        compositeNode = row;
                        row = (Row)compositeNode.zzZEv();
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected border type.");
                }
            }
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZtB()) {
            Border border = row.getRowFormat().getBorders().getByBorderType(borderType);
            border.setLineStyle(lineStyle);
            border.setLineWidth(lineWidth);
            border.setColor(color);
        }
    }

    public void clearBorders() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            int n;
            zzYR2 zzYR22 = row.zz6E();
            Iterator iterator = zzYVC.zz1x.zzEl().iterator();
            while (iterator.hasNext()) {
                n = (Integer)iterator.next();
                zzYR22.remove(n);
            }
            Cell cell = row.getFirstCell();
            while (cell != null) {
                zzYR22 = cell.zzxG();
                iterator = zzYH.zz1x.zzEl().iterator();
                while (iterator.hasNext()) {
                    n = (Integer)iterator.next();
                    zzYR22.remove(n);
                }
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZEv();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZEv();
        }
    }

    public void setShading(int texture, Color foregroundColor, Color backgroundColor) {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                Shading shading = cell.getCellFormat().getShading();
                shading.setTexture(texture);
                shading.setForegroundPatternColor(foregroundColor);
                shading.setBackgroundPatternColor(backgroundColor);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZEv();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZEv();
        }
    }

    public void clearShading() {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            zzYR2 zzYR22 = row.zz6E();
            zzYR22.remove(4330);
            Cell cell = row.getFirstCell();
            while (cell != null) {
                zzYR22 = cell.zzxG();
                zzYR22.remove(3170);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZEv();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZEv();
        }
    }

    public void autoFit(int behavior) throws Exception {
        switch (behavior) {
            case 0: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzAm(4230);
                table.zzAl(3020);
                table.zzZi9();
                return;
            }
            case 1: {
                Table table = this;
                table.setAllowAutoFit(true);
                table.zzw(4230, PreferredWidth.fromPercent(100.0));
                table.zzAl(3020);
                table.zzZi9();
                return;
            }
            case 2: {
                Table table = this;
                table.setAllowAutoFit(false);
                table.setPreferredWidth(PreferredWidth.AUTO);
                Table table2 = table;
                if (table2.zz6E().zzZgR() != null) {
                    table2.zz6E().remove(5106);
                }
                table2 = table;
                Row row = table2.getFirstRow();
                while (row != null) {
                    CompositeNode compositeNode;
                    Cell cell = row.getFirstCell();
                    while (cell != null) {
                        PreferredWidth preferredWidth;
                        Object object = cell.zzxG().zzU4(3010);
                        int n = object == null ? 0 : (Integer)object;
                        if (n <= 0 && (preferredWidth = cell.getCellFormat().getPreferredWidth()).zzBo()) {
                            n = preferredWidth.zzZvf();
                            cell.zzxG().setWidth(n);
                        }
                        if (n <= 0) {
                            n = 360 * cell.zzxG().zzzx();
                            cell.zzxG().zzU(3010, n);
                        }
                        cell.zzxG().setPreferredWidth(PreferredWidth.zzDx(n));
                        compositeNode = cell;
                        cell = (Cell)compositeNode.zzZEv();
                    }
                    compositeNode = row;
                    row = (Row)compositeNode.zzZEv();
                }
                zzZE8.zzC(table);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown auto fit behavior.");
    }

    final int zzZi5() {
        if (this.getRows().getCount() == 0) {
            return 0;
        }
        int n = 0;
        for (Row row : this.getRows()) {
            int n2 = 0;
            for (Cell cell : row.getCells()) {
                n2 += cell.zzxG().getWidth();
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    final boolean zzZi4() {
        for (Row row : this.getRows()) {
            if (row.zz6E().hasRevisions()) {
                return true;
            }
            for (Cell cell : row.getCells()) {
                if (!cell.zzxG().hasRevisions()) continue;
                return true;
            }
        }
        return false;
    }

    final void zzAm(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            row.zz6E().remove(n);
            Row row2 = row;
            row = (Row)row2.zzZEv();
        }
    }

    final void zzw(int n, Object object) throws Exception {
        if (this.getFirstRow() == null) {
            throw new IllegalStateException("Formatting cannot be applied because the table is empty. Add at least one row to the table first.");
        }
        for (Row row = this.getFirstRow(); row != null; row = row.zzZtB()) {
            if (n == 4005) {
                Row row2 = row;
                Table table = this;
                Object object2 = row2.zz6E().get(4120);
                Object object3 = row2.zz6E().get(4240);
                Object object4 = row2.zz6E().get(4230);
                row2.getRowFormat().clearFormatting();
                table.zzAl(3060);
                if (object2 != null) {
                    row2.zz6E().zzU(4120, object2);
                }
                if (object3 != null) {
                    row2.zz6E().zzU(4240, object3);
                }
                if (object4 != null) {
                    row2.zz6E().zzU(4230, object4);
                }
            }
            row.zz6E().zzU(n, object);
        }
    }

    private void zzAl(int n) {
        Row row = this.getFirstRow();
        while (row != null) {
            CompositeNode compositeNode;
            Cell cell = row.getFirstCell();
            while (cell != null) {
                cell.zzxG().remove(n);
                compositeNode = cell;
                cell = (Cell)compositeNode.zzZEv();
            }
            compositeNode = row;
            row = (Row)compositeNode.zzZEv();
        }
    }

    private Object zzAk(int n) {
        Row row = this.getFirstRow();
        if (row == null) {
            return zzYVC.zzTB(n);
        }
        if (n == 4005) {
            if (row.zz6E() != null) {
                return row.zz6E().zzZVE();
            }
            return zzYVC.zzTB(4005);
        }
        return row.fetchRowAttr(n);
    }
}

