/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import asposewobfuscated.zz42;
import com.aspose.words.net.System.Data.Constraint;
import com.aspose.words.net.System.Data.ConstraintException;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import com.aspose.words.net.System.Data.ForeignKeyConstraint;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzU;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConstraintCollection
implements Iterable<Constraint> {
    private final List<Constraint> zzY0R;
    private final DataTable zzYRz;
    private final AtomicInteger zzY0Q;

    ConstraintCollection(DataTable table) {
        this.zzYRz = table;
        this.zzY0Q = new AtomicInteger(1);
        this.zzY0R = new ArrayList<Constraint>();
    }

    public Constraint get(String constraintName) {
        if (zz42.zzXa(constraintName)) {
            return null;
        }
        for (Constraint constraint : this.zzY0R) {
            if (!constraint.getConstraintName().equals(constraintName)) continue;
            return constraint;
        }
        return null;
    }

    public Constraint get(int idx) {
        return this.zzY0R.get(idx);
    }

    public void add(Constraint constraint) throws DataException, InvalidConstraintException {
        if (constraint == null) {
            return;
        }
        if (this == constraint.zzZdV()) {
            throw new IllegalArgumentException("Constraint already belongs to this collection.");
        }
        if (null != constraint.zzZdV()) {
            throw new IllegalArgumentException("Constraint already belongs to another collection.");
        }
        for (Constraint constraint2 : this) {
            if (!constraint2.equals(constraint)) continue;
            throw new DataException("Constraint matches contraint named '" + constraint2.getConstraintName() + "' already in collection");
        }
        if (this.zzZ(constraint.getConstraintName(), null)) {
            throw new DataException("Constraint name already exists.");
        }
        constraint.addToConstraintCollectionSetup(this);
        if (constraint.getConstraintName() == null || "".equals(constraint.getConstraintName())) {
            ConstraintCollection constraintCollection = this;
            constraint.setConstraintName("Constraint" + constraintCollection.zzY0Q.getAndIncrement());
        }
        constraint.zzZ(this);
        this.zzY0R.add(constraint);
        if (constraint instanceof UniqueConstraint && ((UniqueConstraint)constraint).isPrimaryKey()) {
            this.zzYRz.setPrimaryKey(((UniqueConstraint)constraint).getColumns());
        }
    }

    public void remove(Constraint constraint) {
        if (constraint == null) {
            return;
        }
        this.zzY0R.remove(constraint);
    }

    public boolean contains(Constraint cc) {
        if (cc != null) {
            return false;
        }
        return this.zzY0R.contains(cc);
    }

    public int getCount() {
        return this.zzY0R.size();
    }

    @Override
    public Iterator<Constraint> iterator() {
        return this.zzY0R.iterator();
    }

    final DataTable getTable() {
        return this.zzYRz;
    }

    final List<ForeignKeyConstraint> zzZdU() {
        ArrayList<ForeignKeyConstraint> arrayList = new ArrayList<ForeignKeyConstraint>();
        for (Constraint constraint : this.zzY0R) {
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            arrayList.add((ForeignKeyConstraint)constraint);
        }
        return arrayList;
    }

    final void zzZ(DataRow dataRow) throws ConstraintException, InvalidConstraintException {
        for (Constraint constraint : this.zzY0R) {
            if (constraint instanceof UniqueConstraint) {
                DataRow dataRow2 = dataRow;
                UniqueConstraint uniqueConstraint = (UniqueConstraint)constraint;
                ConstraintCollection constraintCollection = this;
                zzU zzU10 = constraintCollection.zzYRz.zzZdM().zzX(uniqueConstraint.getColumns());
                Map<String, Object> map = zzU10.zzV(dataRow2);
                if (map != null && !map.isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        stringBuilder.append(zz42.format("Column '{0}' is constrained to be unique.  Value '{1}' is already present.", entry.getKey(), entry.getValue()));
                    }
                    throw new ConstraintException(stringBuilder.toString());
                }
            }
            if (!(constraint instanceof ForeignKeyConstraint)) continue;
            this.zzZ((ForeignKeyConstraint)constraint, dataRow);
        }
    }

    private boolean zzZ(String string, Constraint constraint) {
        for (Constraint constraint2 : this.zzY0R) {
            if (constraint2.equals(null) || zz42.zzV(string, constraint2.getConstraintName(), false) != 0) continue;
            return true;
        }
        return false;
    }

    private void zzZ(ForeignKeyConstraint foreignKeyConstraint, DataRow dataRow) throws InvalidConstraintException {
        if (this.zzYRz.getDataSet() == null) {
            return;
        }
        DataRelationCollection dataRelationCollection = this.zzYRz.getDataSet().getRelations();
        if (dataRelationCollection.getCount() == 0) {
            return;
        }
        ConstraintCollection constraintCollection = this;
        if (foreignKeyConstraint.getRelatedTable().getTableName().equals(constraintCollection.zzYRz.getTableName())) {
            return;
        }
        constraintCollection = this;
        if (!foreignKeyConstraint.getTable().getTableName().equals(constraintCollection.zzYRz.getTableName())) {
            return;
        }
        DataTable dataTable = foreignKeyConstraint.getRelatedTable();
        if (!dataTable.zzZ(foreignKeyConstraint.getRelatedColumns(), foreignKeyConstraint.getColumns(), dataRow)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (DataColumn dataColumn : foreignKeyConstraint.getColumns()) {
                stringBuilder.append(zz42.format("ForeignKeyConstraint '{0}' requires the child key values ('{1}') to exist in the parent table.", foreignKeyConstraint.getConstraintName(), dataRow.get(dataColumn)));
            }
            throw new InvalidConstraintException(stringBuilder.toString());
        }
    }
}

