/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataTable;
import java.util.ArrayList;
import java.util.Iterator;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzY0I = new ArrayList();
    private DataTable zzYRz;

    DataColumnCollection(DataTable table) {
        this.zzYRz = table;
    }

    public void add(DataColumn column) {
        column.zzZ(this.zzYRz);
        column.setOrdinal(this.zzY0I.size());
        this.zzY0I.add(column);
        this.zzYRz.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        DataColumn dataColumn = new DataColumn(columnName, this.zzYRz);
        this.add(dataColumn);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzYRz);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        for (int i = 0; i < this.zzY0I.size(); ++i) {
            if (!this.zzY0I.get(i).getColumnName().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzY0I.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            this.zzYRz.onDataColumnDeleted(this.zzY0I.get(n));
            this.zzY0I.remove(n);
        }
    }

    public int getCount() {
        return this.zzY0I.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzY0I.iterator();
    }

    public void clear() {
        this.zzY0I.clear();
    }

    final DataColumn[] zzZdT() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>();
        Iterator<DataColumn> iterator = this.zzY0I.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }
}

