/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzT;
import com.aspose.words.net.System.Data.zzU;
import com.aspose.words.net.System.Data.zzV;
import com.aspose.words.net.System.Data.zzX;
import com.aspose.words.net.System.Data.zzY;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzY0h = new DataRowCollection(this);
    private final DataColumnCollection zzY0g = new DataColumnCollection(this);
    private final ConstraintCollection zzY0f = new ConstraintCollection(this);
    private final zzT zzY0e = new zzT(this);
    private ResultSet zzY0d;
    private String zzZi6;
    private DataSet zz8V;
    private String zzZ8F = "";
    private UniqueConstraint zzY0c;
    private boolean zzY0s = true;
    private final List<DataTableEventListener> zzY0b = new ArrayList<DataTableEventListener>();
    private final Set<DataRow> zzY0a = new HashSet<DataRow>();

    public DataTable() {
    }

    public DataTable(String tableName) {
        this.zzZi6 = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        this(resultSet, zzY.zzZ(resultSet));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzY0d = resultSet;
        this.zzZi6 = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzY0d != null) {
            if (this.zzY0d.getStatement() != null) {
                this.zzY0d.getStatement().getConnection().close();
            }
            this.zzY0d = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZi6;
    }

    public void setTableName(String tableName) {
        this.zzZi6 = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzY0g.getCount();
    }

    public String getColumnName(int index) {
        return this.zzY0g.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzY0d;
    }

    public DataSet getDataSet() {
        return this.zz8V;
    }

    final void zzZ(DataSet dataSet) {
        this.zz8V = dataSet;
    }

    public DataRowCollection getRows() {
        return this.zzY0h;
    }

    public DataColumnCollection getColumns() {
        return this.zzY0g;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzY0f;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzY0c == null) {
            return new DataColumn[0];
        }
        return this.zzY0c.getColumns();
    }

    final void zzU(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzY0c != null) {
                this.zzY0c.zzRh(false);
                this.getConstraints().remove(this.zzY0c);
                this.zzY0c = null;
            }
            return;
        }
        if (this.zzY0c != null && DataColumn.areColumnSetsTheSame(value, this.zzY0c.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzZ(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzY0c != null) {
            this.zzY0c.zzRh(false);
            this.getConstraints().remove(this.zzY0c);
            this.zzY0c = null;
        }
        UniqueConstraint.zzZ(this.getConstraints(), uniqueConstraint);
        this.zzY0c = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzZ8F;
    }

    public void setNamespace(String namespace) {
        this.zzZ8F = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzY0s;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzY0s = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzY0a.clear();
            this.getRows().clear();
            this.getColumns().clear();
            DataTable dataTable = this;
            ResultSet resultSet = this.getResultSet();
            for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                String string = resultSetMetaData.getColumnName(i);
                DataColumn dataColumn = new DataColumn(string, dataTable, i);
                dataColumn.setAllowDBNull(resultSetMetaData.isNullable(i) == 1);
                dataColumn.setAutoIncrement(resultSetMetaData.isAutoIncrement(i));
                dataColumn.setReadOnly(resultSetMetaData.isReadOnly(i));
                try {
                    dataColumn.setDataType(Class.forName(resultSetMetaData.getColumnClassName(i)));
                }
                catch (ClassNotFoundException classNotFoundException) {}
                dataTable.getColumns().add(dataColumn);
            }
            zzY.zzZ(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            sQLException.printStackTrace();
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzY.zzY(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzY0b.contains(listener)) {
            this.zzY0b.add(listener);
        }
    }

    public void removeEventListener(zzX listener) {
        if (this.zzY0b.contains(listener)) {
            this.zzY0b.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzY0b.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzY0a.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzY0b) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzY0a.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzY0b) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzY0a.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzY0b) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzY0b) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzY0b) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final boolean zzZ(DataColumn[] dataColumnArray, DataColumn[] dataColumnArray2, DataRow dataRow) {
        DataTable dataTable;
        DataRow dataRow2 = dataRow;
        DataColumn[] dataColumnArray3 = dataColumnArray2;
        DataColumn[] dataColumnArray4 = dataColumnArray;
        DataTable dataTable2 = dataTable = this;
        zzU zzU10 = dataTable.zzY0e.zzX(dataColumnArray4);
        return zzU10.zzyC(zzV.zzZ(dataColumnArray3, dataRow2));
    }

    final zzT zzZdM() {
        return this.zzY0e;
    }

    final Set<DataRow> zzZdL() {
        return this.zzY0a;
    }
}

