/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzYjG;
import com.aspose.words.internal.zzZWL;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzKX;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzKX zzXdP;

    BorderCollection(zzKX parent) {
        this.zzXdP = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzZWL.zzZR(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzYgu().equals(brColl.zzYgu()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzXdP.getPossibleBorderKeys().zzY10(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzXdP.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzXdP, borderKey);
            this.zzXdP.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzXdP.getPossibleBorderKeys().zzz8().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzXdP.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzXdP.getPossibleBorderKeys().zzz8().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWxn(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzXdP.getPossibleBorderKeys().zzz8().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWxn(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzYgu().zzYm2();
    }

    public final void setColor(Color value) throws Exception {
        this.zzym(zzYjG.zzY10(value));
    }

    private zzYjG zzYgu() throws Exception {
        return this.get(0).zzYgu();
    }

    private void zzym(zzYjG zzYjG2) throws Exception {
        Iterator iterator = this.zzXdP.getPossibleBorderKeys().zzz8().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWxn(n)) continue;
            this.getByBorderType(n).zzym(zzYjG2);
        }
    }

    final boolean zzm7(int n) {
        return this.zzXdP.getPossibleBorderKeys().zzZTa(n);
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzXdP.getPossibleBorderKeys().zzz8().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWxn(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzXdP.getPossibleBorderKeys().zzz8().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzWxn(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzY10(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzWxn(int n) {
        return n != 6 && n != 7;
    }

    static final class zzY10
    implements Iterator<Border> {
        private BorderCollection zzYkQ;
        private int zzVYu;

        zzY10(BorderCollection borderCollection) {
            this.zzYkQ = borderCollection;
            this.zzVYu = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzVYu >= this.zzYkQ.getCount() - 1) {
                return false;
            }
            ++this.zzVYu;
            return true;
        }

        private Border zzYzd() {
            try {
                return this.zzYkQ.get(this.zzVYu);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzYzd();
        }
    }
}

