/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzZWL;
import com.aspose.words.zzVU9;
import com.aspose.words.zzWBf;
import com.aspose.words.zzWhl;
import com.aspose.words.zzYc5;
import com.aspose.words.zzYs4;
import com.aspose.words.zzZ90;
import com.aspose.words.zzZT2;
import com.aspose.words.zzZZ;
import com.aspose.words.zzaz;
import com.aspose.words.zzwB;

public class Cell
extends CompositeNode<Node>
implements zzYs4,
zzaz {
    private zzwB zzZ0m;
    private CellFormat zzWwA;
    private ParagraphCollection zzYxH;
    private TableCollection zzWmh;

    public Cell(DocumentBase doc) {
        this(doc, new zzwB());
    }

    Cell(DocumentBase doc, zzwB cellPr) {
        super(doc);
        this.zzZ0m = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    public Cell getNextCell() {
        return (Cell)this.zzYCz();
    }

    public Cell getPreviousCell() {
        return (Cell)this.zzIL();
    }

    public Row getParentRow() {
        return (Row)this.zzYNn();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzYfT() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzWJU(this, true);
        }
        return -1;
    }

    final int zzYpW() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzYpW();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzWwA == null) {
            this.zzWwA = new CellFormat(this);
        }
        return this.zzWwA;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzYxH == null) {
            this.zzYxH = new ParagraphCollection(this);
        }
        return this.zzYxH;
    }

    public TableCollection getTables() {
        if (this.zzWmh == null) {
            this.zzWmh = new TableCollection(this);
        }
        return this.zzWmh;
    }

    final zzwB zzXFQ() {
        return this.zzZ0m;
    }

    final void zzY10(zzwB zzwB2) {
        this.zzZ0m = zzwB2;
    }

    @Override
    final Node zzY10(boolean bl, zzYc5 zzYc52) {
        zzwB zzwB2;
        Cell cell = (Cell)super.zzY10(bl, zzYc52);
        zzwB zzwB3 = this.zzZ0m;
        cell.zzZ0m = zzwB2 = (zzwB)zzwB3.zzZly();
        cell.zzWwA = null;
        cell.zzYxH = null;
        cell.zzWmh = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzZT2.zzFh(this);
    }

    @Override
    final boolean zzY1d(Node node) {
        return zzVU9.zzW9q(node);
    }

    final int zzYd() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        for (Cell cell = row.getFirstCell(); cell != null; cell = cell.getNextCell()) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell != this) continue;
            return n;
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzZ0m.zzXlA(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzZ0m.zzXlA(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzWhl zzWhl2 = zzZWL.zzY10(object, zzWhl.class);
        if (zzWhl2 != null && zzWhl2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzYpX(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzwB.zzYV6(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzZ0m.zzXtS(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzZ0m.clear();
    }

    private Object zzYpX(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzZWL.zzY10((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzY10(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ90 getInsertRevision() {
        Cell cell = this;
        return cell.zzZ0m.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzZ90 value) {
        Cloneable cloneable = this;
        zzZ90 zzZ902 = value;
        cloneable = cloneable.zzZ0m;
        ((zzZZ)cloneable).zzXtS(14, zzZ902);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ90 getDeleteRevision() {
        Cell cell = this;
        return cell.zzZ0m.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzZ90 value) {
        Cloneable cloneable = this;
        zzZ90 zzZ902 = value;
        cloneable = cloneable.zzZ0m;
        ((zzZZ)cloneable).zzXtS(12, zzZ902);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWBf getMoveFromRevision() {
        Cell cell = this;
        return cell.zzZ0m.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzWBf value) {
        Cloneable cloneable = this;
        zzWBf zzWBf2 = value;
        cloneable = cloneable.zzZ0m;
        ((zzZZ)cloneable).zzXtS(13, zzWBf2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzWBf getMoveToRevision() {
        Cell cell = this;
        return cell.zzZ0m.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzWBf value) {
        Cloneable cloneable = this;
        zzWBf zzWBf2 = value;
        cloneable = cloneable.zzZ0m;
        ((zzZZ)cloneable).zzXtS(15, zzWBf2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzZ0m.remove(13);
        cell = this;
        cell.zzZ0m.remove(15);
    }

    final zzwB zzZzk(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzwB zzwB2 = new zzwB();
        this.zzY10(3120, zzwB2);
        this.zzY10(3140, zzwB2);
        this.zzY10(3110, zzwB2);
        this.zzY10(3130, zzwB2);
        this.zzY10(3090, zzwB2);
        this.zzY10(3100, zzwB2);
        this.zzY10(3070, zzwB2);
        this.zzY10(3080, zzwB2);
        if (bl && (tableStyle = zzZWL.zzY10((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzWaY(this, zzwB2);
        }
        this.zzZ0m.zzWaY((zzZZ)zzwB2);
        return zzwB2;
    }

    private void zzY10(int n, zzwB zzwB2) {
        zzwB2.zzXtS(n, this.fetchInheritedCellAttr(n));
    }
}

