/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ChartDataPointCollection;
import com.aspose.words.ChartMarker;
import com.aspose.words.ChartSeries;
import com.aspose.words.internal.zzX6C;
import com.aspose.words.zzVo;
import com.aspose.words.zzXWG;
import com.aspose.words.zzXoW;
import com.aspose.words.zzXp3;
import com.aspose.words.zzYkq;
import com.aspose.words.zzZ1u;
import com.aspose.words.zzZGJ;
import com.aspose.words.zzZGU;
import com.aspose.words.zzZh6;
import com.aspose.words.zzZls;
import com.aspose.words.zzvJ;
import java.util.Date;
import java.util.Iterator;

public class ChartSeriesCollection
implements Iterable<ChartSeries> {
    private zzZ1u zzZAm;

    ChartSeriesCollection(zzZ1u chartSpace) {
        this.zzZAm = chartSpace;
    }

    public ChartSeries get(int index) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZdW().zzVS5().get(index);
    }

    @Override
    public Iterator<ChartSeries> iterator() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZdW().zzVS5().iterator();
    }

    public void removeAt(int index) {
        this.zzZdW().zzZmz(index);
    }

    public void clear() {
        this.zzZdW().zzYVZ();
        for (zzXoW zzXoW2 : this.zzZAm.zzWP9()) {
            zzXoW2.zzYmg(false);
        }
    }

    public ChartSeries add(String seriesName, String[] categories, double[] values) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzY10(chartSeriesCollection.zzZdW().zzY5k(), seriesName, categories, values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzY10(chartSeriesCollection.zzZdW().zzY5k(), seriesName, xValues, yValues);
    }

    private ChartSeries zzY10(String string, zzX6C[] zzX6CArray, double[] dArray) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzY10(chartSeriesCollection.zzZdW().zzY5k(), string, zzX6CArray, dArray);
    }

    public ChartSeries add(String seriesName, Date[] dates, double[] values) {
        return this.zzY10(seriesName, zzX6C.zzY10(dates), values);
    }

    public ChartSeries add(String seriesName, double[] xValues, double[] yValues, double[] bubbleSizes) {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzY10(chartSeriesCollection.zzZdW().zzY5k(), seriesName, xValues, yValues, bubbleSizes);
    }

    final ChartSeries zzY10(zzXoW zzXoW2, String string, String[] stringArray, double[] dArray) {
        if (stringArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (stringArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (stringArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzY10(zzXoW2, string, dArray);
        chartSeries.zzWUU().zzXGj(ChartSeriesCollection.zzZDL(stringArray));
        return chartSeries;
    }

    final ChartSeries zzY10(zzXoW zzXoW2, String string, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzY10(zzXoW2, string, dArray2);
        chartSeries.zzWUU().zzXGj(ChartSeriesCollection.zzY1d(dArray));
        return chartSeries;
    }

    private ChartSeries zzY10(zzXoW zzXoW2, String string, zzX6C[] zzX6CArray, double[] dArray) {
        if (zzX6CArray == null || dArray == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (zzX6CArray.length <= 0 || dArray.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (zzX6CArray.length != dArray.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        ChartSeries chartSeries = this.zzY10(zzXoW2, string, dArray);
        chartSeries.zzWUU().zzXGj(ChartSeriesCollection.zzY10(zzX6CArray));
        if (!zzXoW2.zzYL()) {
            zzXoW2.zzYmg(true);
        }
        return chartSeries;
    }

    final ChartSeries zzY10(zzXoW zzXoW2, String string, double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null) {
            throw new IllegalArgumentException("Data arrays must not be null.");
        }
        if (dArray.length <= 0 || dArray2.length <= 0) {
            throw new IllegalArgumentException("Data arrays must not be empty.");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Data arrays must be of the same size.");
        }
        if (zzXoW2.zzYYk() != 15) {
            zzXoW2.zzWOB(1, "Please make sure you are using correct chart type. There is no way to set bubble size for non-bubble chart.");
        }
        ChartSeries chartSeries = this.zzY10(zzXoW2, string, dArray2);
        chartSeries.zzWt2().zzY1s().zzZR(3, chartSeries.zzWS2().zz8W());
        chartSeries.zzWUU().zzXGj(ChartSeriesCollection.zzY1d(dArray));
        if (dArray3 != null) {
            chartSeries.zzYma().zzXGj(ChartSeriesCollection.zzY1d(dArray3));
        }
        return chartSeries;
    }

    private ChartSeries zzY10(zzXoW zzXoW2, String string, double[] dArray) {
        ChartSeries chartSeries = new ChartSeries(zzXoW2);
        chartSeries.setName(string);
        ChartSeriesCollection.zzZKQ(chartSeries);
        chartSeries.zzWRV().zzXGj(ChartSeriesCollection.zzY1d(dArray));
        this.zzZAm.zzQi();
        this.zzZdW().zzXFv(chartSeries);
        return chartSeries;
    }

    private static void zzZKQ(ChartSeries chartSeries) {
        chartSeries.zzWt2().zzY1s().zzZR(5, new zzXWG());
        if (ChartDataPointCollection.zzWb8(chartSeries.zzWS2().zzYYk())) {
            chartSeries.setInvertIfNegative(false);
        }
        switch (chartSeries.zzWS2().zzYYk()) {
            case 2: 
            case 5: {
                ChartSeriesCollection.zzY10(chartSeries, 5);
                return;
            }
            case 4: {
                ChartSeriesCollection.zzY10(chartSeries, 5);
                ChartSeriesCollection.zzXb7(chartSeries);
                return;
            }
            case 6: {
                ChartSeriesCollection.zzY10(chartSeries, 1);
                ChartSeriesCollection.zzXb7(chartSeries);
                return;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                ChartSeriesCollection.zzXtS(chartSeries);
            }
        }
    }

    private static void zzXtS(ChartSeries chartSeries) {
        zzXWG zzXWG2 = new zzXWG();
        zzXWG2.setOutline(new zzZls());
        zzZGJ zzZGJ2 = new zzZGJ();
        zzZGJ2.zzYtr(1);
        zzXWG2.getOutline().setFill(new zzYkq(zzZGJ2));
        zzXWG2.getOutline().zzWXe(19050.0);
        chartSeries.zzWt2().zzY1s().zzZR(5, zzXWG2);
    }

    private static void zzXb7(ChartSeries chartSeries) {
        zzXWG zzXWG2 = new zzXWG();
        zzXWG2.setOutline(new zzZls());
        zzXWG2.getOutline().setFill(new zzXp3());
        zzXWG2.getOutline().setEndCap(0);
        zzXWG2.getOutline().zzWXe(19050.0);
        chartSeries.zzWt2().zzY1s().zzZR(5, zzXWG2);
    }

    private static void zzY10(ChartSeries chartSeries, int n) {
        ChartMarker chartMarker = new ChartMarker(chartSeries.zzWS2());
        chartMarker.zzXrm().zzZR(0, n);
        chartSeries.zzWt2().zzY1s().zzZR(4, chartMarker);
    }

    private static zzZh6 zzY1d(double[] dArray) {
        int n = 0;
        zzZh6 zzZh62 = new zzZh6(2);
        double[] dArray2 = dArray;
        int n2 = dArray.length;
        for (int i = 0; i < n2; ++i) {
            double d = dArray2[i];
            if (!Double.isNaN(d)) {
                zzZh62.zzYVl(new zzVo(n, d, "General"));
            }
            ++n;
        }
        zzZh62.zzWmY(dArray.length);
        return zzZh62;
    }

    private static zzZh6 zzY10(zzX6C[] zzX6CArray) {
        int n = 0;
        zzZh6 zzZh62 = new zzZh6(2);
        zzX6C[] zzX6CArray2 = zzX6CArray;
        int n2 = zzX6CArray.length;
        for (int i = 0; i < n2; ++i) {
            zzX6C zzX6C2 = zzX6CArray2[i];
            zzZh62.zzYVl(new zzVo(n++, zzX6C2.zzXiZ(), "m/d/yyyy"));
        }
        zzZh62.zzWmY(zzX6CArray.length);
        return zzZh62;
    }

    private static zzZh6 zzZDL(String[] stringArray) {
        int n = 0;
        zzZh6 zzZh62 = new zzZh6(1);
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray2[i];
            zzZh62.zzYVl(new zzZGU(n++, string));
        }
        zzZh62.zzWmY(stringArray.length);
        return zzZh62;
    }

    public int getCount() {
        ChartSeriesCollection chartSeriesCollection = this;
        return chartSeriesCollection.zzZdW().zzVS5().size();
    }

    private zzvJ zzZdW() {
        return this.zzZAm.zzEp().zzZdW();
    }
}

