/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzWeK;
import com.aspose.words.internal.zzX6C;
import com.aspose.words.internal.zzZWL;
import com.aspose.words.zzWBf;
import com.aspose.words.zzWXe;
import com.aspose.words.zzXf6;
import com.aspose.words.zzYhr;
import com.aspose.words.zzYqX;
import com.aspose.words.zzo;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzYhr,
zzYqX {
    private int zz9Z;
    private boolean zzY33;
    private boolean zzWsM;
    private int zzWQw;
    private int zzWrt = -1;
    private String zzXy0 = "";
    private String zzXBt = "";
    private zzX6C zzZDF = zzX6C.zzXF;
    private zzX6C zzXbN = zzX6C.zzXF;
    private CommentCollection zzYds;

    Comment(DocumentBase doc, zzXf6 runPr) {
        super(doc, runPr);
        this.zzWQw = doc.zzVZj();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzX6C.zzXF);
    }

    private Comment(DocumentBase doc, String author, String initial, zzX6C dateTime) {
        this(doc, new zzXf6());
        this.setAuthor(author);
        this.setInitial(initial);
        zzX6C zzX6C2 = dateTime;
        Comment comment = this;
        this.zzZDF = zzX6C2;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzX6C.zzY10(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzWQw;
    }

    public final void setId(int value) {
        this.zzWQw = value;
        if (this.getDocument() != null) {
            this.getDocument().zzkv();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.getId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.setId(value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        return this.getParentId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.setParentId(value);
    }

    public final String getInitial() {
        return this.zzXy0;
    }

    public final void setInitial(String value) {
        zzZWL.zzWaY((Object)value, "Initial");
        this.zzXy0 = value;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzX6C.zzZR(comment.zzZDF);
    }

    private void zzYU(zzX6C zzX6C2) {
        this.zzZDF = zzX6C2;
        if (!zzX6C.zzY10(this.zzXbN, zzX6C.zzXF)) {
            this.zzXbN = !zzX6C.zzY10(zzX6C2, zzX6C.zzXF) ? zzX6C2.zzU7() : zzX6C.zzXF;
        }
    }

    public final void setDateTime(Date value) {
        this.zzYU(zzX6C.zzY10(value));
    }

    final zzX6C zzXKC() {
        return this.zzZDF;
    }

    final void zzfY(zzX6C zzX6C2) {
        this.zzZDF = zzX6C2;
    }

    final zzX6C zzWC2() {
        return this.zzXbN;
    }

    final void zzZZ(zzX6C zzX6C2) {
        this.zzXbN = zzX6C2;
    }

    public final String getAuthor() {
        return this.zzXBt;
    }

    public final void setAuthor(String value) {
        zzZWL.zzWaY((Object)value, "Author");
        this.zzXBt = value;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzY10(String string, String string2, zzX6C zzX6C2, String string3) throws Exception {
        if (this.getParentId() != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment = new Comment(this.getDocument(), string, string2, zzX6C2);
        comment.setIdInternal(zzWXe.zzY10(this.getDocument()));
        comment.setParentId(this.zzWQw);
        comment.setText(string3);
        Comment comment2 = this;
        Comment comment3 = zzZWL.zzY10((Object)this.zzYJK(), Comment.class);
        while (comment3 != null && comment3.getParentId() == this.zzWQw) {
            comment2 = comment3;
            comment3 = zzZWL.zzY10((Object)comment3.zzYJK(), Comment.class);
        }
        this.getParentNode().insertAfter(comment, comment2);
        zzo zzo2 = new zzo();
        if (zzo2.zzWaY(this.getDocument(), this.zzWQw)) {
            this.zzY10(zzo2.zzXFa(), new CommentRangeStart(this.getDocument(), comment.getId()));
            this.zzY10(zzo2.zzZJ1(), new CommentRangeEnd(this.getDocument(), comment.getId()));
        }
        return comment;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzY10(author, initial, zzX6C.zzY10(dateTime), text);
    }

    private void zzY10(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzWeK.zzY10(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).getParentNode().insertAfter(commentRangeStart2, (Node)object);
    }

    private void zzY10(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzWeK.zzY10(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzWQw) break;
            object = node;
        }
        ((Node)object).getParentNode().insertAfter(commentRangeEnd2, (Node)object);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzo zzo2 = new zzo();
        if (zzo2.zzWaY(this.getDocument(), reply.getId())) {
            zzo2.zzXFa().remove();
            zzo2.zzZJ1().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzX69()) {
            this.removeReply(comment);
        }
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzW2q());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzW2q(), '\u0005', new zzXf6());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        if (this.getDocument() == null || this.getParentId() == -1) {
            return null;
        }
        for (Comment comment : this.getDocument().getChildNodes(19, true)) {
            if (comment.getId() != this.getParentId()) continue;
            return comment;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzYds == null) {
            this.zzYds = new CommentCollection(this.getDocument(), this);
        }
        return this.zzYds;
    }

    public final boolean getDone() {
        return this.zzWsM;
    }

    public final void setDone(boolean value) {
        this.zzWsM = value;
    }

    public final int getParentId() {
        return this.zzWrt;
    }

    public final void setParentId(int value) {
        this.zzWrt = value;
        if (this.getDocument() != null) {
            this.getDocument().zzkv();
        }
    }

    final int zzXbF() {
        return this.zz9Z;
    }

    final void zzXdv(int n) {
        this.zz9Z = n;
    }

    final boolean zzWtx() {
        return this.zzY33;
    }

    final void zzo(boolean bl) {
        this.zzY33 = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzWBf getMoveFromRevision() {
        return this.zzZ4q().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzWBf value) {
        zzWBf zzWBf2 = value;
        zzXf6 zzXf62 = this.zzZ4q();
        zzXf62.zzXtS(13, zzWBf2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzWBf getMoveToRevision() {
        return this.zzZ4q().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzWBf value) {
        zzWBf zzWBf2 = value;
        zzXf6 zzXf62 = this.zzZ4q();
        zzXf62.zzXtS(15, zzWBf2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzZ4q().remove(13);
        this.zzZ4q().remove(15);
    }

    final String zzWWg() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWI7(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

