/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzZWL;
import com.aspose.words.zzVU9;
import com.aspose.words.zzW4g;
import com.aspose.words.zzWZg;
import com.aspose.words.zzXnL;
import com.aspose.words.zzXtF;
import com.aspose.words.zzYVf;
import com.aspose.words.zzYaG;
import com.aspose.words.zzYc5;
import com.aspose.words.zzhh;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzhh,
Iterable<V> {
    private Node zzXbh;
    private Node zzYpO;
    private Node zzWlE;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzWZg zzWZg2 = new zzWZg(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzWk(this, true);
            return;
        }
        finally {
            zzWZg2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzYnp() {
        return this.zzz0() != null;
    }

    final boolean zzXL() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzZsI() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzYaG) {
                return true;
            }
            CompositeNode compositeNode = zzZWL.zzY10((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzZsI()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzXbh;
    }

    public Node getLastChild() {
        return this.zzYpO;
    }

    final Node zzz0() {
        return zzVU9.zzYVl(this.getFirstChild(), false);
    }

    final Node zzXZS() {
        return zzVU9.zzZKQ(this.getLastChild(), false);
    }

    final CompositeNode zzZb2() {
        return (CompositeNode)zzVU9.zzYVl(this.getFirstChild(), true);
    }

    final CompositeNode zzXKj() {
        return (CompositeNode)zzVU9.zzZKQ(this.getLastChild(), true);
    }

    final Node zzYpJ() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzVU9.zzp8((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzdu() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzVU9.zzp8((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzY10(boolean bl, zzYc5 zzYc52) {
        CompositeNode compositeNode = (CompositeNode)super.zzY10(bl, zzYc52);
        ((CompositeNode)super.zzY10(bl, zzYc52)).zzYpO = null;
        compositeNode.zzXbh = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzFh(node.zzY10(true, zzYc52));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWI7(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzWI7(StringBuilder stringBuilder) {
        this.zzXFv(stringBuilder);
        zzZWL.zzWaY(stringBuilder, this.zzZVO());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzWaY(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzVU9.zzYci(nodeType);
            Node node2 = node = bl ? this.zzz0() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzW7I() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzXnL.zzWk(this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzXnL.zzWJU(this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzXtF(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzY10(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzY10(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzWk(oldChild, false);
    }

    private <T extends Node> T zzWk(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = CompositeNode.zzY10(documentBase, t, this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzWYB() && zzVU9.zzX1h(t)) {
            return t;
        }
        CompositeNode.zzY10(documentBase, nodeChangingArgs);
        if (!bl && zzVU9.zzXoa(t)) {
            zzVU9.zzXb7(t, false);
        }
        T t2 = this.zzWK6(t);
        CompositeNode.zzWaY(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzYVf.zzw0(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzFh(Node node) {
        node.getParentNode();
        if (this.zzYpO == null) {
            node.zzXTv(null);
            node.zzX5l(null);
            this.zzXbh = node;
        } else {
            node.zzXTv(this.zzYpO);
            node.zzX5l(null);
            this.zzYpO.zzX5l(node);
        }
        this.zzYpO = node;
        node.zzZLA(this);
        return node;
    }

    final void zzY10(Node node, Node node2, Node node3) {
        this.zzY10(node, node2, node3, false);
    }

    final void zzY10(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzY1d(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzWaY(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzWJU(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzVU9.zzp8(node3.getNodeType())) continue;
            if (zzVU9.zzY1d(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzZVO().length();
    }

    String zzZVO() {
        return "";
    }

    final String zzX8V() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXFv(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzXFv(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzWI7(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzY1d(Node node) {
        return true;
    }

    private static NodeChangingArgs zzY10(DocumentBase documentBase, Node node, Node node2, Node node3, int n) {
        return documentBase.zzY10(node, node2, node3, n);
    }

    private static void zzY10(DocumentBase documentBase, NodeChangingArgs nodeChangingArgs) {
        if (nodeChangingArgs != null) {
            documentBase.zzY10(nodeChangingArgs);
        }
    }

    private static void zzWaY(DocumentBase documentBase, NodeChangingArgs nodeChangingArgs) {
        if (nodeChangingArgs != null) {
            documentBase.zzWaY(nodeChangingArgs);
        }
    }

    final <T extends Node> T zzY10(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzYWC(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        if (documentBase2 != documentBase) {
            throw new IllegalArgumentException("The newChild was created from a different document than the one that created this node.");
        }
        if (t.getNodeType() != 37 && !this.zzY1d(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzW4g(documentBase);
            try {
                compositeNode.zzWk(t, true);
            }
            finally {
                ((zzW4g)object).dispose();
            }
        }
        object = CompositeNode.zzY10(documentBase, t, null, this, 0);
        CompositeNode.zzY10(documentBase, (NodeChangingArgs)object);
        if (this.zzYpO == null) {
            t.zzXTv(null);
            t.zzX5l(null);
            this.zzXbh = t;
            this.zzYpO = t;
        } else if (bl) {
            if (node != null) {
                this.zzWaY(t, node);
            } else {
                this.zzWk(t, this.zzXbh);
            }
        } else if (node != null) {
            this.zzWk(t, node);
        } else {
            this.zzWaY(t, this.zzYpO);
        }
        t.zzZLA(this);
        CompositeNode.zzWaY(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzWYB()) {
            zzVU9.zzY10(t, compositeNode, node2);
        }
        return t;
    }

    private void zzWaY(Node node, Node node2) {
        Node node3 = node2.zzXeN();
        node.zzXTv(node2);
        node.zzX5l(node3);
        node2.zzX5l(node);
        if (node3 == null) {
            this.zzYpO = node;
            return;
        }
        node3.zzXTv(node);
    }

    private void zzWk(Node node, Node node2) {
        Node node3 = node2.zzZy();
        node.zzXTv(node3);
        node.zzX5l(node2);
        node2.zzXTv(node);
        if (node3 == null) {
            this.zzXbh = node;
            return;
        }
        node3.zzX5l(node);
    }

    private <T extends Node> T zzWK6(T t) {
        if (t == this.zzXbh) {
            if (this.zzXbh == this.zzYpO) {
                this.zzXbh = null;
                this.zzYpO = null;
            } else {
                this.zzXbh = t.zzXeN();
                this.zzXbh.zzXTv(null);
            }
        } else {
            Node node = t.zzZy();
            Node node2 = t.zzXeN();
            node.zzX5l(node2);
            if (node2 == null) {
                this.zzYpO = node;
            } else {
                node2.zzXTv(node);
            }
        }
        t.zzX5l(null);
        t.zzXTv(null);
        t.zzZLA(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzWlE = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzWlE;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

