/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zzCJ;
import com.aspose.words.internal.zzVS8;
import com.aspose.words.internal.zzWbd;
import com.aspose.words.internal.zzWsb;
import com.aspose.words.internal.zzXNU;
import com.aspose.words.internal.zzXq2;
import com.aspose.words.internal.zzYdD;
import com.aspose.words.internal.zzZWL;
import com.aspose.words.internal.zzZZR;
import com.aspose.words.internal.zzZo7;
import com.aspose.words.internal.zzZv5;
import com.aspose.words.internal.zzoj;
import com.aspose.words.zzR;
import com.aspose.words.zzVVC;
import com.aspose.words.zzWBz;
import com.aspose.words.zzWae;
import com.aspose.words.zzWrD;
import com.aspose.words.zzX7Z;
import com.aspose.words.zzXri;
import com.aspose.words.zzYO6;
import com.aspose.words.zzYqr;
import com.aspose.words.zzZrZ;
import com.aspose.words.zzeD;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private DigitalSignatureUtil() {
    }

    private static void zzY10(zzZZR zzZZR2, zzZZR zzZZR3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzZWL.zzWaY((Object)zzZZR2, "srcStream");
        zzZWL.zzWaY((Object)zzZZR3, "dstStream");
        zzZWL.zzWaY((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzWaY(zzZZR2, zzZZR3, certificateHolder, signOptions);
        zzZZR3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzY10(zzZZR.zzWaY(srcStream), (zzZZR)zzZZR.zzWk(dstStream), certHolder, signOptions);
    }

    private static void zzWaY(zzZZR zzZZR2, zzZZR zzZZR3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzWk(digitalSignature);
        }
        if (zzWae.zzX6G(zzZZR2)) {
            DigitalSignatureUtil.zzY10(zzZZR2, zzZZR3, digitalSignature, true);
            return;
        }
        zzWae zzWae2 = new zzWae();
        zzZZR zzZZR4 = zzZZR2;
        zzWae zzWae3 = zzWae2;
        FileFormatInfo fileFormatInfo = zzWae2.zzWaY(zzZZR4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYdD zzYdD2 = new zzYdD(zzZZR2);
                int n = fileFormatInfo.zzVYG() == 1 ? 1 : 2;
                zzZrZ.zzY10(zzYdD2, digitalSignature, n);
                zzZZR3.zzWK6(0L);
                zzYdD2.zzXFv(zzZZR3);
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzY10(fileFormatInfo.zzZAc(), zzZZR3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzY10(zzZZR2, zzZZR3, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzY10(zzZZR2, zzZZR3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzZWL.zzWk(srcFileName, "srcFileName");
        zzZWL.zzWk(dstFileName, "dstFileName");
        try (zzXNU zzXNU2 = zzZWL.zzWaY(srcFileName, 3, 1);){
            try (zzXNU zzXNU3 = zzZWL.zzWaY(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzY10((zzZZR)zzXNU2, (zzZZR)zzXNU3, certHolder, signOptions);
            }
            return;
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzZo7 zzZo72 = zzZZR.zzWk(dstStream);
        zzZZR zzZZR2 = zzZZR.zzWaY(srcStream);
        DigitalSignatureUtil.zzY10(zzZZR2, (zzZZR)zzZo72, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        try (zzXNU zzXNU2 = zzZWL.zzWaY(srcFileName, 3, 1);){
            try (zzXNU zzXNU3 = zzZWL.zzWaY(dstFileName, 4, 2);){
                DigitalSignatureUtil.zzXGj(zzXNU2, zzXNU3);
            }
            return;
        }
    }

    private static void zzXGj(zzZZR zzZZR2, zzZZR zzZZR3) throws Exception {
        zzWae zzWae2 = new zzWae();
        zzZZR zzZZR4 = zzZZR2;
        Object object = zzWae2;
        FileFormatInfo fileFormatInfo = zzWae2.zzWaY(zzZZR4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzYdD zzYdD2 = new zzYdD(zzZZR2);
                zzYdD2.zzWVS().zzZWC("_xmlsignatures");
                zzYdD2.zzWVS().zzZWC("_signatures");
                zzZZR3.zzXEd(0L);
                zzYdD2.zzXFv(zzZZR3);
                zzZZR zzZZR5 = zzZZR3;
                zzZZR5.zzWK6(zzZZR5.zz5L());
                return;
            }
            case 20: 
            case 21: 
            case 22: {
                zzWbd zzWbd2 = new zzWbd(zzZZR2);
                zzVS8 zzVS82 = zzWbd2.zzY10(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zzVS82 != null) {
                    for (zzXq2 zzXq22 : zzVS82.zzqZ()) {
                        String string = zzVS82.zzY10(zzXq22);
                        zzWbd2.zzWME().remove(string);
                    }
                    zzWbd2.zzWME().remove(zzVS82.getName());
                    zzXq2 zzXq23 = zzWbd2.zzqZ().zzhX("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzWbd2.zzqZ().remove(zzXq23.getId());
                    zzWbd2.zzXjw();
                }
                zzZZR3.zzXEd(0L);
                zzWbd2.zzXFv(zzZZR3);
                zzZZR zzZZR6 = zzZZR3;
                zzZZR6.zzWK6(zzZZR6.zz5L());
                return;
            }
            case 60: 
            case 61: {
                zzVVC zzVVC2 = new zzVVC(zzZZR2);
                zzWrD zzWrD2 = zzVVC2.zzZjD("/META-INF/documentsignatures.xml");
                if (zzWrD2 != null) {
                    zzVVC2.zzZ69().remove(zzWrD2.getName());
                }
                zzZZR3.zzXEd(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzZZR4 = zzZZR3;
                object = zzVVC2;
                ((zzVVC)object).zzY10(zzZZR4, string, null);
                zzZZR zzZZR7 = zzZZR3;
                zzZZR7.zzWK6(zzZZR7.zz5L());
                return;
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzXGj(zzZZR.zzWaY(srcStream), zzZZR.zzWk(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        try (zzXNU zzXNU2 = zzZWL.zzWaY(fileName, 3, 1);){
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzXaE(zzXNU2);
            return digitalSignatureCollection;
        }
    }

    private static DigitalSignatureCollection zzXaE(zzZZR zzZZR2) throws Exception {
        if (zzWae.zzX6G(zzZZR2)) {
            return DigitalSignatureUtil.zzXQE(zzZZR2);
        }
        zzWae zzWae2 = new zzWae();
        zzZZR zzZZR3 = zzZZR2;
        zzWae zzWae3 = zzWae2;
        FileFormatInfo fileFormatInfo = zzWae2.zzWaY(zzZZR3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 60: {
                Document document = new Document(zzZZR2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException("Signing feature is not supported by this file format.");
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzXaE(zzZZR.zzWaY(stream));
    }

    static zzZv5 zzY10(zzYdD zzYdD2, String string) throws Exception {
        zzYO6 zzYO62 = new zzYO6(zzYdD2);
        if (zzYO62.zzVU7()) {
            zzZv5 zzZv52 = zzYO62.zzYO6(string);
            return zzZv52;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzKO(int n) {
        switch (n) {
            case 1: {
                return "http://www.w3.org/2000/09/xmldsig#sha1";
            }
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        throw new IllegalStateException(zzCJ.zzWaY("Unexpected digest algorithm: {0}.", n));
    }

    static String zzWOj(byte by) {
        int n = by == 2 ? 3 : 1;
        return DigitalSignatureUtil.zzKO(n);
    }

    private static void zzY10(zzZZR zzZZR2, zzZZR zzZZR3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzWbd zzWbd2 = new zzWbd(zzZZR2);
        zzWBz zzWBz2 = bl ? new zzYqr(zzWbd2) : new zzeD(zzWbd2);
        zzWBz2.zzWaY(digitalSignature);
        zzZZR3.zzWK6(0L);
        zzWbd2.zzXFv(zzZZR3);
    }

    private static void zzY10(zzZZR zzZZR2, zzZZR zzZZR3, DigitalSignature digitalSignature) throws Exception {
        zzVVC zzVVC2 = new zzVVC(zzZZR2);
        zzXri zzXri2 = new zzXri(zzVVC2);
        zzXri2.zzWaY(digitalSignature);
        zzZZR3.zzWK6(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzZZR zzZZR4 = zzZZR3;
        zzVVC zzVVC3 = zzVVC2;
        zzVVC3.zzY10(zzZZR4, string, null);
    }

    private static void zzY10(zzYdD zzYdD2, zzZZR zzZZR2, DigitalSignature digitalSignature, String string) throws Exception {
        zzZv5 zzZv52 = DigitalSignatureUtil.zzY10(zzYdD2, string);
        zzZv5 zzZv53 = new zzZv5();
        DigitalSignatureUtil.zzY10((zzZZR)zzZv52, (zzZZR)zzZv53, digitalSignature, false);
        zzYdD zzYdD3 = zzYO6.zzXGj(zzZv53, string);
        zzYdD3.zzXFv(zzZZR2);
    }

    private static DigitalSignatureCollection zzXQE(zzZZR zzZZR2) throws Exception {
        zzZZR2.zzXEd(0L);
        zzWbd zzWbd2 = new zzWbd(zzZZR2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zzVS8 zzVS82 = zzWbd2.zzY10(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zzVS82 != null) {
            for (zzXq2 zzXq22 : zzVS82.zzqZ()) {
                String string = zzVS82.zzY10(zzXq22);
                zzVS8 zzVS83 = zzWbd2.zzEC(string);
                zzVS8 zzVS84 = zzWbd2.zzY10(zzVS83, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzoj zzoj2 = zzWsb.zzXNx(zzVS84.zzNa().zzVW0());
                zzX7Z.zzY10(zzVS83.zzeU(), zzoj2, new zzR(zzWbd2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }
}

