/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.Bookmark;
import com.aspose.words.BookmarkEnd;
import com.aspose.words.BookmarkStart;
import com.aspose.words.Border;
import com.aspose.words.Cell;
import com.aspose.words.CellFormat;
import com.aspose.words.CompatibilityOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.ConvertUtil;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.EditableRangeEnd;
import com.aspose.words.EditableRangeStart;
import com.aspose.words.Field;
import com.aspose.words.FieldEnd;
import com.aspose.words.FieldMergeField;
import com.aspose.words.FieldSeparator;
import com.aspose.words.FieldStart;
import com.aspose.words.Font;
import com.aspose.words.Footnote;
import com.aspose.words.FormField;
import com.aspose.words.HeaderFooter;
import com.aspose.words.ImageSize;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Inline;
import com.aspose.words.ListFormat;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphFormat;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.ResourceLoadingArgs;
import com.aspose.words.Row;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Section;
import com.aspose.words.Shape;
import com.aspose.words.SignatureLineOptions;
import com.aspose.words.SpecialChar;
import com.aspose.words.Story;
import com.aspose.words.StructuredDocumentTag;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.internal.zzCJ;
import com.aspose.words.internal.zzCQ;
import com.aspose.words.internal.zzWDl;
import com.aspose.words.internal.zzWbS;
import com.aspose.words.internal.zzWgA;
import com.aspose.words.internal.zzWkp;
import com.aspose.words.internal.zzWoI;
import com.aspose.words.internal.zzWxq;
import com.aspose.words.internal.zzXO8;
import com.aspose.words.internal.zzXVZ;
import com.aspose.words.internal.zzXco;
import com.aspose.words.internal.zzXgR;
import com.aspose.words.internal.zzYwf;
import com.aspose.words.internal.zzZC8;
import com.aspose.words.internal.zzZWL;
import com.aspose.words.internal.zzZZR;
import com.aspose.words.internal.zzZv5;
import com.aspose.words.internal.zzeU;
import com.aspose.words.zz9o;
import com.aspose.words.zzR9;
import com.aspose.words.zzS0;
import com.aspose.words.zzSU;
import com.aspose.words.zzVOs;
import com.aspose.words.zzVTH;
import com.aspose.words.zzVU9;
import com.aspose.words.zzW1K;
import com.aspose.words.zzW4g;
import com.aspose.words.zzWiU;
import com.aspose.words.zzWks;
import com.aspose.words.zzWxX;
import com.aspose.words.zzWy7;
import com.aspose.words.zzX9v;
import com.aspose.words.zzXEZ;
import com.aspose.words.zzXNe;
import com.aspose.words.zzXbK;
import com.aspose.words.zzXf6;
import com.aspose.words.zzXjt;
import com.aspose.words.zzXxx;
import com.aspose.words.zzY2c;
import com.aspose.words.zzY5T;
import com.aspose.words.zzYL7;
import com.aspose.words.zzYSQ;
import com.aspose.words.zzYU;
import com.aspose.words.zzYWh;
import com.aspose.words.zzYrk;
import com.aspose.words.zzYs4;
import com.aspose.words.zzYzA;
import com.aspose.words.zzYzM;
import com.aspose.words.zzZ3z;
import com.aspose.words.zzZ6i;
import com.aspose.words.zzZ7u;
import com.aspose.words.zzZGP;
import com.aspose.words.zzZIu;
import com.aspose.words.zzZRx;
import com.aspose.words.zzZSM;
import com.aspose.words.zzZT2;
import com.aspose.words.zzZZ;
import com.aspose.words.zzZif;
import com.aspose.words.zzaz;
import com.aspose.words.zzig;
import com.aspose.words.zzqK;
import com.aspose.words.zzwB;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public class DocumentBuilder
implements zzSU,
zzVOs,
zzZSM,
zzaz {
    private Document zzZaA;
    private Node zzW4O;
    private Node zzEJ;
    private zzXf6 zzWPl;
    private Font zzWGx;
    private zzWbS<zzXf6> zzYIW;
    private zzWbS<zzqK> zzZ7Z;
    private zzWbS<zzY10> zzWZ1;
    private zzZ3z zzvq = zzZ3z.zzYva();
    private zzwB zzZ0m = new zzwB();
    private zzqK zzZ5R;
    private RowFormat zzZYd;
    private CellFormat zzWwA;
    private ParagraphFormat zzZkL;
    private zzWbS<zzWks> zz6m;
    private int zzWD5 = 0;
    private int zzZEP = -1;
    private int zzOA;
    private boolean zzWcS;

    public DocumentBuilder() throws Exception {
        this.setDocument(new Document());
    }

    public DocumentBuilder(Document doc) {
        this.setDocument(doc);
    }

    public void moveToDocumentStart() {
        this.zzZKQ(0, 1, 0, 0);
    }

    public void moveToDocumentEnd() {
        this.zzZKQ(-1, 1, -1, -1);
        Footnote footnote = (Footnote)this.getCurrentParagraph().getAncestor(20);
        if (footnote != null) {
            this.moveTo(footnote.getParentParagraph());
        }
    }

    public void moveToSection(int sectionIndex) {
        this.zzZKQ(sectionIndex, 1, 0, 0);
    }

    public void moveToHeaderFooter(int headerFooterType) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzY10(documentBuilder.getCurrentSection(), zzZT2.zzXaL(headerFooterType), 0, 0);
    }

    private void zzZKQ(int n, int n2, int n3, int n4) {
        this.zzZaA.ensureMinimum();
        Section section = (Section)this.zzZaA.getChild(2, n, false);
        if (section == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: sectionIdx");
        }
        this.zzY10(section, 1, n3, n4);
    }

    private void zzY10(Section section, int n, int n2, int n3) {
        Story story;
        section.ensureMinimum();
        if (n == 1) {
            story = section.getBody();
        } else {
            int n4 = zzZT2.zzZMt(n);
            story = section.getHeadersFooters().getByHeaderFooterType(n4);
            if (story == null) {
                story = section.appendChild(new HeaderFooter(this.zzZaA, n4));
            }
            if (story.getFirstParagraph() == null) {
                story.appendChild(new Paragraph(this.zzZaA));
            }
        }
        this.zzY10(story, n2, n3);
    }

    private void zzY10(Story story, int n, int n2) {
        Paragraph paragraph = (Paragraph)story.getChild(8, n, true);
        if (paragraph == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: paraIdx");
        }
        int n3 = n2;
        Paragraph paragraph2 = paragraph;
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzY10((CompositeNode)paragraph2, n3);
    }

    final void zzY10(Paragraph paragraph, int n) {
        this.zzY10((CompositeNode)paragraph, n);
    }

    public boolean moveToMergeField(String fieldName) throws Exception {
        return this.moveToMergeField(fieldName, true, true);
    }

    public boolean moveToMergeField(String fieldName, boolean isAfter, boolean isDeleteField) throws Exception {
        if (fieldName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldName");
        }
        FieldMergeField fieldMergeField = this.zzYSJ().zzXuH() ? zzig.zzY9n(this.zzZaA, fieldName) : zzig.zzWAt(this.zzYSJ(), fieldName);
        if (fieldMergeField == null) {
            return false;
        }
        return this.zzY10(fieldMergeField, isAfter, isDeleteField);
    }

    public void moveToField(Field field, boolean isAfter) throws Exception {
        this.zzY10(field, isAfter, false);
    }

    private boolean zzY10(Field field, boolean bl, boolean bl2) throws Exception {
        Node node;
        zzXjt zzXjt2 = field.getFormat().zzWdv();
        Inline inline = zzXjt2.getSourceNode();
        if (bl2) {
            node = field.remove();
            if (node == null) {
                return false;
            }
        } else if (bl) {
            node = field.getEnd().getNextSibling();
            if (node == null) {
                node = field.getEnd().getParentParagraph();
            }
        } else {
            node = field.getStart();
        }
        this.moveTo(node);
        if (inline != null) {
            this.zzY10(inline.zzZ4q(), true);
        }
        return true;
    }

    public boolean moveToBookmark(String bookmarkName) throws Exception {
        return this.moveToBookmark(bookmarkName, true, true);
    }

    public boolean moveToBookmark(String bookmarkName, boolean isStart, boolean isAfter) throws Exception {
        if (bookmarkName == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: bookmarkName");
        }
        Node node = isStart ? zzWy7.zzY10(this.zzZaA, bookmarkName) : zzWy7.zzWaY(this.zzZaA, bookmarkName);
        if (node == null) {
            return false;
        }
        if (node.zzZaQ() == 6) {
            this.zzY10(node.zzYNn(), isAfter ? node.getNextSibling() : node);
        } else {
            Paragraph paragraph = zzVU9.zzWYj(node);
            if (paragraph == null) {
                return false;
            }
            Paragraph paragraph2 = paragraph;
            this.zzY10((CompositeNode)paragraph2, paragraph2.getFirstChild());
        }
        return true;
    }

    public void moveToParagraph(int paragraphIndex, int characterIndex) {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzY10(documentBuilder.getCurrentStory(), paragraphIndex, characterIndex);
    }

    public void moveToStructuredDocumentTag(int structuredDocumentTagIndex, int characterIndex) {
        StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.getCurrentStory().getChild(28, structuredDocumentTagIndex, true);
        if (structuredDocumentTag == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: structuredDocumentTagIndex");
        }
        this.moveToStructuredDocumentTag(structuredDocumentTag, characterIndex);
    }

    public void moveToStructuredDocumentTag(StructuredDocumentTag structuredDocumentTag, int characterIndex) {
        if (structuredDocumentTag == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: structuredDocumentTag");
        }
        if (characterIndex >= 0) {
            this.zzWaY(structuredDocumentTag, characterIndex);
            return;
        }
        if (++characterIndex == 0) {
            this.zzY10(structuredDocumentTag);
            return;
        }
        this.zzWk(structuredDocumentTag, characterIndex);
    }

    public void moveToCell(int tableIndex, int rowIndex, int columnIndex, int characterIndex) {
        Row row = this.zzYkD(tableIndex, rowIndex);
        Cell cell = (Cell)row.getChild(7, columnIndex, false);
        if (cell == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: columnIndex");
        }
        cell.ensureMinimum();
        this.zzY10((CompositeNode)cell, characterIndex);
    }

    public void moveTo(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        if (node.getDocument() != this.getDocument()) {
            throw new IllegalArgumentException("The node belongs to a different document.");
        }
        if (node.getParentNode() == null) {
            throw new IllegalArgumentException("Parent cannot be null.");
        }
        if (node.getNodeType() == 8 || node.zzZaQ() == 6) {
            this.zzYMC(node);
        } else {
            Node node2 = node;
            if (zzVU9.zzp8(node2.getNodeType())) {
                Paragraph paragraph = zzVU9.zzWYj(node);
                if (paragraph == null) {
                    throw new IllegalStateException("There is no paragraph next to the specified node.");
                }
                this.zzYMC(paragraph.hasChildNodes() ? paragraph.getFirstChild() : paragraph);
            } else if (node.isComposite() && node.zzZaQ() == 3) {
                Node node3 = ((CompositeNode)node).getChild(8, 0, true);
                if (node3 == null) {
                    throw new IllegalStateException("The block level node doesn't contain paragraph.");
                }
                this.zzYMC(node3);
            } else {
                throw new IllegalStateException("The node must be a block or an inline.");
            }
        }
        this.zzOA = 0;
        if (this.isAtEndOfParagraph()) {
            this.zzYWZ();
            return;
        }
        if (!this.zzVPw()) {
            this.zzYWZ();
        }
    }

    private void zzY10(CompositeNode compositeNode, Node node) {
        if (node != null) {
            this.moveTo(node);
            return;
        }
        this.moveTo(compositeNode);
    }

    private boolean zzVPw() {
        Node node = this.zzYSJ();
        if (!(node instanceof Inline)) {
            while (node != null && !(node instanceof Inline)) {
                node = node.getPreviousSibling();
            }
            if (node == null && this.zzYSJ().getParentNode().getNodeType() == 28) {
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzY10(((StructuredDocumentTag)documentBuilder.zzYSJ().getParentNode()).zz7w(), true);
                return true;
            }
        }
        if (node == null) {
            for (node = this.zzYSJ(); node != null && !(node instanceof Inline); node = node.getNextSibling()) {
            }
        }
        if (node != null) {
            Inline inline = (Inline)node;
            this.zzY10(inline.zzZ4q(), true);
            return true;
        }
        return false;
    }

    private void zzYWZ() {
        DocumentBuilder documentBuilder = this;
        documentBuilder.zzY10(documentBuilder.getCurrentParagraph().zzWaV(), true);
    }

    public Row deleteRow(int tableIndex, int rowIndex) {
        Row row = this.zzYkD(tableIndex, rowIndex);
        Table table = row.getParentTable();
        if (this.zzXW9() != null) {
            throw new IllegalStateException("Cannot delete a table row while building a table.");
        }
        if (this.zzYSJ().zzYWC(row)) {
            boolean bl = row == table.getLastRow();
            if (!bl) {
                this.moveToCell(tableIndex, rowIndex + 1, 0, 0);
            } else {
                Paragraph paragraph = (Paragraph)table.zzYCz();
                int n = 0;
                Paragraph paragraph2 = paragraph;
                DocumentBuilder documentBuilder = this;
                documentBuilder.zzY10((CompositeNode)paragraph2, n);
            }
        }
        row.remove();
        if (table.getFirstRow() == null) {
            table.remove();
        }
        return row;
    }

    public void write(String text) {
        this.zzYU(text, false);
    }

    public void writeln(String text) {
        this.zzYU(text, true);
    }

    public void writeln() {
        this.insertParagraph();
    }

    public Paragraph insertParagraph() {
        Paragraph paragraph;
        if (this.zzYSJ() != null && this.zzYSJ().zzZaQ() == 6 && (this.isAtEndOfStructuredDocumentTag() || this.zzYSJ().getParentNode() instanceof StructuredDocumentTag)) {
            throw new IllegalStateException("Cannot insert a node of this type at this location.");
        }
        this.zzWUf();
        Paragraph paragraph2 = this.getCurrentParagraph();
        zzW4g zzW4g2 = new zzW4g(this.getDocument());
        try {
            paragraph = new Paragraph(this.zzZaA, this.zzWRr(), this.zzXNn());
            if (paragraph2 == null && this.isAtEndOfStructuredDocumentTag()) {
                this.getCurrentStructuredDocumentTag().appendChild(paragraph);
            } else {
                this.getCurrentParagraph().getParentNode().insertAfter(paragraph, this.getCurrentParagraph());
            }
            if (this.isAtEndOfParagraph() || paragraph2 == null) {
                this.moveTo(paragraph);
            } else {
                paragraph.zzWaY(this.zzYSJ(), null, paragraph.getLastChild());
            }
        }
        finally {
            zzW4g2.dispose();
        }
        if (this.getDocument().zzWYB()) {
            zzVU9.zzWk((zzYs4)(paragraph2 != null ? paragraph2 : paragraph), this.getDocument().zzYsp());
        }
        return this.getCurrentParagraph();
    }

    final Paragraph zzXf4() {
        zzXf6 zzXf62;
        Run run;
        Run run2;
        Cloneable cloneable;
        this.zzWUf();
        Node node = this.zzYSJ();
        Paragraph paragraph = this.getCurrentParagraph();
        if (this.isAtEndOfParagraph()) {
            cloneable = paragraph;
            run2 = cloneable.zzXnW(false);
        } else {
            run2 = run = (Run)node.zzQy(21);
        }
        if (run2 == null && zzZWL.zzZR(node, paragraph.zzZmR())) {
            run = paragraph.zzZmR();
        }
        if (run != null) {
            cloneable = run.zzZ4q();
            zzXf62 = (zzXf6)((zzZZ)cloneable).zzZly();
        } else {
            cloneable = paragraph.zzWaV();
            zzXf62 = (zzXf6)((zzZZ)cloneable).zzZly();
        }
        zzXf6 zzXf63 = zzXf62;
        Paragraph paragraph2 = new Paragraph(this.zzZaA, this.zzWRr(), zzXf63);
        paragraph.getParentNode().insertBefore(paragraph2, paragraph);
        zzW4g zzW4g2 = new zzW4g(this.zzZaA);
        try {
            Node node2 = this.isAtEndOfParagraph() ? null : node;
            paragraph2.zzWaY(paragraph.getFirstChild(), node2, paragraph2.getLastChild());
        }
        finally {
            zzW4g2.dispose();
        }
        return paragraph2;
    }

    public void insertStyleSeparator() {
        zzXxx.zzY9n(this);
    }

    public void insertBreak(int breakType) {
        this.zzXLQ(breakType, true);
    }

    final void zzXLQ(int n, boolean bl) {
        block11: while (true) {
            switch (n) {
                case 0: {
                    this.insertParagraph();
                    return;
                }
                case 1: {
                    if (!this.zzW3f(bl)) {
                        return;
                    }
                    boolean bl2 = this.isAtStartOfParagraph() && !this.isAtEndOfParagraph();
                    this.zzZLZ(ControlChar.PAGE_BREAK);
                    CompatibilityOptions compatibilityOptions = this.getDocument().getCompatibilityOptions();
                    if (bl2 && (!compatibilityOptions.getSplitPgBreakAndParaMark() || compatibilityOptions.zzXpV())) {
                        n = 0;
                        continue block11;
                    }
                    return;
                }
                case 2: {
                    if (this.zzW3f(bl)) {
                        this.zzZLZ(ControlChar.COLUMN_BREAK);
                    }
                    return;
                }
                case 4: {
                    if (this.zzW3f(bl)) {
                        this.zzWSI(1);
                    }
                    return;
                }
                case 5: {
                    if (this.zzW3f(bl)) {
                        this.zzWSI(2);
                    }
                    return;
                }
                case 3: {
                    if (this.zzW3f(bl)) {
                        this.zzWSI(0);
                    }
                    return;
                }
                case 6: {
                    if (this.zzW3f(bl)) {
                        this.zzWSI(3);
                    }
                    return;
                }
                case 7: {
                    if (this.zzW3f(bl)) {
                        this.zzWSI(4);
                    }
                    return;
                }
                case 8: {
                    this.zzZLZ(ControlChar.LINE_BREAK);
                    return;
                }
            }
            break;
        }
        if (bl) {
            throw new IllegalStateException("Unknown break type.");
        }
    }

    public Field insertTableOfContents(String switches) {
        if (!zzWDl.zzW20(switches)) {
            throw new IllegalArgumentException("switches is required.");
        }
        return this.insertField(zzCJ.zzWaY("TOC {0}", switches), "");
    }

    public Field insertField(int fieldType, boolean updateField) throws Exception {
        this.zzWUf();
        return zzVU9.zzY10(fieldType, updateField, this.zzXNn(), this.zzWKy(), this.zzWWv(), this.zzWWv() == null);
    }

    public Field insertField(String fieldCode) throws Exception {
        this.zzWUf();
        return zzVU9.zzY10(fieldCode, this.zzXNn(), this.zzWKy(), this.zzWWv(), this.zzWWv() == null);
    }

    public Field insertField(String fieldCode, String fieldValue) {
        this.zzWUf();
        return zzVU9.zzY10(fieldCode, fieldValue, this.zzXNn(), this.zzWKy(), this.zzWWv(), this.zzWWv() == null);
    }

    public Field insertHyperlink(String displayText, String urlOrBookmark, boolean isBookmark) {
        zzZWL.zzWaY((Object)displayText, "displayText");
        zzZWL.zzWaY((Object)urlOrBookmark, "hrefOrBookmark");
        zzZRx zzZRx2 = this.zzWaY(urlOrBookmark, isBookmark, "", "");
        this.write(displayText);
        DocumentBuilder documentBuilder = this;
        zzZRx2.zzWk(documentBuilder.zzXhM(88, true));
        return zzVU9.zzY10(zzZRx2.getStart(), zzZRx2.getSeparator(), zzZRx2.getEnd());
    }

    public FormField insertTextInput(String name, int type, String format, String fieldValue, int maxLength) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (format == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: format");
        }
        if (fieldValue == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: fieldValue");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: maxLength");
        }
        this.zzY4q(70);
        if (zzWDl.zzW20(name)) {
            this.startBookmark(name);
        }
        this.zzYI4(" FORMTEXT ");
        FieldSeparator fieldSeparator = this.zzZes(70);
        String string = zzWDl.zzW20(fieldValue) ? fieldValue : FormField.zzXLj;
        Run run = new Run(this.zzZaA, string, this.zzXNn());
        this.insertNode(run);
        Node node = this.zzXhM(70, true);
        if (zzWDl.zzW20(name)) {
            node = this.endBookmark(name);
        }
        FormField formField = this.zzVZW(fieldSeparator);
        formField.setName(name);
        formField.setTextInputType(type);
        formField.setTextInputFormat(format);
        formField.setResult(fieldValue);
        formField.setMaxLength(maxLength);
        this.zzY10((CompositeNode)((Paragraph)node.zzYNn()), node.getNextSibling());
        return formField;
    }

    public FormField insertCheckBox(String name, boolean checkedValue, int size) throws Exception {
        boolean bl = checkedValue;
        return this.insertCheckBox(name, bl, bl, size);
    }

    public FormField insertCheckBox(String name, boolean defaultValue, boolean checkedValue, int size) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: size");
        }
        this.zzY4q(71);
        if (zzWDl.zzW20(name)) {
            this.startBookmark(name);
        }
        this.zzYI4(" FORMCHECKBOX ");
        FieldEnd fieldEnd = this.zzXhM(71, false);
        if (zzWDl.zzW20(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzVZW(fieldEnd);
        formField.setName(name);
        formField.setDefault(defaultValue);
        formField.setChecked(checkedValue);
        if (size != 0) {
            formField.isCheckBoxExactSize(true);
            formField.setCheckBoxSize(size);
        } else {
            formField.isCheckBoxExactSize(false);
            formField.setCheckBoxSize(10.0);
        }
        return formField;
    }

    public FormField insertComboBox(String name, String[] items, int selectedIndex) throws Exception {
        if (name == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: name");
        }
        if (items == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: items");
        }
        if (items.length > 25) {
            throw new IllegalArgumentException("items");
        }
        if (selectedIndex < 0 || selectedIndex >= items.length) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: selectedIndex");
        }
        this.zzY4q(83);
        if (zzWDl.zzW20(name)) {
            this.startBookmark(name);
        }
        this.zzYI4(" FORMDROPDOWN ");
        FieldEnd fieldEnd = this.zzXhM(83, false);
        if (zzWDl.zzW20(name)) {
            this.endBookmark(name);
        }
        FormField formField = this.zzVZW(fieldEnd);
        formField.setName(name);
        formField.setDropDownSelectedIndex(selectedIndex);
        for (int i = 0; i < items.length; ++i) {
            formField.getDropDownItems().add(items[i]);
        }
        return formField;
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText) {
        return this.insertFootnote(footnoteType, footnoteText, null);
    }

    public Footnote insertFootnote(int footnoteType, String footnoteText, String referenceMark) {
        Footnote footnote = new Footnote(this.zzZaA, footnoteType, !zzWDl.zzW20(referenceMark), referenceMark, this.zzXNn());
        Style style = this.getDocument().getStyles().zzYwI(zzVU9.zzYXZ(footnoteType));
        footnote.zzZ4q().set(50, style.zzY6t());
        this.insertNode(footnote);
        Paragraph paragraph = new Paragraph(this.zzZaA);
        Style style2 = this.getDocument().getStyles().zzYwI(zzVU9.zzVYS(footnoteType));
        paragraph.zzWXA().set(1000, style2.zzY6t());
        footnote.getParagraphs().add(paragraph);
        Inline inline = footnote.isAuto() ? new SpecialChar(this.zzZaA, '\u0002', new zzXf6()) : new Run(this.zzZaA, footnote.getReferenceMark(), new zzXf6());
        inline.zzZ4q().set(50, style.zzY6t());
        paragraph.appendChild(inline);
        if (zzWDl.zzW20(footnoteText)) {
            Node node = this.zzYSJ();
            this.moveTo(paragraph);
            this.write(" ");
            this.write(footnoteText);
            this.zzYMC(node);
        }
        return footnote;
    }

    public Shape insertImage(BufferedImage image) throws Exception {
        return this.insertImage(image, -1.0, -1.0);
    }

    public Shape insertImage(String fileName) throws Exception {
        return this.insertImage(fileName, -1.0, -1.0);
    }

    final Shape zzZck(zzZZR zzZZR2) throws Exception {
        return this.zzY10(zzZZR2, -1.0, -1.0);
    }

    public Shape insertImage(InputStream stream) throws Exception {
        return this.zzZck(zzZZR.zzWaY(stream));
    }

    public Shape insertImage(byte[] imageBytes) throws Exception {
        return this.insertImage(imageBytes, -1.0, -1.0);
    }

    public Shape insertImage(BufferedImage image, double width, double height) throws Exception {
        return this.insertImage(image, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(String fileName, double width, double height) throws Exception {
        return this.insertImage(fileName, 2, 0.0, 2, 0.0, width, height, 0);
    }

    private Shape zzY10(zzZZR zzZZR2, double d, double d2) throws Exception {
        return this.zzY10(zzZZR2, 2, 0.0, 2, 0.0, d, d2, 0);
    }

    public Shape insertImage(InputStream stream, double width, double height) throws Exception {
        return this.zzY10(zzZZR.zzWaY(stream), width, height);
    }

    public Shape insertImage(byte[] imageBytes, double width, double height) throws Exception {
        return this.insertImage(imageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertImage(BufferedImage image, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        if (image == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: image");
        }
        try (zzZv5 zzZv52 = new zzZv5();){
            zzWgA.zzWaY(image, zzZv52);
            Shape shape = this.zzY10(zzZv52, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
    }

    public Shape insertImage(String fileName, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        Object object;
        zzZWL.zzWk(fileName, "fileName");
        if (this.getDocument().getResourceLoadingCallback() != null) {
            object = new ResourceLoadingArgs("", fileName, 0);
            switch (this.getDocument().getResourceLoadingCallback().resourceLoading((ResourceLoadingArgs)object)) {
                case 0: {
                    break;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return this.insertImage(((ResourceLoadingArgs)object).getData(), horzPos, left, vertPos, top, width, height, wrapType);
                }
                default: {
                    return null;
                }
            }
        }
        object = zzXO8.zzYjX(fileName);
        try {
            Shape shape = this.zzY10((zzZZR)object, horzPos, left, vertPos, top, width, height, wrapType);
            return shape;
        }
        finally {
            if (object != null) {
                ((zzZZR)object).close();
            }
        }
    }

    private Shape zzY10(zzZZR zzZZR2, int n, double d, int n2, double d2, double d3, double d4, int n3) throws Exception {
        if (zzZZR2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        byte[] byArray = zzZWL.zzY9n(zzZZR2);
        return this.insertImage(byArray, n, d, n2, d2, d3, d4, n3);
    }

    public Shape insertImage(InputStream stream, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzY10(zzZZR.zzWaY(stream), horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertImage(byte[] imageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return this.zzY10(imageBytes, horzPos, left, vertPos, top, width, height, wrapType, false);
    }

    final Shape zzY10(byte[] object, int n, double d, int n2, double d2, double d3, double d4, int n3, boolean bl) throws Exception {
        Object object2;
        Object object3;
        Shape shape;
        Object object4;
        if (object == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        boolean bl2 = false;
        if (zzZC8.zzXT5(object)) {
            object4 = new zzWgA((byte[])object);
            bl2 = true;
            ((zzWoI)object4).dispose();
        }
        object4 = null;
        boolean bl3 = this.zzZaA.getCompatibilityOptions().getMswVersion() > 12 || this.zzZaA.getCompatibilityOptions().getMswVersion() == 0;
        if (bl3) {
            shape = new Shape((DocumentBase)this.zzZaA, 0);
            object3 = new zzZ7u();
            ((zzY2c)object3).zzY10(zzZ6i.zzZyQ("rect"));
            ((zzZ7u)object3).zzY10(new zzXbK());
            ((zzZ7u)object3).zzZWM().zzZ3P().zzWk(this.zzZaA);
            object2 = new zzYrk();
            ((zzWiU)object2).zzWaY(new zzZIu(this.zzZaA.zzWkT(), ""));
            ((zzWiU)object2).zzY10(new zzXEZ());
            ((zzR9)object3).zzY10((zzWiU)object2);
            shape.setShapeType(75);
            shape.zzY1d((zzR9)object3);
        } else {
            shape = new Shape((DocumentBase)this.zzZaA, 75);
        }
        if (zzZC8.zzWzr(object)) {
            int n4 = bl3 ? 6 : 2;
            object2 = shape.getImageData().zzY10((byte[])object, new zzYWh(this.getPageSetup().getPageWidth(), this.getPageSetup().getPageHeight()), new zzYWh(d3, d4), n4);
            if (bl3) {
                ImageSize imageSize = new ImageSize(zzZC8.zzX1h((byte[])object2));
                this.zzY10((zzZ7u)shape.zzWnS(), (byte[])object, imageSize);
            }
            object = object2;
        }
        if (bl3 && bl2) {
            ((zzZ7u)shape.zzWnS()).zzZWM().zzZ3P().zzHG((byte[])object);
            object3 = zzZC8.zzx9(object);
            object4 = new zzYWh(((zzWxq)object3).getWidthPoints(), ((zzWxq)object3).getHeightPoints());
        } else {
            shape.getImageData().setImageBytes((byte[])object);
        }
        shape.zzWaY(this.zzXNn());
        shape.setRelativeHorizontalPosition(n);
        shape.setLeft(d);
        shape.setRelativeVerticalPosition(n2);
        shape.setTop(d2);
        shape.setWrapType(n3);
        shape.setAspectRatioLocked(true);
        this.insertNode(shape);
        double d5 = 0.0;
        if (!bl && bl3 && zzZC8.zzWy7(object)) {
            d5 = DocumentBuilder.zzY10(shape, object);
        }
        shape.zzY10(d3, d4, (zzYWh)object4, d5);
        if (d5 > 0.0) {
            shape.setRotation(d5);
        }
        return shape;
    }

    private static double zzY10(Shape shape, byte[] byArray) throws Exception {
        int n = zzZC8.zzX7Q(byArray);
        if (n == 1) {
            return 0.0;
        }
        int n2 = zzVU9.zzDw(n);
        if (n2 != 0) {
            shape.setFlipOrientation(n2);
        }
        double d = zzVU9.zzXEz(n);
        return d;
    }

    private void zzY10(zzZ7u zzZ7u2, byte[] byArray, ImageSize imageSize) throws Exception {
        byte[] byArray2;
        Object object;
        zzZ7u2.zzZWM().zzZ3P().getExtensions();
        try (zzZv5 zzZv52 = new zzZv5(byArray);){
            object = zzVU9.zzY10(zzZv52, this.zzZaA);
            ((zzX9v)object).zzYc8(imageSize.getWidthPoints(), imageSize.getHeightPoints());
            ((zzX9v)object).zzKv();
            byArray2 = ((zzX9v)object).zzZMG(true);
        }
        zzZ7u2.zzZWM().zzZ3P().setExtensions(new zzWkp<zzXNe>());
        object = zzXNe.zzY10(byArray2, this.zzZaA);
        zzZ7u2.zzZWM().zzZ3P().getExtensions().zzXGj(((zzXNe)object).getUri(), (zzXNe)object);
    }

    private Shape zzY10(zzZZR zzZZR2, String string, boolean bl, zzZZR zzZZR3) throws Exception {
        zzYzA zzYzA2 = zzYzA.zzVW8(string);
        Shape shape = this.zzY10(zzZZR3, bl, zzYzA2, null);
        zzWxX zzWxX2 = zz9o.zzY10(zzZZR2, string, bl);
        return DocumentBuilder.zzY10(null, false, shape, zzYzA2.zzhH, zzWxX2);
    }

    public Shape insertOleObject(InputStream stream, String progId, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzY10(zzZZR.zzWaY(stream), progId, asIcon, zzZZR.zzWaY(presentation));
    }

    private Shape zzY10(String string, boolean bl, boolean bl2, zzZZR zzZZR2) throws Exception {
        zzYzA zzYzA2 = zzYzA.zzZ3d(zzeU.zzZFy(string));
        return this.zzY10(string, bl, bl2, zzZZR2, zzYzA2);
    }

    public Shape insertOleObject(String fileName, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzY10(fileName, isLinked, asIcon, zzZZR.zzWaY(presentation));
    }

    private Shape zzY10(String string, String string2, boolean bl, boolean bl2, zzZZR zzZZR2) throws Exception {
        zzYzA zzYzA2 = zzYzA.zzVW8(string2);
        return this.zzY10(string, bl, bl2, zzZZR2, zzYzA2);
    }

    public Shape insertOleObject(String fileName, String progId, boolean isLinked, boolean asIcon, InputStream presentation) throws Exception {
        return this.zzY10(fileName, progId, isLinked, asIcon, zzZZR.zzWaY(presentation));
    }

    public Shape insertOleObjectAsIcon(String fileName, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYzA zzYzA2 = zzYzA.zzZ3d(zzeU.zzZFy(fileName));
        return this.zzY10(fileName, isLinked, iconFile, iconCaption, zzYzA2);
    }

    public Shape insertOleObjectAsIcon(String fileName, String progId, boolean isLinked, String iconFile, String iconCaption) throws Exception {
        zzYzA zzYzA2 = zzYzA.zzVW8(progId);
        return this.zzY10(fileName, isLinked, iconFile, iconCaption, zzYzA2);
    }

    private Shape zzWaY(zzZZR zzZZR2, String string, String string2, String string3) throws Exception {
        zzYzA zzYzA2 = zzYzA.zzVW8(string);
        Shape shape = this.zzY10(string2, string3, zzYzA2);
        zzWxX zzWxX2 = zz9o.zzY10(zzZZR2, string, true);
        return DocumentBuilder.zzY10(null, false, shape, zzYzA2.zzhH, zzWxX2);
    }

    public Shape insertOleObjectAsIcon(InputStream stream, String progId, String iconFile, String iconCaption) throws Exception {
        return this.zzWaY(zzZZR.zzWaY(stream), progId, iconFile, iconCaption);
    }

    final Shape zzY10(zzYSQ zzYSQ2, zzZZR zzZZR2) throws Exception {
        Shape shape = this.zz4C(zzZZR2);
        shape.setShapeType(201);
        shape.setShapeAttr(4112, zzYSQ2);
        return shape;
    }

    public void insertHtml(String html) throws Exception {
        this.insertHtml(html, 0);
    }

    public void insertHtml(String html, boolean useBuilderFormatting) throws Exception {
        int n = useBuilderFormatting ? 1 : 0;
        this.insertHtml(html, n);
    }

    public void insertHtml(String html, int options) throws Exception {
        this.zzWUf();
        if (this.zzZWt()) {
            DocumentBuilder documentBuilder = new DocumentBuilder();
            documentBuilder.insertHtml(html);
            this.write(DocumentBuilder.zzWVJ(documentBuilder.getDocument().toString(70)));
            return;
        }
        zzZif zzZif2 = zzVU9.zzY10(html, options, this);
        zzZif2.zzWxW();
    }

    public Shape insertShape(int shapeType, double width, double height) throws Exception {
        this.zzWUf();
        return zzVU9.zzY10(this, shapeType, width, height, 0);
    }

    public Shape insertShape(int shapeType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        this.zzWUf();
        return zzVU9.zzY10(this, shapeType, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertChart(int chartType, double width, double height) throws Exception {
        return this.insertChart(chartType, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertChart(int chartType, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        zzY5T zzY5T2 = new zzY5T();
        return zzY5T2.zzY10(chartType, horzPos, left, vertPos, top, width, height, wrapType, this);
    }

    public Shape insertOnlineVideo(String videoUrl, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZGP(this).zzY10(videoUrl, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, double width, double height) throws Exception {
        return this.insertOnlineVideo(videoUrl, videoEmbedCode, thumbnailImageBytes, 2, 0.0, 2, 0.0, width, height, 0);
    }

    public Shape insertOnlineVideo(String videoUrl, String videoEmbedCode, byte[] thumbnailImageBytes, int horzPos, double left, int vertPos, double top, double width, double height, int wrapType) throws Exception {
        return new zzZGP(this).zzY10(videoUrl, videoEmbedCode, thumbnailImageBytes, horzPos, left, vertPos, top, width, height, wrapType);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions) throws Exception {
        return this.insertSignatureLine(signatureLineOptions, 2, 0.0, 2, 0.0, 0);
    }

    public Shape insertSignatureLine(SignatureLineOptions signatureLineOptions, int horzPos, double left, int vertPos, double top, int wrapType) throws Exception {
        if (signatureLineOptions == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: signatureLineOptions");
        }
        Shape shape = new Shape((DocumentBase)this.zzZaA, 75);
        shape.zzWaY(this.zzXNn());
        shape.zzbK(true);
        shape.getSignatureLine().zzY10(signatureLineOptions);
        shape.setRelativeHorizontalPosition(horzPos);
        shape.setLeft(left);
        shape.setRelativeVerticalPosition(vertPos);
        shape.setTop(top);
        shape.setWrapType(wrapType);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzq(ConvertUtil.pixelToPoint(imageSize.getWidthPixels(), 96.0), ConvertUtil.pixelToPoint(imageSize.getHeightPixels(), 96.0));
        return shape;
    }

    public Shape insertHorizontalRule() throws Exception {
        Shape shape = Shape.zzYHI(this.zzZaA);
        this.insertNode(shape);
        return shape;
    }

    private boolean zzZWt() {
        boolean bl = false;
        if (this.zzYSJ().getParentNode().getNodeType() == 28) {
            StructuredDocumentTag structuredDocumentTag = (StructuredDocumentTag)this.zzYSJ().getParentNode();
            switch (structuredDocumentTag.getSdtType()) {
                case 5: 
                case 6: 
                case 12: {
                    bl = true;
                    break;
                }
                case 10: {
                    break;
                }
                case 4: 
                case 13: {
                    throw new IllegalStateException("Can not insert text into this StructuredDocumentTag.");
                }
            }
        }
        return bl;
    }

    private static String zzWVJ(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u000b' || c == '\n' || c == '\f' || c == '\r' || c == '\f') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public Cell insertCell() {
        this.zzWUf();
        if (this.zzXW9() == null) {
            this.startTable();
        }
        if (this.zzXW9().zzcD() == 1) {
            this.zzXW9().zzVWn();
        }
        if (this.zzXW9().zzcD() == 3) {
            this.zzXW9().zzWHv();
        }
        return this.zzXW9().zz2a();
    }

    public Table startTable() {
        this.zz6m.push(new zzWks(this));
        return this.zzXW9().startTable();
    }

    public Table endTable() {
        if (this.zzXW9() == null) {
            throw new IllegalStateException("Cannot end a table while not building a table.");
        }
        Table table = this.zzXW9().endTable();
        this.zz6m.pop();
        return table;
    }

    public Row endRow() {
        if (this.zzXW9() == null) {
            throw new IllegalStateException("Cannot end a row while not building a table.");
        }
        Row row = this.zzXW9().endRow();
        if (this.zzWGx != null && this.zzWGx.getHidden()) {
            row.zzZQP().setHidden(true);
        }
        return row;
    }

    public BookmarkStart startBookmark(String bookmarkName) {
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZaA, bookmarkName, 0);
        this.insertNode(bookmarkStart);
        return bookmarkStart;
    }

    public BookmarkEnd endBookmark(String bookmarkName) {
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZaA, bookmarkName);
        this.insertNode(bookmarkEnd);
        return bookmarkEnd;
    }

    public BookmarkStart startColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZhB();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be started in a table cell.");
        }
        Cell cell2 = cell.getParentRow().getFirstCell();
        cell2.ensureMinimum();
        BookmarkStart bookmarkStart = new BookmarkStart(this.zzZaA, bookmarkName);
        cell2.getFirstParagraph().insertAfter(bookmarkStart, null);
        int n = cell.zzYd();
        bookmarkStart.zzVT3(n);
        return bookmarkStart;
    }

    public BookmarkEnd endColumnBookmark(String bookmarkName) {
        Cell cell = this.zzZhB();
        if (cell == null) {
            throw new IllegalStateException("A column bookmark can only be ended in a table cell.");
        }
        Cell cell2 = cell;
        Bookmark bookmark = cell2.getParentRow().getParentTable().getRange().getBookmarks().get(bookmarkName);
        if (bookmark == null) {
            throw new IllegalStateException("The corresponding bookmark start must be in the same table.");
        }
        int n = cell.zzYd();
        if (bookmark.getBookmarkStart().getFirstColumn() > n) {
            throw new IllegalStateException("The end column index must be greater than or equal to the start column index.");
        }
        BookmarkEnd bookmarkEnd = new BookmarkEnd(this.zzZaA, bookmarkName);
        cell2 = cell;
        cell2.getParentRow().getParentTable().insertAfter(bookmarkEnd, cell.getParentRow());
        bookmark.getBookmarkStart().zzZ2p(n);
        return bookmarkEnd;
    }

    public EditableRangeStart startEditableRange() {
        EditableRangeStart editableRangeStart = new EditableRangeStart(this.zzZaA);
        this.zzZEP = editableRangeStart.getId();
        this.insertNode(editableRangeStart);
        return editableRangeStart;
    }

    public EditableRangeEnd endEditableRange() {
        if (this.zzZEP == -1) {
            throw new IllegalStateException("EndEditableRange can not be called before StartEditableRange.");
        }
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZaA, this.zzZEP);
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public EditableRangeEnd endEditableRange(EditableRangeStart start) {
        EditableRangeEnd editableRangeEnd = new EditableRangeEnd(this.zzZaA, start.getId());
        this.insertNode(editableRangeEnd);
        return editableRangeEnd;
    }

    public Node insertDocument(Document srcDoc, int importFormatMode) {
        return this.insertDocument(srcDoc, importFormatMode, new ImportFormatOptions());
    }

    public Node insertDocument(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZWL.zzWaY((Object)importFormatOptions, "ImportFormatOptions");
        this.zzWUf();
        return zzYL7.zzY10(this, srcDoc, importFormatMode, importFormatOptions);
    }

    public Node insertDocumentInline(Document srcDoc, int importFormatMode, ImportFormatOptions importFormatOptions) {
        zzZWL.zzWaY((Object)importFormatOptions, "ImportFormatOptions");
        this.zzWUf();
        importFormatOptions.zzX0t(true);
        Node node = zzYL7.zzY10(this, srcDoc, importFormatMode, importFormatOptions);
        importFormatOptions.zzX0t(false);
        return node;
    }

    public Document getDocument() {
        return this.zzZaA;
    }

    public void setDocument(Document value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value == this.zzZaA) {
            return;
        }
        this.zzZaA = value;
        this.zzYMC(null);
        this.zzWPl = new zzXf6();
        this.zzYIW = null;
        this.zzZ7Z = null;
        this.zzWGx = null;
        this.zz6m = new zzWbS();
        this.moveToDocumentStart();
    }

    public Font getFont() {
        if (this.zzWGx == null) {
            DocumentBuilder documentBuilder = this;
            this.zzWGx = new Font(documentBuilder, documentBuilder.getDocument());
        }
        return this.zzWGx;
    }

    public boolean getBold() {
        return this.getFont().getBold();
    }

    public void setBold(boolean value) {
        this.getFont().setBold(value);
    }

    public boolean getItalic() {
        return this.getFont().getItalic();
    }

    public void setItalic(boolean value) {
        this.getFont().setItalic(value);
    }

    public int getUnderline() {
        return this.getFont().getUnderline();
    }

    public void setUnderline(int value) {
        this.getFont().setUnderline(value);
    }

    public ParagraphFormat getParagraphFormat() {
        if (this.zzZkL == null) {
            DocumentBuilder documentBuilder = this;
            this.zzZkL = new ParagraphFormat(documentBuilder, documentBuilder.getDocument().getStyles());
        }
        return this.zzZkL;
    }

    public ListFormat getListFormat() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().getListFormat();
        }
        return null;
    }

    public PageSetup getPageSetup() {
        return this.getCurrentSection().getPageSetup();
    }

    public RowFormat getRowFormat() {
        if (this.zzZYd == null) {
            this.zzZYd = new RowFormat(this);
        }
        return this.zzZYd;
    }

    public CellFormat getCellFormat() {
        if (this.zzWwA == null) {
            this.zzWwA = new CellFormat(this);
        }
        return this.zzWwA;
    }

    final void zzXkr(Node node) {
        this.getCurrentParagraph().getParentNode().insertBefore(node, this.getCurrentParagraph());
    }

    public void pushFont() {
        zzXf6 zzXf62;
        if (this.getCurrentParagraph() != null) {
            zzXf6 zzXf63 = this.getCurrentParagraph().zzWaV();
            zzXf62 = (zzXf6)zzXf63.zzZly();
        } else {
            zzXf62 = this.zzXNn();
        }
        zzXf6 zzXf64 = zzXf62;
        this.zz6q().push(new zzY10(this.zzXNn(), zzXf64));
    }

    public void popFont() {
        zzWbS<zzY10> zzWbS2 = this.zz6q();
        if (zzWbS2.size() > 0) {
            zzY10 zzY102 = (zzY10)this.zz6q().pop();
            this.zzY10(zzY102.zzZ4q(), false);
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzXkr(zzY102.zzX4w());
            }
        }
    }

    final void zzZqJ() {
        this.zzWWs().push(this.zzXNn());
    }

    final void zzzW() {
        zzWbS<zzXf6> zzWbS2 = this.zzWWs();
        if (zzWbS2.size() > 0) {
            DocumentBuilder documentBuilder = this;
            documentBuilder.zzY10((zzXf6)documentBuilder.zzWWs().pop(), false);
        }
    }

    final void zzXMN() {
        this.zzYqa().push(this.zzWRr());
    }

    final void zzZku() {
        zzWbS<zzqK> zzWbS2 = this.zzYqa();
        if (zzWbS2.size() > 0) {
            zzqK zzqK2 = (zzqK)this.zzYqa().pop();
            if (this.getCurrentParagraph() != null) {
                this.getCurrentParagraph().zzY10(zzqK2);
            }
        }
    }

    private zzZRx zzWaY(String string, boolean bl, String string2, String string3) {
        FieldStart fieldStart = this.zzY4q(88);
        zzYzM zzYzM2 = new zzYzM();
        zzYzM2.setTarget(string2);
        zzYzM2.setScreenTip(string3);
        if (bl) {
            zzYzM2.setSubAddress(string);
        } else {
            zzYzM2.setAddress(zzXVZ.zzY6Y(string));
            zzYzM2.setSubAddress(zzXVZ.zzX0l(string));
        }
        this.zzYI4(zzYzM2.zzXqb());
        FieldSeparator fieldSeparator = this.zzZes(88);
        return new zzZRx(fieldStart, fieldSeparator, null);
    }

    final zzZRx zzZKQ(String string, String string2, String string3) {
        boolean bl = zzXVZ.zzvt(string);
        String string4 = bl ? zzXVZ.zzX0l(string) : string;
        return this.zzWaY(string4, bl, string2, string3);
    }

    final zzZRx zzY10(zzYzM zzYzM2) {
        FieldStart fieldStart = this.zzY4q(88);
        this.zzYI4(zzYzM2.zzXqb());
        FieldSeparator fieldSeparator = this.zzZes(88);
        return new zzZRx(fieldStart, fieldSeparator, null);
    }

    final FieldEnd zzYkU() {
        return this.zzXhM(88, true);
    }

    final zzXf6 zzXNn() {
        zzXf6 zzXf62 = this.zzWPl;
        return (zzXf6)zzXf62.zzZly();
    }

    final zzqK zzWRr() {
        zzqK zzqK2 = this.zzWXA();
        return (zzqK)zzqK2.zzZly();
    }

    final zzZ3z zzWLW() {
        zzZ3z zzZ3z2 = this.zzZQP();
        return (zzZ3z)zzZ3z2.zzZly();
    }

    final zzwB zzZoR() {
        zzwB zzwB2 = this.zzXFQ();
        return (zzwB)zzwB2.zzZly();
    }

    public boolean isAtStartOfParagraph() {
        if (this.getCurrentParagraph() == null) {
            return false;
        }
        for (Node node = this.getCurrentParagraph().getFirstChild(); node != null && node != this.zzYSJ(); node = node.getNextSibling()) {
            if (node.getNodeType() == 9 || node.getNodeType() == 10) {
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean isAtEndOfParagraph() {
        return this.zzYSJ().getNodeType() == 8;
    }

    public boolean isAtEndOfStructuredDocumentTag() {
        return this.zzWcS && this.zzYSJ().getNodeType() == 28;
    }

    private void zzYU(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            switch (((StructuredDocumentTag)this.zzYSJ()).getLevel()) {
                case 2: {
                    this.insertParagraph();
                    bl = false;
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Cannot insert text at this cursor position.");
                }
            }
        }
        String string2 = zzZT2.zzWOm(string);
        int n = 0;
        while (n <= string2.length()) {
            int n2;
            int n3 = string2.indexOf(13, n);
            if (n3 != -1) {
                n2 = n3 - n;
                if (n2 > 0) {
                    int n4 = n;
                    this.zzZ9O(string2.substring(n4, n4 + n2));
                }
                switch (this.zzWD5) {
                    case 0: {
                        this.insertParagraph();
                        break;
                    }
                    case 1: {
                        this.zzZLZ(ControlChar.PARAGRAPH_BREAK);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                n = n3 + 1;
                continue;
            }
            n2 = string2.length() - n;
            if (n2 > 0) {
                int n5 = n;
                this.zzZ9O(string2.substring(n5, n5 + n2));
            }
            if (!bl) break;
            this.insertParagraph();
            return;
        }
    }

    public void insertNode(Node node) {
        this.zzWUf();
        if (this.zzXW9() != null && this.zzXW9().zzcD() == 1) {
            this.endTable();
        }
        if (this.isAtEndOfParagraph()) {
            this.getCurrentParagraph().appendChild(node);
            return;
        }
        if (this.isAtEndOfStructuredDocumentTag()) {
            this.getCurrentStructuredDocumentTag().appendChild(node);
            return;
        }
        this.zzYSJ().getParentNode().insertBefore(node, this.zzYSJ());
    }

    final void zzX0c(int n) {
        this.zzW3f(true);
        this.zzWSI(n);
    }

    private void zzWSI(int n) {
        this.insertParagraph();
        zzW4g zzW4g2 = new zzW4g(this.getDocument());
        try {
            zzW1K zzW1K2 = this.getCurrentSection().zzPh();
            zzW1K zzW1K3 = (zzW1K)zzW1K2.zzZly();
            Section section = new Section(this.zzZaA, zzW1K3);
            section.getPageSetup().setSectionStart(n);
            section.appendChild(new Body(this.zzZaA));
            this.zzZaA.insertAfter(section, this.getCurrentSection());
            section.getBody().zzWaY(this.getCurrentParagraph(), null, section.getBody().getLastChild());
            return;
        }
        finally {
            zzW4g2.dispose();
        }
    }

    final FieldStart zzY4q(int n) {
        this.zzWUf();
        return zzVU9.zzY10(n, this.zzXNn(), this.zzWKy(), this.zzWWv(), this.zzWWv() == null);
    }

    final Run zzYI4(String string) {
        return zzVU9.zzWaY(string, this.zzXNn(), this.zzWKy(), this.zzWWv(), this.zzWWv() == null);
    }

    final FieldEnd zzXhM(int n, boolean bl) {
        return zzVU9.zzWaY(n, bl, this.zzXNn(), this.zzWKy(), this.zzWWv(), this.zzWWv() == null);
    }

    final FieldSeparator zzZes(int n) {
        return zzVU9.zzWaY(n, this.zzXNn(), this.zzWKy(), this.zzWWv(), this.zzWWv() == null);
    }

    private FormField zzVZW(Node node) {
        FormField formField = new FormField((DocumentBase)this.zzZaA, new zzS0(), this.zzXNn());
        CompositeNode compositeNode = node == null ? this.zzWKy() : node.getParentNode();
        compositeNode.insertBefore(formField, node);
        return formField;
    }

    private boolean zzW3f(boolean bl) {
        boolean bl2;
        boolean bl3 = this.getCurrentStory().getStoryType() != 1;
        boolean bl4 = bl2 = this.zzXW9() != null;
        if (bl) {
            if (bl3) {
                throw new IllegalStateException("Cannot insert the requested break outside of the main story.");
            }
            if (bl2) {
                throw new IllegalStateException("Cannot insert the requested break inside a table.");
            }
        }
        return bl || !bl3 && !bl2;
    }

    private Row zzYkD(int n, int n2) {
        NodeCollection nodeCollection = this.getCurrentStory().getChildNodes(5, true);
        Table table = (Table)nodeCollection.get(n);
        if (table == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: tableIndex");
        }
        Row row = (Row)table.getChild(6, n2, false);
        if (row == null) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: rowIndex");
        }
        return row;
    }

    private void zzZ9O(String string) {
        if (this.zzXO3(string)) {
            zzCQ zzCQ2 = new zzCQ(string, this.getParagraphFormat().getBidi() ? 1 : 0, null);
            for (zzXgR zzXgR2 : zzCQ2.zzZG9(this.getParagraphFormat().getBidi())) {
                zzYU zzYU2 = zzYU.zzm8(zzXgR2.zzXNi());
                zzXf6 zzXf62 = this.zzXNn();
                zzXf62.zzXtS(265, zzYU2);
                if (zzXgR2.zzYIA()) {
                    zzXf62.setLocaleIdBi(1037);
                }
                Run run = new Run(this.zzZaA, zzXgR2.getText(), zzXf62);
                this.insertNode(run);
            }
            return;
        }
        this.zzZLZ(string);
    }

    private boolean zzXO3(String string) {
        boolean bl = this.getFont().getBidi();
        for (int i = 0; i < string.length(); ++i) {
            boolean bl2;
            char c = string.charAt(i);
            int n = zzXco.zzW9q(c);
            boolean bl3 = n == 0;
            boolean bl4 = bl2 = n == 1 || n == 2;
            if ((!bl || !bl3) && (bl || !bl2)) continue;
            return true;
        }
        return false;
    }

    final void zzY10(zzXf6 zzXf62, boolean bl) {
        zzXf6 zzXf63;
        if (bl) {
            zzXf6 zzXf64 = zzXf62;
            zzXf63 = (zzXf6)zzXf64.zzZly();
        } else {
            zzXf63 = zzXf62;
        }
        this.zzWPl = zzXf63;
    }

    final void zzxW() {
        this.zzWPl.clear();
    }

    final void zztg() {
        if (this.zzZhB() != null) {
            zzwB zzwB2;
            zzwB zzwB3 = zzwB2 = this.zzZhB().zzXFQ();
            this.zzZ0m = (zzwB)zzwB3.zzZly();
            zzwB2.zzWaY(this.zzZ0m);
        }
    }

    private Shape zzY10(String string, boolean bl, boolean bl2, zzZZR zzZZR2, zzYzA zzYzA2) throws Exception {
        if (zzYzA2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        Shape shape = this.zzY10(zzZZR2, bl2, zzYzA2, string);
        zzWxX zzWxX2 = zz9o.zzY10(string, bl, bl2, zzYzA2);
        return DocumentBuilder.zzY10(string, bl, shape, zzYzA2.zzhH, zzWxX2);
    }

    private Shape zzY10(String string, boolean bl, String string2, String string3, zzYzA zzYzA2) throws Exception {
        if (zzYzA2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string3 == null) {
            string3 = zzeU.zzYjG(string);
        }
        Shape shape = string2 != null ? this.zzW1W(string2, string3) : this.zzY10(null, string3, zzYzA2);
        zzWxX zzWxX2 = zz9o.zzY10(string, bl, true, zzYzA2);
        return DocumentBuilder.zzY10(string, bl, shape, zzYzA2.zzhH, zzWxX2);
    }

    private static Shape zzY10(String string, boolean bl, Shape shape, String string2, zzWxX zzWxX2) {
        if (shape == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: insertedOleImage");
        }
        shape.setShapeType(-2);
        shape.getOleFormat().setProgId(string2);
        shape.getOleFormat().zzWaY(zzWxX2);
        if (bl) {
            shape.getOleFormat().setSourceFullName(string);
        }
        return shape;
    }

    private Shape zzY10(zzZZR zzZZR2, boolean bl, zzYzA zzYzA2, String string) throws Exception {
        if (zzYzA2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (zzZZR2 != null) {
            return this.zz4C(zzZZR2);
        }
        if (!bl) {
            return this.zzm8(zz9o.zzZYb().get("normal"));
        }
        String string2 = string != null ? zzeU.zzYjG(string) : zz9o.zzXiF(zzYzA2.zzXsi);
        return this.zzY10(zzYzA2, string2);
    }

    private Shape zzY10(String string, String string2, zzYzA zzYzA2) throws Exception {
        if (zzYzA2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        if (string2 == null) {
            string2 = zz9o.zzXiF(zzYzA2.zzXsi);
        }
        if (string != null) {
            return this.zzW1W(string, string2);
        }
        return this.zzY10(zzYzA2, string2);
    }

    private Shape zzY10(zzYzA zzYzA2, String string) throws Exception {
        if (zzYzA2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oleInfo");
        }
        byte[] byArray = zz9o.zzYAh(zzYzA2.zzXsi);
        zzYwf zzYwf2 = new zzYwf(byArray, null, string, this.getDocument().zzXwd());
        return this.zzm8(zzYwf2.zzZD5());
    }

    private Shape zzW1W(String string, String string2) throws Exception {
        zzYwf zzYwf2 = new zzYwf(string, string2, this.getDocument().zzXwd());
        return this.zzm8(zzYwf2.zzZD5());
    }

    private Shape zz4C(zzZZR zzZZR2) throws Exception {
        byte[] byArray = zzZWL.zzY9n(zzZZR2);
        return this.zzm8(byArray);
    }

    private Shape zzm8(byte[] byArray) throws Exception {
        if (byArray == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: imageBytes");
        }
        Shape shape = new Shape((DocumentBase)this.zzZaA, 1);
        shape.setShapeType(75);
        shape.zzWaY(this.zzXNn());
        shape.getImageData().setImageBytes(byArray);
        shape.setRelativeHorizontalPosition(2);
        shape.setLeft(0.0);
        shape.setRelativeVerticalPosition(2);
        shape.setTop(0.0);
        shape.setWrapType(0);
        this.insertNode(shape);
        ImageSize imageSize = shape.getImageData().getImageSize();
        shape.zzq(imageSize.getWidthPoints(), imageSize.getHeightPoints());
        return shape;
    }

    private void zzY10(CompositeNode compositeNode, int n) {
        if (n >= 0) {
            this.zzWaY(compositeNode, n);
            return;
        }
        this.zzWk(compositeNode, n);
    }

    private void zzWaY(CompositeNode compositeNode, int n) {
        zzVTH zzVTH2 = zzVTH.zzYU(compositeNode);
        Node node = null;
        while (node != compositeNode) {
            int n2;
            int n3;
            zzVTH2.zzY10(null, true, true, true, false, true);
            node = zzVTH2.getNode();
            if (zzVTH2.zzYNH() && (!node.isComposite() || node.zzZaQ() != 6 || n != 0)) continue;
            int n4 = n3 = node.isComposite() ? ((CompositeNode)node).zzZVO().length() : node.getTextLength();
            if (!zzVTH2.zzYNH() && n3 == 0 && node.isComposite() && node != compositeNode || (n2 = n) != 0 && (n -= n3) >= 0) continue;
            if (!zzVTH2.zzYNH() && node == compositeNode && compositeNode.getNodeType() == 28) {
                this.zzY10((StructuredDocumentTag)compositeNode);
                return;
            }
            this.zzY10(null, node);
            this.zzOA = n2;
            return;
        }
        throw new IllegalStateException("The character index is too large.");
    }

    private void zzY10(StructuredDocumentTag structuredDocumentTag) {
        this.zzYMC(structuredDocumentTag);
        this.zzWcS = true;
        this.zzOA = 0;
        zzXf6 zzXf62 = structuredDocumentTag.zz7w();
        switch (structuredDocumentTag.zzZaQ()) {
            case 6: {
                Node node;
                for (node = structuredDocumentTag.zzdu(); node != null && !(node instanceof Inline); node = node.getPreviousSibling()) {
                }
                if (node == null) break;
                zzXf62 = ((Inline)node).zzZ4q();
                break;
            }
            case 3: {
                Paragraph paragraph = (Paragraph)structuredDocumentTag.getChild(8, -1, true);
                if (paragraph == null) break;
                zzXf62 = paragraph.zzWaV();
                break;
            }
            default: {
                return;
            }
        }
        this.zzY10(zzXf62, true);
    }

    private void zzWk(CompositeNode compositeNode, int n) {
        zzVTH zzVTH2 = zzVTH.zzfY(compositeNode);
        while (zzVTH2.getNode() != compositeNode || !zzVTH2.zzYNH()) {
            int n2;
            Node node = zzVTH2.getNode();
            int n3 = n2 = node.isComposite() ? ((CompositeNode)node).zzZVO().length() : node.getTextLength();
            if ((n += n2) >= 0) {
                this.zzY10(null, node);
                this.zzOA = n;
                return;
            }
            while (zzVTH2.zzY10(null, false, true, true, false, true) && zzVTH2.zzYNH() && zzVTH2.getNode() != compositeNode) {
            }
        }
        throw new IllegalStateException("The character index is too small.");
    }

    private void zzWUf() {
        int n = this.zzOA;
        if (n == 0) {
            return;
        }
        this.zzOA = 0;
        Run run = zzZWL.zzY10((Object)this.getCurrentNode(), Run.class);
        if (run != null) {
            run.zzZv0(n);
        }
    }

    private Run zzZLZ(String string) {
        Run run = new Run(this.zzZaA, string, this.zzXNn());
        this.insertNode(run);
        return run;
    }

    final boolean zzzZ() {
        return !this.isAtEndOfParagraph() && this.getCurrentNode().getParentNode().getNodeType() == 17;
    }

    final int zzYaT() {
        return this.zzWD5;
    }

    final void zzYZW(int n) {
        this.zzWD5 = n;
    }

    public Node getCurrentNode() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzYSJ();
    }

    public Paragraph getCurrentParagraph() {
        if (this.isAtEndOfParagraph()) {
            return (Paragraph)this.zzYSJ();
        }
        return (Paragraph)this.zzYSJ().getAncestor(8);
    }

    public StructuredDocumentTag getCurrentStructuredDocumentTag() {
        if (this.isAtEndOfStructuredDocumentTag()) {
            return (StructuredDocumentTag)this.zzYSJ();
        }
        return (StructuredDocumentTag)this.zzYSJ().getAncestor(28);
    }

    public Story getCurrentStory() {
        return (Story)this.zzYSJ().getAncestor(Story.class);
    }

    public Section getCurrentSection() {
        return (Section)this.getCurrentStory().getParentNode();
    }

    private zzWks zzXW9() {
        zzWbS<zzWks> zzWbS2 = this.zz6m;
        if (zzWbS2.size() > 0) {
            return (zzWks)this.zz6m.peek();
        }
        return null;
    }

    private Cell zzZhB() {
        if (this.getCurrentParagraph() == null) {
            return null;
        }
        return this.getCurrentParagraph().zz1B();
    }

    private CompositeNode zzWKy() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return (CompositeNode)this.zzYSJ();
        }
        return this.zzYSJ().getParentNode();
    }

    private Node zzWWv() {
        if (this.isAtEndOfParagraph() || this.isAtEndOfStructuredDocumentTag()) {
            return null;
        }
        return this.zzYSJ();
    }

    private zzWbS<zzXf6> zzWWs() {
        if (this.zzYIW == null) {
            this.zzYIW = new zzWbS();
        }
        return this.zzYIW;
    }

    private zzWbS<zzqK> zzYqa() {
        if (this.zzZ7Z == null) {
            this.zzZ7Z = new zzWbS();
        }
        return this.zzZ7Z;
    }

    private zzWbS<zzY10> zz6q() {
        if (this.zzWZ1 == null) {
            this.zzWZ1 = new zzWbS();
        }
        return this.zzWZ1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int fontAttr) {
        return this.zzWPl.zzXlA(fontAttr);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRunAttr(int key, int revisionsView) {
        return this.zzWPl.zzYAq(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRunAttr(int fontAttr) {
        Object object = this.getFont().getStyle().zzb1(fontAttr, false);
        if (object != null) {
            return object;
        }
        return this.getParagraphFormat().getStyle().zzb1(fontAttr, true);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRunAttr(int fontAttr, Object value) {
        this.zzWPl.zzXtS(fontAttr, value);
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzX94()) {
            this.getCurrentParagraph().zzWaV().zzXtS(fontAttr, value);
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeRunAttr(int key) {
        this.zzWPl.remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRunAttrs() {
        this.zzWPl.clear();
        if (this.getCurrentParagraph() == null) {
            return;
        }
        if (this.isAtEndOfParagraph() || this.getCurrentParagraph().zzX94()) {
            this.getCurrentParagraph().zzWaV().clear();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key) {
        return this.zzWXA().zzXlA(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectParaAttr(int key, int revisionsView) {
        return this.zzWXA().zzYAq(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedParaAttr(int key) {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzYfT(key, 0);
        }
        return this.getDocument().getStyles().zzVZg().zzWa5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchParaAttr(int key) {
        DocumentBuilder documentBuilder = this;
        Object object = documentBuilder.getDirectParaAttr(key);
        if (object != null) {
            return object;
        }
        return documentBuilder.fetchInheritedParaAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setParaAttr(int key, Object value) {
        if (this.getCurrentParagraph() != null) {
            this.getCurrentParagraph().setParaAttr(key, value);
            return;
        }
        this.zzWXA().zzXtS(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeParaAttr(int key) {
        this.zzWXA().remove(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearParaAttrs() {
        this.zzWXA().clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzZQP().zzXlA(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        return this.zzZQP().zzWa5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        return this.zzZQP().zzZbP(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzZQP().zzXtS(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzZQP().clearRowAttrs();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() {
        this.zzZQP().clear();
        zzZ3z.zzYva().zzWaY(this.zzZQP());
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzXFQ().zzXlA(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        return this.zzXFQ().zzWa5(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        return this.zzXFQ().zzZbP(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        Border border = zzZWL.zzY10(value, Border.class);
        if (border != null) {
            CellFormat cellFormat = this.zzZhB() != null ? this.zzZhB().getCellFormat() : this.getCellFormat();
            border.zzY10(cellFormat);
        }
        this.zzXFQ().zzXtS(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzXFQ().clear();
    }

    private Node zzYSJ() {
        Node node = this.zzW4O != null && this.zzW4O.getParentNode() == null ? this.zzEJ : this.zzW4O;
        if (node != null && node.zzZaQ() == 2) {
            Paragraph paragraph = ((Story)node).getFirstParagraph();
            node = paragraph == null ? ((Section)node.getAncestor(2)).getBody().getFirstParagraph() : paragraph;
        }
        if (node == null) {
            node = this.getDocument().getFirstSection().getBody().getFirstParagraph();
        }
        this.zzWcS = this.zzWcS && node != null && node.getNodeType() == 28;
        return node;
    }

    private void zzYMC(Node node) {
        this.zzW4O = node;
        if (this.zzW4O != null) {
            this.zzEJ = this.zzW4O.getParentNode();
        }
        this.zzWcS = false;
    }

    private zzqK zzWXA() {
        if (this.getCurrentParagraph() != null) {
            return this.getCurrentParagraph().zzWXA();
        }
        if (this.zzZ5R == null) {
            this.zzZ5R = new zzqK();
        }
        return this.zzZ5R;
    }

    private zzZ3z zzZQP() {
        if (this.zzXW9() != null && this.zzXW9().zzcD() == 1) {
            return this.zzvq;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().getParentRow().zzZQP();
        }
        return this.zzvq;
    }

    private zzwB zzXFQ() {
        if (this.zzXW9() != null && this.zzXW9().zzcD() != 3) {
            return this.zzZ0m;
        }
        if (this.getCurrentParagraph() != null && this.getCurrentParagraph().isInCell()) {
            return this.getCurrentParagraph().zz1B().zzXFQ();
        }
        return this.zzZ0m;
    }

    static final class zzY10 {
        private zzXf6 zzWPl;
        private zzXf6 zzYlx;

        public zzY10(zzXf6 zzXf62, zzXf6 zzXf63) {
            this.zzWPl = zzXf62;
            this.zzYlx = zzXf63;
        }

        public final zzXf6 zzZ4q() {
            return this.zzWPl;
        }

        public final zzXf6 zzX4w() {
            return this.zzYlx;
        }
    }
}

