/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzWDl;
import com.aspose.words.internal.zzWeK;
import com.aspose.words.internal.zzXNU;
import com.aspose.words.internal.zzYVk;
import com.aspose.words.internal.zzZWL;
import com.aspose.words.internal.zzZZR;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzWae;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZH6 = new HashMap();
    private static HashMap<Integer, Integer> zzXfg = new HashMap();
    private static HashMap<Integer, Integer> zzZic = new HashMap();
    private static HashMap<Integer, Integer> zzXFm = new HashMap();
    private static HashMap<Integer, Integer> zzW0n = new HashMap();
    private static HashMap<Integer, Integer> zzZiM = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzZWL.zzWk(fileName, "fileName");
        try (zzXNU zzXNU2 = zzZWL.zzYc8(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzWv8(zzXNU2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzWv8(zzWeK.zzY10(stream));
    }

    static FileFormatInfo zzWv8(zzZZR zzZZR2) throws Exception {
        if (zzZZR2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzWae zzWae2 = new zzWae();
            zzZZR zzZZR3 = zzZZR2;
            zzWae zzWae3 = zzWae2;
            return zzWae2.zzWaY(zzZZR3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzWk(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzWZ(zzYVk.zzZsV(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzWl8(zzYVk.zzZsV(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzWDl.zzW20(string = zzYVk.zzo0(FileFormatUtil.zzXnA(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzWZ(FileFormatUtil.zzcH(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzWl8(FileFormatUtil.zzXnA(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzYVk.zzo0(FileFormatUtil.zzcH(saveFormat));
        if (zzWDl.zzW20(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzWl8(zzYVk.zzY2p(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzYVk.zzo0(FileFormatUtil.zzfZ(imageType));
    }

    static Exception zzWk(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static String zzVS6(int n) {
        return zzYVk.toString(FileFormatUtil.zzcH(n));
    }

    static int zzWl8(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZWL.zzY10(zzW0n, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzY1H(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzZWL.zzY10(zzZiM, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzWBi(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    private static int zzXnA(int n) {
        return zzZWL.zzY10(zzZH6, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzcH(int n) {
        return zzZWL.zzY10(zzXfg, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzfZ(int n) {
        return zzZWL.zzY10(zzZic, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzWZ(int n) {
        return zzZWL.zzY10(zzXFm, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzXb7(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzZWL.zzWaY(zzW0n, Integer.valueOf(n), Integer.valueOf(n2));
            zzZWL.zzWaY(zzXfg, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzXFm.containsKey(n)) {
                zzZWL.zzWaY(zzXFm, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzZWL.zzWaY(zzZH6, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzZWL.zzWaY(zzZiM, Integer.valueOf(n), Integer.valueOf(n4));
            zzZWL.zzWaY(zzZic, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzXb7(12, 10, 10, 1);
        FileFormatUtil.zzXb7(12, 0, 0, 1);
        FileFormatUtil.zzXb7(13, 11, 11, 1);
        FileFormatUtil.zzXb7(14, 20, 20, 1);
        FileFormatUtil.zzXb7(14, 0, 254, 1);
        FileFormatUtil.zzXb7(15, 21, 21, 1);
        FileFormatUtil.zzXb7(16, 22, 22, 1);
        FileFormatUtil.zzXb7(17, 23, 23, 1);
        FileFormatUtil.zzXb7(19, 24, 24, 1);
        FileFormatUtil.zzXb7(20, 25, 25, 1);
        FileFormatUtil.zzXb7(21, 26, 26, 1);
        FileFormatUtil.zzXb7(22, 27, 27, 1);
        FileFormatUtil.zzXb7(25, 30, 30, 1);
        FileFormatUtil.zzXb7(18, 31, 31, 1);
        FileFormatUtil.zzXb7(26, 50, 50, 1);
        FileFormatUtil.zzXb7(27, 45, 255, 1);
        FileFormatUtil.zzXb7(28, 51, 51, 1);
        FileFormatUtil.zzXb7(29, 54, 52, 1);
        FileFormatUtil.zzXb7(30, 0, 53, 1);
        FileFormatUtil.zzXb7(32, 53, 54, 1);
        FileFormatUtil.zzXb7(23, 60, 60, 1);
        FileFormatUtil.zzXb7(24, 61, 61, 1);
        FileFormatUtil.zzXb7(35, 40, 64, 1);
        FileFormatUtil.zzXb7(42, 47, 255, 1);
        FileFormatUtil.zzXb7(43, 48, 255, 1);
        FileFormatUtil.zzXb7(36, 41, 255, 1);
        FileFormatUtil.zzXb7(37, 46, 255, 1);
        FileFormatUtil.zzXb7(39, 42, 255, 1);
        FileFormatUtil.zzXb7(38, 44, 255, 1);
        FileFormatUtil.zzXb7(31, 52, 55, 1);
        FileFormatUtil.zzXb7(33, 70, 62, 1);
        FileFormatUtil.zzXb7(34, 73, 63, 1);
        FileFormatUtil.zzXb7(40, 71, 255, 1);
        FileFormatUtil.zzXb7(8, 100, 255, 1);
        FileFormatUtil.zzXb7(9, 105, 255, 1);
        FileFormatUtil.zzXb7(6, 101, 255, 6);
        FileFormatUtil.zzXb7(7, 102, 255, 7);
        FileFormatUtil.zzXb7(5, 104, 255, 5);
        FileFormatUtil.zzXb7(4, 0, 255, 4);
        FileFormatUtil.zzXb7(3, 0, 255, 3);
        FileFormatUtil.zzXb7(41, 72, 255, 1);
        FileFormatUtil.zzXb7(2, 103, 255, 2);
        FileFormatUtil.zzXb7(10, 106, 255, 8);
        FileFormatUtil.zzXb7(47, 80, 255, 1);
    }
}

