/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzCJ;
import com.aspose.words.internal.zzWbS;
import com.aspose.words.internal.zzZWL;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzVTH;
import com.aspose.words.zzVU9;
import com.aspose.words.zzX4s;
import com.aspose.words.zzYc5;
import com.aspose.words.zzYhr;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzYBB;
    private Node zzZH4;
    private Node zzXcg;
    private int zzYln;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzWk(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzYBB == null) {
            return null;
        }
        if (this.zzYBB.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzYBB;
    }

    final CompositeNode zzYNn() {
        if (zzVU9.zzWfU(this.getParentNode())) {
            return this.getParentNode().zzYNn();
        }
        return this.getParentNode();
    }

    final CompositeNode zzNH() {
        if (zzVU9.zzWfU(this.getParentNode()) || zzVU9.zzyv(this.getParentNode())) {
            return this.getParentNode().zzNH();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzYBB != null) {
            return this.zzYBB.getDocument();
        }
        return null;
    }

    final Document zzW2q() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzW8s() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzdk();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzXcg;
    }

    final Node zzWpf() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzVU9.zzp8((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzZmw() {
        Node node = zzVU9.zzZKQ(this.getPreviousSibling(), false);
        if (node == null && zzVU9.zzWfU(this.getParentNode())) {
            node = this.getParentNode().zzZmw();
        }
        return node;
    }

    final Node zzW7I() {
        Node node = zzVU9.zzYVl(this.getNextSibling(), false);
        if (node == null && zzVU9.zzWfU(this.getParentNode())) {
            node = this.getParentNode().zzW7I();
        }
        return node;
    }

    final CompositeNode zzIL() {
        Node node = this;
        while ((node = node.zzZmw()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzYCz() {
        Node node = this;
        while ((node = node.zzW7I()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzZH4;
    }

    final Node zzYJK() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzVU9.zzp8((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzUz() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzWxz() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYiy() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzVU9.zzXhM(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzXeN() {
        return this.zzZH4;
    }

    final void zzX5l(Node node) {
        this.zzZH4 = node;
    }

    final Node zzZy() {
        return this.zzXcg;
    }

    final void zzXTv(Node node) {
        this.zzXcg = node;
    }

    final Node zzZN5() {
        Node node = this;
        if (node.zzZH4 != null) {
            node = this;
            return node.zzZH4;
        }
        return this.getParentNode();
    }

    final int zzZaQ() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzVU9.zzYHI(this);
        boolean bl2 = zzVU9.zzW9q(this);
        boolean bl3 = zzVU9.zzYWJ(this);
        boolean bl4 = zzVU9.zzWNJ(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzZaQ() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzZaQ() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzY10(isCloneChildren, new zzY10(this));
    }

    Node zzY10(boolean bl, zzYc5 zzYc52) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzYBB != null) {
            node.zzYBB = this.getDocument().zz29();
        }
        node.zzZH4 = null;
        node.zzXcg = null;
        if (zzYc52 != null) {
            zzYc52.zzWJU(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzWI7(StringBuilder stringBuilder) {
        zzZWL.zzWaY(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZLA(Node node) {
        this.zzYBB = node != null ? node : this.getDocument().zz29();
    }

    final void zzWk(DocumentBase documentBase) {
        this.zzYBB = documentBase != null ? documentBase.zz29() : null;
    }

    final boolean zzYWC(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzYyR() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzWq3(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzQy(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzZR(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzWI7(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzZ20(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    public String toString(int saveFormat) throws Exception {
        zzX4s zzX4s2 = zzVU9.zzuX(saveFormat);
        return zzX4s2.zzYi(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzX4s zzX4s2 = zzVU9.zzWaY(saveOptions);
        return zzX4s2.zzYi(this);
    }

    final Node zzpd(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzVU9.zzO4(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzVTH zzZvX() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzVTH.zzfY(node);
        }
        return zzVTH.zzYU(this.getParentNode());
    }

    final zzVTH zzYGZ() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzVTH.zzYU(node);
        }
        return zzVTH.zzfY(this.getParentNode());
    }

    final boolean zzCW(Node node) {
        return Node.zzZyx(this, node);
    }

    final boolean zzXuH() {
        return this.getAncestor(1) == null;
    }

    static Node zzb0(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzWbS<Node> zzWbS2 = Node.zzVSm(node);
        zzWbS<Node> zzWbS3 = Node.zzVSm(node2);
        return Node.zzY10(zzWbS2, zzWbS3);
    }

    static boolean zzZyx(Node node, Node node2) {
        zzWbS<Node> zzWbS2;
        if (node == null || node2 == null) {
            return false;
        }
        zzWbS<Node> zzWbS3 = Node.zzVSm(node);
        Node node3 = Node.zzY10(zzWbS3, zzWbS2 = Node.zzVSm(node2));
        if (node3 == null) {
            return false;
        }
        zzWbS<Node> zzWbS4 = zzWbS3;
        if (zzWbS4.size() == 0 || (zzWbS4 = zzWbS2).size() == 0) {
            zzWbS4 = zzWbS2;
            boolean bl = zzWbS4.size() > 0;
            return bl;
        }
        Object e = zzWbS3.peek();
        Object e2 = zzWbS2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzWbS<Node> zzVSm(Node node) {
        zzWbS<Node> zzWbS2 = new zzWbS<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzWbS2.push(node2);
        }
        return zzWbS2;
    }

    private static Node zzY10(zzWbS<Node> zzWbS2, zzWbS<Node> zzWbS3) {
        Node node = null;
        while (zzWbS2.peek() == zzWbS3.peek()) {
            node = (Node)zzWbS2.pop();
            zzWbS3.pop();
            zzWbS<Node> zzWbS4 = zzWbS2;
            if (zzWbS4.size() != 0 && (zzWbS4 = zzWbS3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzYln;
    }

    public void setCustomNodeId(int value) {
        this.zzYln = value;
    }

    private String zzYEJ() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzZWL.zzY10(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzCJ.zzX0t(stringBuilder.toString());
    }

    public String toString() {
        return zzCJ.zzX0t(zzCJ.zzWaY("{0} {1}", Node.nodeTypeToString(this.getNodeType()), this.zzYEJ()));
    }

    public void dd() {
    }

    final Node zzYWJ(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzZdJ(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzYHI(int ... nArray) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && !node.zzZdJ(nArray); node = node.getPreviousSibling()) {
        }
        return node;
    }

    private boolean zzZdJ(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzY10
    implements zzYc5 {
        private Node zzYtf;
        private HashMap<Integer, Integer> zzXWI;

        zzY10(Node node) {
            this.zzYtf = node;
        }

        @Override
        public final void zzWJU(Node node, Node node2) {
            if (node == this.zzYtf) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzYhr zzYhr2 = (zzYhr)((Object)node2);
            if (this.zzXWI == null) {
                this.zzXWI = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzZWL.zzY10(this.zzXWI, Integer.valueOf(zzYhr2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzVZj();
                zzZWL.zzWaY(this.zzXWI, Integer.valueOf(zzYhr2.getIdInternal()), Integer.valueOf(n));
            }
            zzYhr2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzZWL.zzY10(this.zzXWI, Integer.valueOf(zzYhr2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzYhr2.setParentIdInternal(n2);
            }
        }
    }
}

