/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzWeK;
import com.aspose.words.zzXtF;
import com.aspose.words.zzZ2k;
import com.aspose.words.zzZfV;
import com.aspose.words.zzhh;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzhh,
Iterable<T> {
    private Node zzWlE;
    private CompositeNode zzWxo;
    private DocumentBase zzRT;
    private boolean zzXIn;
    private int zzYKP;
    private int zzWts;
    private Node zzYCs;
    private int zzym;
    private zzZ2k zzW7F;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zzZfV.zzWUp(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zzZfV(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zzZ2k matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: container");
        }
        if (matcher == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: matcher");
        }
        this.zzWxo = container;
        this.zzRT = container.getDocument();
        this.zzW7F = matcher;
        this.zzXIn = isDeep;
        this.zzXyA();
    }

    public Node get(int index) {
        try {
            this.zzYeO();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzWts == index) {
                return this.zzYCs;
            }
            int n = index - this.zzWts;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzXFv(nodeCollection.zzYCs, n);
            if (node != null) {
                this.zzWts = index;
                this.zzYCs = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzXIn) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzWxo.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzXIn) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzWxo.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzX69();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzXtF(this);
    }

    final <TNode extends Node> zzXtF<TNode> zzWM4() {
        return new zzXtF(this);
    }

    final ArrayList<Node> zzWIt() {
        return this.zzX69();
    }

    final <TValue extends Node> ArrayList<TValue> zzX69() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzWeK.zzY10(arrayList, node);
        }
        return arrayList;
    }

    private Node zzXFv(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zzXpE(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzZmc(curNode, true);
    }

    private Node zzZmc(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzWlE = node;
        do {
            node2 = this.zzWlE;
            Node node3 = this.zzXIn ? this.zzY10(true, this.zzWlE) : (this.zzWlE = this.zzW7F.zzYf0() ? this.zzWk(true, this.zzWlE) : this.zzWaY(true, this.zzWlE));
        } while (this.zzWlE != null && !this.zzW7F.zzZDL(this.zzWlE));
        return node2;
    }

    private Node zzXpE(Node node, boolean bl) throws Exception {
        while ((this.zzXIn ? this.zzY10(bl, node) : (node = this.zzW7F.zzYf0() ? this.zzWk(bl, node) : this.zzWaY(bl, node))) != null && !this.zzW7F.zzZDL(node)) {
        }
        return node;
    }

    private Node zzY10(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzWxo);
        }
        return node.previousPreOrder(this.zzWxo);
    }

    private Node zzWaY(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzWxo) {
                return this.zzWxo.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzWxo) {
            return this.zzWxo.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzWk(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzWxo ? this.zzWxo.zzz0() : node.zzW7I();
        } else {
            Node node3 = node2 = node == this.zzWxo ? this.zzWxo.zzXZS() : node.zzZmw();
        }
        if (node2 == this.zzWxo.getNextSibling() || node2 == this.zzWxo.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzYeO() {
        if (this.zzYKP != this.zzZyf()) {
            this.zzXyA();
        }
    }

    private void zzXyA() {
        this.zzYKP = this.zzZyf();
        this.zzWts = -1;
        this.zzYCs = this.zzWxo;
        this.zzym = -1;
    }

    private int zzZyf() {
        if (this.zzRT != null) {
            return this.zzRT.zzYhX();
        }
        return 0;
    }

    public int getCount() {
        this.zzYeO();
        if (this.zzym == -1) {
            this.zzym = zzXtF.zzY10(this);
        }
        return this.zzym;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzWlE;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzWxo;
    }
}

